+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-15T19:42:00-04:00"
lastmod = "2017-05-23T07:21:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495062736369/2017-05-15---Craig-Colclough.jpg.jpg"
primary_image_credit = "Photo: Chris Gloag."
publishDate = "2017-05-22T21:45:00-04:00"
related_articles = ["articles/don-pasquale-a-colorful-season-starter-at-minnesota-opera.md","articles/a-great-loss-hvorostovsky-passes-at-55.md","articles/in-review-falstaff-man-of-faults.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/craig-colclough.md"]
short_description = "Immaturity may not seem like it goes hand-in-hand with an artist who is serious about his work, but Colclough makes a great point. &quot;If you get too serious or too full of yourself or too jaded,&quot; he says, &quot;you start cutting off emotional parts of yourself that you need to use onstage.&quot; It&#039;s part of what&#039;s scary about singing or acting, to be an open, vulnerable person, in life as well as at work."
slug = "talking-with-singers-craig-colclough"
title = "Talking with singers: Craig Colclough"
+++

"It's like a mountain," says American bass-baritone [Craig Colclough](/scene/people/craig-colclough/) of his pursuit of singing. "Why the hell do people climb mountains?"

The simplified answer is, "because it's there," and in the context of an artist who's after a career onstage, that means it's about achieving greatness. "There are lots of things that I might enjoy, but that I'd be mediochre at," Colclough explains. With singing, "I have a chance to be excellent at something."

Optimistic, and with an infectious sense of living in the moment, Colclough recalls checking his first list of goals off his life's to-do list at an early age. By 23, "I had been a youth pastor, I had sung for money, and I had found the love of my life." Setting his sights on a professional career as an opera singer was never about fame, or the Met; "it simply was, 'what do I do now?'"

Simple as the decision may sound, Colclough's busy international career is a calculated, conscious decision that he checks in on regularly. He travels the world with his wife and two children (a number that will grow to three later this year), and his life outside of the rehearsal room includes everything from schlepping luggage to homeschooling his kids to exploring the world with the people closest to him.

One point of career comparison is in Colclough's younger brother, who also happens to be the bass-baritone's current voice teacher. A fellow singer, "he never did any of the larger house stuff, but he did little things with the LA Phil, the Aspen Festival." Colclough calls him a "genius", a Fulbright scholar who earned himself a paid-for education; he chose the pedagogical path over a more volatile career as a full-time performer, a decision that Colclough understands entirely. Still, the two brothers find time to "just get together and nerd out about music."

"My wife and I have a deal, that if at any point, it gets too painful, we're out," says Colclough. He's careful not to make big decisions based on short-lived frustrations; "right now, we just keep walking forward."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495396499264/2017-05-21---Tosca-MC-1550.jpg.jpg)
<figcaption>Keri Alkema as Tosca and Craig Colclough as Scarpia in the Canadian Opera Company's production of *Tosca*, 2017, photo: Michael Cooper.</figcaption>
</figure>

## "If you can't take criticism, this is not the job for you."

We spoke in Toronto, while he was singing Scarpia in the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s production of *Tosca*. It's a role that most low-voiced male singer lust for, and Colclough gets to follow up a run of Puccini performances with that other beloved role for bass-baritones, Verdi's Falstaff.

"I think everybody wants to play him," he says of Scarpia, a role that offers so many dramatic layers that the rehearsal room can become overrun with opinions. "With Scarpia, I've noticed that it's, 'I didn't like how you sang that phrase. Let me tell you everything about his subtext, about who he is, and why he would sing it differently,'" Colclough smiles at his own experience with the role.

Falstaff, on the other hand, is a vessel for the ever-curious singer to practice what he considers a vital element to any stage performer: staying in touch with one's inner child. "[Falstaff] is undeterrably optimistic, and that's something I strive for," Colclough says. "Nothing can bring him down." With the famed Shakespearean knight, that optimism doesn't necessarily lead to righteousness, but it's an outlook on life in which Colclough finds great value. 

"It's very important for me not to let the career callous the immaturity and youthfulness that is very essential to being an actor."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494891895811/2017-05-15---Colclough-2.jpg.jpg)
<figcaption>Craig Colclough, bass-baritone. Photo: Chris Gloag.</figcaption>
</figure>

Immaturity may not seem like it goes hand-in-hand with an artist who is serious about his work, but Colclough makes a great point. "If you get too serious or too full of yourself or too jaded," he says, "you start cutting off emotional parts of yourself that you need to use onstage." It's part of what's scary about singing or acting, to be an open, vulnerable person, in life as well as at work.

Vulnerability an element to the craft that not all artists master; Colclough has encountered those in the industry who approach the risks of criticism differently. "It's very weird, how the opera career obviously stresses and harms people so much, that they come in and have no realisation that they're making the work worse by being negative in the room." For singers, the negative approach can be one of self-harm, and for directors, it has a broader ripple effect. "They're making their actors less mobile and agile, because of their negativity."

"The thing I appreciate about [Paul [Curran]](/talking-with-directors-paul-curran/)," he says of his *Tosca* director at the COC, "is he could tell you something was shit, without making it personal." For Colclough, a good director is one who can "foster an environment where there's positivity and safety, emotionally." Yet there's a responsibility on the singer's side, to listen to feedback without assuming an underlying personal attack. "If you can't take criticism, this is not the job for you."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495396533702/2017-05-21---ENO-Tristan-and-Isolde-Stuart-Skelton-and-Craig-Colclough-Catherine-Ashmore.jpg.jpg)
<figcaption>Stuart Skelton (right) as Tristan and Craig Colclough as Kurwenal in ENO's production of *Tristan and Isolde*. Photo: Catherine Ashmore.</figcaption>
</figure>

## "The music gets me through a lot."

Content as he is in his work that is "so inconsistent and so sloppy, in a way," Colclough admits that, early on, he could have benefitted from a more specific picture of what a nomadic life would truly look like. "I just had this naïve assumption that it was going to function like other jobs," he says.

"Instead of saying something grandiose, like 'if you can do anything else with your life, do that,'" he prefers more specificity about what a singer will find hard to come by. "Did you grow up in a household? Did you go to school in the same place every day? Do you like having a friend that you hang out with once a month? Do you like having a spouse?" 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1495396543168/2017-05-21---Colclough-Figaro-Atlanta.jpg.jpg)
<figcaption>Lauren Snouffer as Susanna and Craig Colclough as Figaro in *Le nozze di Figaro*, The Atlanta Opera. Photo: Jeff Roffman.</figcaption>
</figure>

It's a refreshing thing, to meet a singer with the ability to steal scenes (like we remember him doing in Act III of [*Tristan and Isolde* at ENO](/in-review-tristan-and-isolde-at-eno/)), yet with the peace of mind to walk away from any part of singing that makes him more unhappy than not. Colcough seems to bring onstage that sought-after combination of so many artists: ambition, honesty, and that Falstaff-inspired inner child.

Despite the things that are hard, "the music gets me through a lot." While he continues his path forward, through Falstaffs and Don Pasquales - and Dutchmans, if he gets his way - Colclough stills thinks happily about what he would do if performing ever stopped working for him and his family. "If I didn't sing, I'd go back to education," he says, citing his kindergarten and youth group teaching experience. "I'd want to run a high school theatre, maybe a college theatre."

>For more with Craig Colclough, follow him on [Twitter](https://twitter.com/colclough_craig) and [Instagram.](https://www.instagram.com/colcloughopera/)
