+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-12-12T14:21:00-05:00"
lastmod = "2017-12-13T04:49:00-05:00"
preamble = "Baritone [Clarence Frazer](/scene/people/clarence-frazer/) strikes a fine balance between singing staple roles like Figaro in *Il barbiere di Siviglia* and Guglielmo in *Così fan tutte*, and taking on the more contemporary, like Sam in Rolfe's [*Crush*](http://calgaryherald.com/entertainment/music/opera-review-my-crush-on-rolfe-and-chattertons-latest-success) and Jean in the North American premiere of Boesman's [*Julie*](/in-review-julie/).\n\nHe is the recipient of this year's [IRCPA](http://ircpa.net/) Career Blueprint Award; he'll spend three days at National Opera Center, provided with new professional photographs, website consultation, video and audio recordings, and mentoring with professionals.\n\nIt was great to chat with Frazer about the rush he gets from working on something as collective as opera, and the special kind of patience that many young baritones need to have."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513106040682/2017-12-12---Clarence-Frazer.jpg.jpg"
publishDate = "2017-12-12T20:35:00-05:00"
related_articles = ["articles/talking-with-singers-zachary-nelson.md","articles/talking-with-singers-craig-irvin.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/calgary-opera-emerging-artist-development-program.md","scene/companies/opra-de-qubec.md"]
related_people = ["scene/people/clarence-frazer.md"]
short_description = "&quot;Only if you are 100% prepared can you make art, can you make music. This is where the fun is. This is where the passion is. This where the reward is. It&#039;s amazing when you know something so well, how rewarding the rehearsal and performance process will be, the discoveries you&#039;ll make, in the music, with your colleagues and with yourself.&quot;"
slug = "talking-with-singers-clarence-frazer"
title = "Talking with singers: Clarence Frazer"
+++

## Why do you sing professionally?

I could list many reasons why I sing professionally, but I do know there is one I always come back to. Quite simply, music is something I cannot live without. I don’t just sing professionally because "I love music" or "I like to sing" or "I like how it makes me feel" – these reasons are not enough, for me, to pursue music professionally. I know music must be in my life. 

This is advice I heard, at a very young age, from Jean Ashworth Bartle.  Someone I have the utmost respect and admiration for personally and professionally. If I am to expand a bit on this question, and focus on what specifically about the job moves my needle, I really don't need to think too hard. 

From March 2017 to August 2017 I had the absolute pleasure of singing in Harry Somers' [*Louis Riel*](/discomfort-louis-riel-at-the-coc/) with the Canadian Opera Company, National Arts Centre (Ottawa) and Opera de Québec. Not only was it a huge honour to be a part of something of this magnitude and Canadian, but more importantly it reminded me of why I keep at this very tough career choice. 

Opera is an art form which provides and encompassing experience of senses, feelings, and emotions for the listener and the artist. There was no shortage of this, here, with *Louis Riel*. Visually, aurally, musically and dramatically (I could go on), it was a buffet of riches to excite anyone in the room who was involved.

Daily, this enormous team showed and reminded me, that in order to contribute to something greater than ourselves, we sometimes need to subsume our own momentary wants and desires into the good of the whole. This is exactly what happened here. Beautiful and giving artists, caring and supportive crew members, violently talented orchestra(s), all wrapped up in pursuit of excellence, to tell a story, to change lives, to ignite important questions amongst the public, to give audience members 3 hours of time where they can forget about, though it brief, all that is going on in the world in hopes that it has somehow affected them positively. 

This is why I sing professionally.

## What do you know now about the singing career that you wish you knew 10 years ago?

There are so many things. Only worry about the things you can control; be a sponge; listen and value every piece of advice people give you; just because something might not work for you doesn't mean it isn't valuable; realizing something doesn't work for you is still learning and useful in your development. 

But I think the big one for me is what being prepared actually means. I can't tell you how much being prepared helps my process when I show up for a gig and start rehearsals. If one is under prepared, even slightly, you can't do the work required of you during the rehearsal process to take it to the next level. You're stressed about whether you know the words, or the rhythms, or the notes – trust me, this is not a comfortable feeling. 

Only if you are 100% prepared can you make art, can you make music. This is where the fun is. This is where the passion is. This where the reward is. It's amazing when you know something so well, how rewarding the rehearsal and performance process will be, the discoveries you'll make, in the music, with your colleagues and with yourself.  

To my younger self and any young singer out there: do yourself a favour, and be 100% prepared on day one. Trust me, you'll enjoy it!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1513116961503/BarberES-MC-3225.jpg.jpg)
<figcaption>Iain MacNeil (left) as Bartolo and Clarence Frazer as Figaro in the COC Ensemble Studio performance of *Il barbiere di Siviglia*, Canadian Opera Company, 2015. Photo by Michael Cooper.</figcaption>
</figure>

### How do you balance your professional development, between practicing and learning music, and tending to extra-musical things like professional mentoring and website consultation, as offered with your IRCPA Career Blueprint Award?

TIME MANAGEMENT! This cannot be a characteristic a classical singer lacks. It seems so cliché to say, but usually things are cliché for a reason and it's usually because it is a true statement and it will help. 

As you can see from your question, there are many things a singer must balance in this career. Being organized and knowing what you need and what is important to you will help you prioritize what needs more attention and in what order to attend to certain things. 

Fortunately, now for me, I have a wonderful agent, Kathy Domoney, who handles and deals with a lot of the aspects of this career I didn't enjoy so much: constant biography updates, resume updates, press and media releases, writing companies, getting me auditions, arranging travel, negotiating fees - things that at the end of the day took time away from me focusing on what I need to do, which is sing. 

Having Kathy handle these aspects has allowed me more time to focus on my job and what I need to do without the stress of the others. Her work and partnership really is invaluable to me and is a big reason I am able to maintain a healthy balance of administrative and artistic work. 

The IRCPA Career Blueprint I received adds a whole other dimension to my development which can't go unmentioned. As young singers, so much time and focus is spent on developing our voice that sadly other important aspects of having a career can be neglected. What this Blueprint offers me is a chance, for a week, to focus on my audition package, writing bios and resumes, designing and maintaining my website, all the things which are necessary to enhance my overall packaging for my product. 

Again, it's an opportunity which is invaluable to any singer and I can't thank enough Ann Summers Dossena, the IRCPA and Brett Polegato for providing me this opportunity. It is so important that opportunities like this one exist for young singers and institutions like the IRCPA need to be relevant, need to be available and must be supported.

## How do you stay sane and healthy between gigs?

It is no secret how rigorous and busy the life of a singer can be. Hotels, restaurants, air travel, train travel, being away from home, etc. For me, I find balance and normalness in never trying to change my daily routine. Whether I am on a gig or at home in between gigs, I try and eat the same, sleep the same, workout the same, communicate with my friends and family the same. 

I also like get away from opera and classical music as much as I can and do other things I enjoy. I play hockey when I can in a men's league and love to play golf in the summer. If I'm going to go to a show I'd rather see a Broadway Musical or a rock concert. I always bring my golf clubs with me on a gig, when I can. 

What we do is not what the general consensus would consider a normal career path, so I try not to draw attention or add any more stress to the obvious situation I am in. Plain and simple, we are athletes, and our bodies deserve to be treated with that respect and in that manner. Anything less is providing a disservice to my instrument's attaining its fullest potential.

### How does someone of your voice type know when they're "ready" to sing a certain role? How does patience play a part in the career of a low-voiced male singer?

I believe the answer to this is simpler than one might think. Vocally speaking, you have to know your voice and your body and what its capabilities are at any given age. This should be an obvious thing. I am a strong believer that if it feels wrong or not right or uncomfortable, then it's probably not the right time for (insert role here). Where there's smoke, there is usually fire. 

That being said, who is to say you can't try something "on for size" in private, behind closed doors, with your teacher and coach? In regards to patience, this is key and should not be ignored. There are a plethora of things outside our control as singers. Patience, however, and choosing to do something or not, is completely within one's control. For low male voices, a lot of the development of our voice happens naturally by maturity of age. As your age increases so might the richness, depth, colour, range (up or down) and strength. With these changes, inevitably comes your ability to more easily sing different repertoire. 

These changes and developments don't happen overnight, so it forces you to be patient. There is no better feeling than singing a role that feels effortless in your voice and there is no worse feeling than singing a role that feels like unnecessary work all the time. Practice often and hard, don't go soft between your ears and battle. The human body is an amazing thing. Trust me, it will let you know when it is ready.
