+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-01-18T17:15:00-05:00"
lastmod = "2018-01-18T21:19:00-05:00"
preamble = "Clare Tunney shares with many of her fellow sopranos a love for Mozart's music, and next month she'll get to indulge. She sings the role of Arminda in Ryedale Festival Opera's production of [*La finta giardiniera*](https://chilternarts.com/event/mozart-garden-disguises-la-finta-giardiniera-opera/), revived on **February 10** at the Chiltern Arts Festival.\n\nWe spoke with the British soprano about finding ease in well-crafted music for the voice, and the variety of roles still on her career wish-list."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516313471498/sq---Clare-Tunney.jpg.jpg"
publishDate = "2018-01-18T21:19:00-05:00"
related_articles = ["articles/spotlight-on-alice-privett.md"]
short_description = "&quot;Mozart writes for the voice, so it feels totally open and liberating to sing. As a performer, because all the emotion is already in his music, you just need to a vessel that delivers it, which is amazingly freeing!&quot;"
slug = "talking-with-singers-clare-tunney"
title = "Talking with singers: Clare Tunney"
+++

## What does it feel like to sing Mozart's music, when all is going well?

Mozart writes for the voice, so it feels totally open and liberating to sing. As a performer, because all the emotion is already in his music, you just need to a vessel that delivers it, which is amazingly freeing! 

Every one of his characters has a very specific voice type, but alongside this, each character has a different personality. He shows their personalities through the way that he writes for them, for example, the tessitura for my character, Arminda, is quite low for a soprano, but he does this deliberately by using the top of her range to emphasise when she is angry or threatening (which can be fairly often!). When a piece is emotional, there can be a tendency to "over-push" the voice because we want to convey the characters feelings, but this isn't a problem I find with Mozart's music because he paints the words so well.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516314235585/15.jpg.jpg)
<figcaption>Clare Tunney as Arminda in *La finta giardiniera*, Ryedale Festival Opera. Photo: Matthew Johnson.</figcaption>
</figure>

## Why do you think many singers consider his music rewarding, yet difficult? 

I think the reward is in how difficult it is! You can't really avoid a really long triplet run or a huge legato line in Mozart's music and it can take hours on end in a practice room to get his tricky arias into the body. Stamina can also be a real difficulty, whether it's just for one aria or the whole opera. For example, Susanna in *Le nozze di Figaro* is on stage for almost the entirety of the 4-hour opera. 

I personally found learning Fiordiligi's aria "Come scoglio" very daunting. I always had a fear of any kind of coloratura, so the page of triplet runs was my idea of a nightmare! But the phrasing of the run, alongside the idea that Fiordiligi is almost shaking with emotion, made it so much more human to me and gave it a really natural intent! Mozart really knew how to give the singer the energy they need to tackle these difficulties with ease. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516314248496/5.7-2.jpg.jpg)
<figcaption>(l-r) The cast of *La finta giardiniera*: Anna Harvey (Ramiro), Clare Tunney (Arminda), Robin Horgan (Podestà), Alice Privett (Sandrina), Kieran Carrel (Count Belfiore), Jessica Cale (Serpetta), Harry Thatcher (Nardo). Photo: Matthew Johnson.</figcaption>
</figure>

##  What is *La finta giardiniera* about? What do you think it says about romantic relationships?

*Finta* is definitely a show of unrequited love - each character is pursuing someone who wants someone else!  Nardo is chasing Serpetta, who is chasing the Podesta, who is in turn is after Sandrina! Then Ramiro, who has been rejected, is still after his ex Arminda, who in turn is pursuing the wealthy Count. The only exception is the relationship between the Count and Sandrina, two ex-lovers who are destined to be together... however Arminda and the rest of the characters will do their best to get in their way!

In terms of its romantic relationships, the opera is highly dramatic with a cast of very self-involved characters, and as such presents more of a heightened version of reality than reflecting genuine real-life relationships. However, we might still be able to identify with moments from our own lives feelings of hope, rejection and despair, but at the same time enjoy the ridiculous tangle of affection that the characters get caught up in.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1516314256390/IMG_1046.jpg.jpg)
<figcaption>Clare Tunney in the Royal Academy of Music's production of *Orphée aux enfers*. Photo: Robert Workman.</figcaption>
</figure>

## What operatic roles are on your wish list for the coming seasons?

So many choices! I would love to play another one of Mozart's strong women like La Contessa from *Le nozze di Figaro* or Fiordiligi from *Così fan tutte*. And after playing Arminda, I would love to venture more into other comic characters. When I was younger, I trained as a high mezzo-soprano, and I sang Cherubino. It was so much fun and I would love to play a similar character one day. However, I have been learning the role of Mimì from *La bohème* over the past few months and have performed Act IV and her arias and duet in opera scenes. I am completely in love with the music and her story, so that is definitely top of my wish list!

>[La finta giardiniera](https://chilternarts.com/event/mozart-garden-disguises-la-finta-giardiniera-opera/) plays for one night only on February 10, 7pm at the Chiltern Arts Festival. For details and ticket information, [click here.](https://chilternarts.com/event/mozart-garden-disguises-la-finta-giardiniera-opera/)
