+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-19T15:36:00-05:00"
lastmod = "2016-01-25T09:13:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453235943435/2016-01-19---Christine-Goerke---pc---Arielle-Doneson.jpg.jpg"
primary_image_credit = "Photo by Arielle Doneson."
publishDate = "2016-01-25T09:08:00-05:00"
related_articles = ["articles/talking-with-singers-othalie-graham.md","articles/talking-with-singers-nicole-cabell.md","articles/in-review-siegfried.md","articles/spotlight-on-amanda-majeski.md","articles/spotlight-on-rolando-sanz.md","articles/talking-with-singers-anna-devin.md","articles/talking-with-singers-jamie-barton.md","articles/talking-with-singers-corinne-winters.md","articles/talking-with-singers-melody-moore.md","articles/talking-with-singers-bryan-register.md","articles/what-weve-learned-by-talking-with-108-opera-singers.md","articles/spotlight-on-beth-hagerman.md","articles/talking-with-singers-lise-lindstrom.md","articles/talking-with-singers-christopher-purves.md","articles/talking-with-singers-keri-alkema.md","articles/talking-with-singers-marina-rebeka.md","articles/talking-with-singers-sondra-radvanovsky.md","articles/talking-with-singers-jessica-pratt.md","articles/talking-with-singers-jnai-bridges.md","articles/in-review-gotterdammerung-at-the-coc.md","articles/talking-with-singers-angela-gheorghiu.md","articles/talking-with-singers-ailyn-perez.md","articles/tomer-zvulun-the-atlanta-operas-intriguing-201718.md","articles/kinder-schafft-neues-die-meistersinger-von-nrnberg.md","articles/talking-with-singers-alfred-walker.md","articles/greg-jennas-roundup2017.md","articles/on-a-mental-precipice-hgos-elektra.md","articles/inflatable-beasts-vocal-brilliance-locs-siegfried.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/christine-goerke.md"]
short_description = "Her bread-and-butter roles these days are large and daunting, like Elektra, Elsa, Ariadne, and Turandot. Still, Wagner&#039;s operas ask for unique standards of its singers. &quot;I guess it&#039;s like a marathon,&quot; says Goerke, &quot;but if you&#039;re a marathon-runner who&#039;s used to running marathons, it&#039;s just a total adrenaline rush, and it feels amazing.&quot;"
slug = "talking-with-singers-christine-goerke"
title = "Talking with singers: Christine Goerke"
+++

"He's such a subliminal dude," says soprano [Christine Goerke](/scene/people/christine-goerke/), when I asked her what it was like to sing Wagner's music. "I love it, and it fits."

Goerke is currently in Toronto, to sing Brünnhilde in François Girard's production of *Siegfried*, running at the [Canadian Opera Company](/scene/people/canadian-opera-company/) until February 14; it's a signature role for her, and she's returning after her stellar performance in last season's *Die Walküre*. Her bread-and-butter roles these days are large and daunting, like Elektra, Elsa, Ariadne, and Turandot. Still, Wagner's operas ask for unique standards of its singers. "I guess it's like a marathon," says Goerke, "but if you're a marathon-runner who's used to running marathons, it's just a total adrenaline rush, and it feels amazing."

## "I feel fine!"

Finding that "great fit" is an important checkpoint in a singer's career, and it seems to be a particularly bright lightbulb-moment for singers who they discover that their voice suits Wagner. Goerke heard from her mentors what many singers do, that certain roles should be left untouched before a certain point in their lives. "I thought, there's an age, there's this magic-number age, and I'm not supposed to sing this stuff until I reach this magic number age." 

Before they gain enough experience to prove it, it can be difficult for singers to convince people that Wagner and Strauss are right for them. When it comes to the "age rule" for these roles, Goerke believes she was one of those exceptions. "In fact, I did myself a bit of a disservice, because that's what my instrument did, what my body did. I was trying so hard to be safe that I made problems for myself."

Goerke's first Wagner role was Gutrune in *Götterdämmerung*, and she admits to using lots of her time in the dressing room to look at Brünnhilde. She laughs, "it's like if you sing Clotilde in *Norma*, you're totally in the dressing room learning Norma!" During the sitzprobe as Gutrune, she got her first taste of Wagner's orchestra, "and it just felt right." Soon after, she sang Chrysothemis in Strauss' *Elektra*, and remembers thinking, "'Oh my gosh, that's a big orchestra, there are eight horns down there! And I feel fine!'"

Finding comfort in any specific repertoire is closely linked to a singer's unique physiology; the same things that separate Wagnerians from other singers, are also what give us coloratura sopranos and *bassi profundi*. "With that in mind," says Goerke, "no one person is going to be able to be a jack of all trades. There's going to be something that *that instrument* does best. You have to try things out to find out what it is, but when you find it, man, you know. You *really* know."

## "There are more of them than you!"

Singing roles like Brünnhilde takes stamina, of course, but it also takes a careful, thoughtful approach to learning the score. As she begins to fit a role into her voice, Goerke starts with broad strokes before getting into the details. "I start with three big points, and I find three peak moments," she explains. "Then I find three more, that I find to be important, but not as much. And then I find three more - and then I make my map of the mountains, and do it that way."

She says it's the only way she can approach this kind of repertoire. "There are going to be places where you're going to need to lay back. And that's not as easy to do when something's through-composed, because you're constantly telling the story. But there are times where you're involved in the story, and the scene is really not about you. So in instances like that, you pick and choose your battles." Still, Goerke leaves time in her process to try and sing a role in its entirety every two days. "My kids hate me," she laughs.

Goerke empathizes with the urge to push sound out when singing Wagner; his music is known for its enormous scale, yet the best Wagnerians capitalize on the smart orchestration underneath them. "I find, having done this for a little bit now, that it has to do with the kind of colour and the kind of focus that the singers who sing this kind of repertoire have." She's learned that cutting through a large orchestra isn't about volume, "but having the right colour to ride on top of it. Because if you try and push through something, you will lose - there are more of them than you!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1453606907035/Siegfried-4492---resized.jpg.jpg)
<figcaption>Stefan Vinke as Siegfried and Christine Goerke as Brünnhilde in the Canadian Opera Company production of *Siegfried*, 2016. Photo: Michael Cooper.</figcaption>
</figure>

## "God bless Skype and Facetime."

The roles that Goerke gets to sing are enviable to most working singers, much like her packed international schedule, which includes major houses in New York, Chicago, Paris, Sydney, Milan, Berlin, and London. Understandably, the nomadic life of an opera singer can sound romantic, as if the career comes with endless sight-seeing perks. "In fact," says Goerke, "you know the route from your apartment to rehearsal and back again, to the grocery store and back again, and then you sit in that apartment and you try and keep from getting sick, and you don't do a lot of sight-seeing, because, no play, no pay."

In recent years, she's started "being nice" to herself while on the road, springing for comfort and taxi rides when it makes the difference. And of course, "God bless Skype and FaceTime, because without it, my marriage would be over and my family would be completely on the rocks." Goerke is refreshingly honest about how difficult it is to focus on her work while staying connected with her husband and her daughters. "Those girls are everything, and they keep me on the straight and narrow, God knows, but it is *not* easy to leave them."

"I wanted to be a mom my entire life," she says, and she knows well the ironic dilemma a successful singer can face. "It was less difficult when I had nothing to tie me at home," says Goerke of her out-of-town work. "For a while it was really fun to be sort of flitting around, doing all these things, and then all of a sudden I had a reason to be home." With kids to support, Goerke found a boost of motivation to continue working, and to get serious about keeping her voice in shape.

"I have the coolest job, I love it, I'm so grateful. But it is a job, and it is so hard sometimes."

## Why Sing?

She never seems to take herself too seriously, which is why Goerke counts herself lucky for the chance to step into her roles. "I'm selfish about this, I am selfish onstage. I have the best time up there. I'm super happy that people like what I'm doing, but I am having the time of my life up there. I can't imagine doing anything else."

Plus, she knows that the Wagner bug is easy to catch. "It's just so stinkin' cool."

>Hear Christine Goerke as Brünnhilde in the Canadian Opera Company's production of *Siegfried*, running until February 14. For details and tickets, follow the box office links below.
