+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-03-23T12:32:00+00:00"
lastmod = "2016-10-18T18:11:00+01:00"
postamble = "The Canadian Opera Company presents Bizet's _Carmen_, April 12 to May 15 at the Four Seasons Centre for the Performing Arts. For details and ticket information, follow our box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458736329820/2016-03-22---Christian_van_Horn_Simon_Pauley.jpg.jpg"
primary_image_credit = "Photo by Simon Pauly."
publishDate = "2016-03-23T13:10:00+00:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md", "articles/talking-with-singers-othalie-graham.md", "articles/talking-with-singers-nicole-cabell.md", "articles/talking-with-singers-luca-pisaroni.md", "articles/lets-hear-it-for-the-basses.md", "articles/talking-with-singers-russell-thomas.md", "articles/talking-with-singers-christian-bowers.md", "articles/talking-with-singers-alfred-walker.md", "articles/a-kind-of-twisted-egotistical-apotheosis-faust-in-chicago.md", "articles/roundtable-an-operatic-triple-threat.md", "articles/talking-with-singers-jonathan-lemalu.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/christian-van-horn.md"]
short_description = "Carmen will mark Van Horn&#039;s third contract with the Canadian Opera Company, and it&#039;s a place he likes to be. &quot;It&#039;s a world-class company,&quot; he says. &quot;It always has been, but especially in the last five years, specifically since Alexander [Neef] got here, he&#039;s really turned this into a place to be. There&#039;s not a singer in the world that doesn&#039;t want to sing at COC.&quot;"
slug = "talking-with-singers-christian-van-horn"
title = "Talking with singers: Christian Van Horn"

+++
"I kind of ran from it for a long time," says American bass-baritone [Christian Van Horn](/scene/people/christian-van-horn/) of singing his first Escamillo, in the [Canadian Opera Company's upcoming production of _Carmen_](http://www.coc.ca/PerformancesAndTickets/1516Season/Carmen.aspx). He's no stranger to the opera; he has sung eight productions of Bizet's infamous work as Zuniga, and he kept his ears open during rehearsals. "I got to watch a lot of bass-baritones sing Escamillo, some had good success, some did not. I just had this great first-row view of how to do it."

Now that Van Horn has "decided to stop running" from Escamillo, one of the most notable operatic roles for a bass-baritone, he senses that the floodgates have been opened. "Once you say you'll do it, then they just multiply," he laughs.

> "I feel like I'm just now, in the last four or five years, that I'm really starting to hit my stride. I'm really singing major things."

Van Horn sees Escamillo, the bullfighter, local celebrity, and sporadic competition for Carmen's affections, as "definitely a one-dimensional guy", somewhat of a "fuctioning chess piece" in the larger story of _Carmen_. Compared to Don José, the officer who falls for the gypsy woman, Van Horn plays a character much less invested in Carmen herself. "I think he sees that everybody loves her; clearly she's the only one in the room not looking at him when he walks in." He's beautifully oblivious to the heavier goings-on between the seductive woman and Don José. "I don't think he cares other than Carmen's good-looking, and she'll do for now."

Though he may not have great responsibility as a layered character in this show, Escamillo has some of the most recognizable music in all of opera. His opening aria, "Votre toast", is more commonly known as the "Toreador Song", and with such fame comes a good deal of pressure on the singer. "It has to be good, there's no second chance. I do feel that pressure," admits Van Horn. "And it's the first thing that you do, and you don't get a chance to come out onstage and warm up a little bit. You launch into, arguably, the most famous tune opera."

He has tried out the aria in front of audiences before, and he jokes that since learning of his bullfighter costume, "I was way more concerned about fitting into the leather pants than about hitting the high Fs."

## Familiar stages and new roles

_Carmen_ will mark Van Horn's third contract with the Canadian Opera Company, and it's a place he likes to be. "It's a world-class company," he says. "It always has been, but especially in the last five years, specifically since [Alexander \[Neef\]](/alexander-neef-listening-to-music/) got here, he's really turned this into a place to be. There's not a singer in the world that doesn't want to sing at COC."

> At 6'6", Van Horn likes to sing with his feet on the ground, despite some conventional staging for the Toreador Song. "I don't think the biggest guy in the room needs to get on the table," he adds with a laugh.

Yet, is Toronto a place where Van Horn can have his first go at Escamillo, without the high stakes of other major companies like the Metropolitan Opera or Lyric Opera of Chicago? "I would never call this a try-it-out house," he says without hesitation. Performing with Canada's largest company comes with a lot of exposure and a lot of awareness throughout this global industry, and Van Horn feels that the COC is no place to attempt a new role before his confidence is in place. "This is place to go to, after that, in my opinion. While I am trying out a role here, I'm not 'trying it out', I'm doing it. It's not a test-and-see situation."

Van Horn is working for the first time with director [Joel Ivany](/scene/people/joel-ivany/), of [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/), who makes his mainstage directing debut with this production of _Carmen_. "He's soft-spoken," says Van Horn of Ivany, "and he seems to be open to things, which I love. He also has ideas, which is important, especially when you're doing things for the first time."

In rehearsal for Escamillo's mega-famous entrance, "the first thing I said to \[Joel\], I said, 'I don't really want to get on a table. Let's not be cliché and get on the stupid table'. And he said, 'Ok', and I said, 'Oh, we're going to be best friends.'" At 6'6", Van Horn likes to sing with his feet on the ground, despite some conventional staging for the Toreador Song. "I don't think the biggest guy in the room needs to get on the table," he adds with a laugh.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458736718266/2016-03-23---Boheme-Met.jpg.jpg)
<figcaption>l-r: Joshua Hopkins, Irina Lungu, Alexsei Markov, Maija Kovalevska, Joseph Calleja, and Christian Van Horn, taking a curtain call at The Metropolitan Opera's _La bohème_, 2014. Photo via christianvanhorn.com.</figcaption>
</figure>

## What is it about _Carmen_, anyway?

_Carmen_ is a wildly popular choice among singers, directors, experienced audiences, and even first-time opera goers. The fact that Van Horn is currently in the midst of his ninth production of the work attests to its omnipresence and lasting appeal. So we asked him, aside from the famous tunes, what exactly is it about Carmen that has everyone so excited?

"We all can relate to one person having the focus of a room," he suggests. "We've all seen that girl or that guy." Carmen is known for her sexy powers, yet audiences respond to what she experiences aside from being a beautiful woman. "The work is cut out for Carmen, she has to win that audience," agrees Van Horn. "It needs to be obvious why everyone's losing their brains over her. That's not easy to sell, it can't be just a one-dimensional, sultry seductress. You have to believe that this woman does this for freedom, for her ability to live, survive."

Like Escamillo, Carmen herself can be a foil to the serious, tormented Don José; yet she shares with the tenor the survivalist qualities that raise the stakes of her fun and games. "Although she is having a good time, that's not her end game. She wants to be free; she'd rather die than be anything but free."

> "When you're young and broke, it's hard to say no."

## The long game

"Nobody really takes the bass seriously before he's 30," says Van Horn with resigned humour. As a bass-baritone, he has learned that the career path varies not only from singer to singer, but is hugely dependent on one's natural voice type. "For a light lyric soprano, the clock is ticking," he says. The lifespan of high singing and flawless coloratura can be limited, and part of the process for these voices includes jumping into major roles early on.

"A bass doesn't really hit his stride until he's in his 40s, and even 50s. And so to that end, it's a slow burn, a slow progression. Your colleagues might be jumping right into major stuff, right out of a conservatory or young artist programme. We have to sit back and wait a little bit." That waiting includes making wise decisions about what to sing, and when; impatience and excitement over being offered alluring roles can lead to an early burnout. "When you're young and broke, it's hard to say no," Van Horn points out pragmatically. "You really do have to say no, because there are plenty of people who would love to throw something at you that you're not ready for."

Van Horn sees Escamillo as an indicator of stepping into his prime as a bass-baritone. "I feel like I'm just now, in the last four or five years, that I'm really starting to hit my stride. I'm really singing major things."

So, where will it all lead? "My dream role is King Philip in _Don Carlo_. That's kind of where I'd like to go for a while; and then down the line, sing Wotans, and things like that. But I'm in no rush."