+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-27T11:52:00-04:00"
lastmod = "2017-10-30T13:42:00-04:00"
preamble = "Among a saturated industry of well-trained sopranos, Canadian Charlotte Mundy has carved for herself a niche in the worlds of contemporary music and music theatre. Her critically-acclaimed performances of Schoenberg's *Pierrot Lunair*, Boulez's *Le marteau sans maître* and Feldman's *Three Voices* come along with her work in multidisciplinary projects and collaborations with exciting and experiment chamber ensembles. \n\nPresented by Toronto's Music Gallery, Mundy will join the [TAK Ensemble](http://www.takensemble.com/) next month for the world premiere of Ashkan Behzadi's new song cycle, [*Love, crystal and stone*](https://musicgallery.org/events/tak-plays-ashkan-behzadi-darren-creech/), set to texts by Federico Garcia Lorca, **November 18, 8pm** at 918 Bathurst St. We spoke with Mundy about her focus on the new and unorthodox, and the value of taking the freelancer's life by the reins."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509119457335/2017-10-27---Charlotte-Mundy.jpg.jpg"
publishDate = "2017-10-28T18:18:00-04:00"
related_articles = ["articles/spotlight-on-danielle-buonaiuto.md","articles/spotlight-on-stephanie-tritchew.md","articles/talking-with-singers-ah-young-hong.md"]
related_people = ["scene/people/charlotte-mundy.md"]
short_description = "&quot;Music has brought me incredible amounts of joy and peace, and really helped me figure out who I am. I want to give those feelings to as many people as possible.  Also, singing is my favorite thing to do and I think it&#039;s miraculous that there are people who will pay me to do it.&quot;"
slug = "talking-with-singers-charlotte-mundy"
title = "Talking with singers: Charlotte Mundy"
+++

## Why do you sing professionally?
 
Music has brought me incredible amounts of joy and peace, and really helped me figure out who I am. I want to give those feelings to as many people as possible.  Also, singing is my favorite thing to do and I think it's miraculous that there are people who will pay me to do it.
 
## What do you know about the singing career now, that you wish you knew 10 years ago?
 
Sooo many things! If I were to pick two - First, when your career is in a constant state of flux, it can be really emotionally taxing. You can counteract this and create some stability for yourself with good habits - find morning and bedtime routines you like and stick to them.  As much as possible, practice at the same time each day, and deal with email at the same time each day. Freelancers are constantly making decisions about how to spend our time, and that sucks up a lot of mental energy, so the more you can replace daily decisions with good habits, the more mental energy you'll be able to devote to your work. 
 
Second, I wish I knew that fear and failure were my friends.  Don't wait for permission or encouragement to do that thing you're attracted to and intimidated by - the things that seem scariest are often the things you care the most about. Just get started, just try it. I'm still trying to internalize that lesson, actually. But I've found it's essential when it comes to taking the reins of your own career and artistic practice.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1509119495151/2017-10-27---Charlotte-Mundy-in-performance.jpg.jpg)
<figcaption>Charlotte Mundy in performance.</figcaption>
</figure>
 
## How did you find yourself focused on performing contemporary chamber music?
 
As a teenager I was inspired by the idea that Maria Callas and Joan Sutherland changed people's very notions of what an opera singer could do. I connected them in my head to John Cage and Arnold Schoenberg, who also made people think differently about music. But when I started studying classical voice at the University of Toronto, it felt like I was being told repeatedly by my teachers to ignore my own creative instincts and instead closely imitate a pre-existing style of singing. This makes sense when you're studying a classical art form, but I found it stultifying.
 
I gravitated toward the amazing new music ensembles at the school. I felt way more at home in their way of working, it felt more egalitarian and stimulating. Around that time I learned about groups like [Alarm Will Sound](http://www.alarmwillsound.com/) and the [Bang on a Can All Stars](http://bangonacan.org/bang_on_a_can_all_stars), and decided that singing in my own scrappy new music ensemble was my true calling. I moved to NYC to study in the Contemporary Performance Program at the Manhattan School of Music, met a big group of inspiring new colleagues and friends - including with the members of TAK ensemble, who I'm touring to Toronto, Montreal and Ottawa with in November - and haven't  looked back since. 
 
## In your own opinion, what do you think makes a performance "great"?
 
A performance is great when it shocks my brain into stillness and makes me focus on the present moment. The shock can come from a really skillful, generous performance, or using sound, space, language or bodies in a way that feels totally new to me. A great performance also unites the entire audience in attention, allowing everyone in the room to have their own private experience and be intimately connected with everyone else at the same time. Magic.
 
## If you didn't sing for a living, what do you think you would do instead?
 
I might work in PR for the arts, I feel really passionate about inviting more people to experience the magic of performing arts the way I do. Alternatively I would be a programmer. They need to enjoy persistently, creatively solving puzzles, just like interpreters of new music do. But they get paid way more. 

>For details and ticket information for The Music Gallery Presents: TAK: Love, crystal and stone + Darren Creech, [click right here.](https://musicgallery.org/events/tak-plays-ashkan-behzadi-darren-creech/)
