+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-26T20:12:00+01:00"
lastmod = "2016-11-01T14:53:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477929217509/2016-10-26---Brian-Jagde---Simon-Pauly.jpg.jpg"
primary_image_credit = "Photo by Simon Pauly."
publishDate = "2016-11-01T14:33:00+00:00"
related_articles = ["articles/talking-with-singers-leah-crocetto.md","articles/talking-with-singers-bryan-register.md","articles/talking-with-singers-luca-pisaroni.md","articles/talking-with-singers-ekaterina-semenchuk.md","articles/in-review-adriana-lecouvreur-at-roh.md","articles/spotlight-on-eric-barry.md","articles/talking-with-singers-carl-tanner.md","articles/talking-with-singers-clay-hilley.md"]
related_companies = ["scene/companies/san-francisco-opera.md"]
related_people = ["scene/people/brian-jagde.md","scene/people/leah-crocetto.md"]
short_description = "&quot;You have to continue to get better,&quot; says Jagde of his constant work with his teachers and coaches. &quot;You&#039;re working really hard to just even have a job and to have a career, and now you have to keep it. The work never stops. It&#039;s not that you make it, and then you&#039;re there.&quot;"
slug = "talking-with-singers-brian-jagde"
title = "Talking with singers: Brian Jagde"
+++

"When you're stepping onto the stage at [San Francisco Opera](/scene/companies/san-francisco-opera/), you kind of forget," says [Brian Jagde](/scene/people/brian-jagde/) of the long line of famed tenors who have sung at War Memorial Opera House. He is set to sing his first Radamès, in Francesca Zambello's new production of [*Aïda*](http://sfopera.com/discover-opera/201617-season/aida/); the combination of Verdi's masterpiece and the San Francisco Opera - a major site in the history of opera in America - holds a gravity that's not lost on Jagde.

"So many historical tenors that have made either role debuts here, or just really left a mark in most of the minds of the fans here," he says, referring to the likes of Mario del Monaco, Richard Tucker, and Luciano Pavarotti. Though the pedigree is impressive, pondering it is not part of Jagde's process with Radamès, or any of the iconic tenor roles he sings. "Every one of those voices was different, and they all approached things differently," he explains. "I try to first approach everything from 'how would I do this?'"

## "It just fit better."

San Francisco Opera is somewhat of a home company for Jagde, who is an alumni of the Merola Opera Program and the coveted Adler Fellowship Program. "They basically helped me grow up," he says, adding that only months before auditioning for Merola, Jagde made the switch from baritone to tenor.

"In reality, I was always a tenor who was singing baritone," he laughs, calling the baritone label a case "true case of misdiagnosis." When Jagde pursued singing more seriously, his early mentors heard low-voice qualities in his sound. "I was forcing a colour through my cords that was a lot darker and really baritonal," he says. Yet more and more, he received feedback at auditions, asking him if he was sure he wasn't a tenor. 

After finishing his first young artists programme at Virginia Opera - where he sang as a baritone - Jagde sought out recommended teachers who would be capable of guiding him through the tenor question. One of those teachers was New York-based [Michael Paul](https://www.linkedin.com/in/michael-paul-4299b810a). "I said to him, 'I'm here to find out if I'm a tenor,' and he said, 'you're a tenor.'"

"All of a sudden, things started to click," says Jagde. "It just fit better." He was fortunate enough to pair a successful move into tenor repertoire with good timing; "things fell into place at the right time, so I was very lucky." His acceptance into the Merola and Adler programmes came less than a year after the switch, and by the time he found momentum as a tenor, "I was sort of past the stages of singing tenor Mozart rep." He dove right into Cavaradossi, Pinkerton, and Don José, all roles he has performed at San Franciso Opera. "It's funny, because while I was a baritone, all I wanted to do was sing Romantic repertoire." 

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477952857310/2016-10-31---2016-Carmen-San-Francisco-Opera-image-by-Cory-Weaver.jpg.jpg)
<figcaption>Jagde (Don José) in San Francisco Opera's *Carmen*, 2016. Photo by Cory Weaver.</figcaption>
</figure>

## "We kind of grew up here together."

Skipping the Mozart years and completing a YAP with the "wrong" *Fach* seem like odd moves along the trajectory of a successful singer, yet Jagde can't argue with the comfort of his repertoire. Of course, it's no small endorsement to have a company like San Francisco Opera on his side through his vocal transition and the launch of his career, two notable periods of change for any singer. 

With this new production of *Aïda*, Jagde gets to make a role debut surrounded by plenty of familiarity. At the podium will be Nicola Luisotti, who Jagde deems "instrumental" in his career. "He's conducted me now in multiple opera houses, some of which were because he specifically requested me," he says. "I owe him quite a bit." 

On understudy duties as an Adler Fellow, Jagde had also seen director Francesca Zambello at work. "She's so brilliant, oh my God!" Working on this *Aïda* is a chance for Jagde to think with Zambello about the characters, and how to interpret them honestly. "She doesn't try to re-write the story. It's always about enhancing the story to the core." Jagde calls it "a very traditional production, with a really, really cool set," designed by Los Angeles artist [RETNA](http://sfopera.com/about-us/people/bios/production/retna/). "It's really beautiful." 

He sings his first Radamès opposite soprano [Leah Crocetto](/talking-with-singers-leah-crocetto/), whom he met when they were both Adler Fellows. "We just got along offstage really well," he adds. He recalls when they both performed smaller roles in SFO's previous *Aïda*, directed by Jo Davies, Crocetto as the priestess, and Jagde as the messenger. "All of a sudden we jumped from doing roles that were supporting characters, to doing leading roles," he says with a smile. "We kind of grew up here together."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477952888301/2016-10-31--2016-HGO-Rusalka-by-Lynn-Lane.jpg.jpg)<figcaption>Jagde (Prince) in *Rusalka*, Houston Grand Opera, 2016. Photo by Lynn Lane.</figcaption>
</figure>

## "It's fun to play those roles."

"I really like to build slow and steady," says Jagde of the new roles he adds to his repertoire. "I really do think it wins the race." He generally takes on one or two new roles in a season; after Radamès, he'll debut as Maurizio in *Adriana Lecouvreur* at the [Royal Opera House](/scene/companies/royal-opera-house/) in February 2017. Also on the horizon are returns to Pinkerton at [Washington National Opera](/scene/companies/washington-national-opera/), and concert performances of Froh in *Das Rheingold* with the New York Philharmonic.

With all the densely dramatic characters in Jagde's repertoire, he has the onstage opportunity to unpack the good and the bad of human behaviour. "When I'm playing these tragic heroes, it's an amazing feeling," he says. "I think it's fun to play those roles, because they're the people that we all want to believe in."

With someoine like Don José, he finds it cathartic to expose the darkness in the character, "to tap into real insecurity, human insecurity that a lot of people have, and I've had in my life." A role like Pinkerton in *Madama Butterfly* is another role rich with dramatic options. "He doesn't know he's doing something bad," he says of the American Naval officer who marries - and abandons - the young, naïve Cio-Cio San. "He's a guy who's on a ship, and every other guy on that ship is also going off and finding some girl," Jagde explains. "And then he meets her, and he's sort of like, 'This is better than I thought it was going to be. This could be real.'" Giving the benefit of the doubt to one of opera's most notoriously heartless men is part of Jagde's process of finding the truth about these infamous roles.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477952938026/2016-10-31---MadamaButterfly_TeatroMassimo_2016_Image_RosallinaGarbo_2.jpg.jpg)<figcaption>Jagde (Pinkerton) in *Madama Butterfly* at Teatro Massimo. Photo by Rosallina Garbo.</figcaption>
</figure>

## "When you start to make it, it doesn't get any easier.

"I honestly never thought I was going to be an opera singer," Jagde admits. "Singing professionally, it just happened by accident." He got the opera bug by singing supporting roles in a school production of Mozart's *The Magic Flute*; "I remember being onstage and hearing the orchestration below me, and thinking 'this is the coolest thing I've ever done.'"

"My trajectory has really been a testament to things happening at the right place at the right time," he say. "I never thought I was going to reach even this level of career that I'm starting to have now."

Jagde understands well that his singing schedule is the kind that aspiring opera singers dream of. "What they don't realize, is when you start to make it, it doesn't get any easier. It gets harder." Maintaining his instrument is an ongoing job, and the hustle of the audition circuit is only one chapter of that process. "You have to continue to get better," says Jagde of his constant work with his teachers and coaches. "You're working really hard to just even have a job and to have a career, and now you have to keep it. The work never stops. It's not that you make it, and then you're there."

It also helps to have a few reasons to pursue singing. Recently, Jagde joined the advisory board for [Time In](http://timeinkids.org/), a New York-based arts initiative that brings arts education to at-risk youth. "For me, it's actually remembering where we came from, and trying to make sure we're giving back. Those are the kinds of things that make this job even more worthwhile." Outreach work began for Jagde with school tours presented by Opera Iowa and Virginia Opera, and it's something he advises any young artist to pursue with pleasure. "I continue to do that now, and it's extremely fulfilling for me to bring art and music to kids in America," he says. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1477953007395/2016-10-31---2015-Lyric-Opera-of-Chicago-Tosca.jpg.jpg)
<figcaption>Jagde (Cavaradossi) in *Tosca* at Lyric Opera of Chicago. Photo by Todd Rosenberg.</figcaption>
</figure>

"There are a lot of good things we can do with this instrument that we have," smiles Jagde of his audiences, young and old. "I love trying to make people feel things in the seat." 

"For all the reasons that people love opera - which is to sit in the seats at the opera house and hear those voices come at them and hear that orchestra and hear all this amazing music that's been written over hundreds of years - I think it's important that they realize how we're working very hard to try and make them feel something."

>Aïda runs at San Francisco Opera November 5 to December 6. For full details and ticket information, [click here.](http://sfopera.com/discover-opera/201617-season/aida/)
