+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = 2020-02-03T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_Hansel and Gretel_](https://www.sdopera.org/season/2019-2020-season/hansel-and-gretel) runs at San Diego Opera Feb. 8-16."
preamble = "Mezzo-soprano Blythe Gaissert will be singing Hansel in [San Diego Opera's _Hansel and Gretel_](https://www.sdopera.org/season/2019-2020-season/hansel-and-gretel), Feb. 8-16. The production also features soprano Sara Gartland as Gretel. The opera will be conducted by Maestro Ari Pelto and is directed by Brenna Corner."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1580745174/media/2020/02/sqBlytheGaissert_hrcmzn.jpg"
primary_image_credit = ""
related_articles = ["articles/talking-with-singers-stephen-costello.md"]
related_companies = ["scene/companies/san-diego-opera.md"]
related_people = []
short_description = "\"I feel like my voice has grown a lot in the last five years or so. Wagner is becoming more comfortable and I’m looking at some Verdi roles. I try to always learn and grow to just see what happens. Even if it's not something that becomes my wheelhouse, it's something that informs my other repertoire.\""
slug = "talking-with-singers-blythe-gaissert"
title = "Talking with singers: Blythe Gaissert"
youtube_url = ""

+++
## In Hansel and Gretel, you're playing a trouser role who's also a kid. It's a tricky balance and the music is pretty heavy. How do you pull it off?

Going to the gym, making sure that you have good conditioning physically is part of it. Vocally, you're either appropriate for the role or not. Because of the size of the orchestra, you have to be able to get through. The hardest part is balancing the full rich sound and maintaining the youth in the character.

I have two young boys who are three and eight. They give me lots of inspiration. I watch them run around and have little impulse control. That's pretty much Hansel. You have to immerse yourself in the frenetic energy of a young child – embrace the awkwardness of it.

I don't find trouser roles particularly difficult. I started doing them early on in my training. It's about carrying your energy in a different part of your body. We learn that in our acting training. Different characters, not just by sex or age, but also by status, carry things differently in the body. Once you know that, you lead with your hips, or your chest, or whatever. You embrace it and go with it.

## Would you call _Hansel and Gretel_ an opera for children or is it an opera for adults?

_Hansel and Gretel_ is for everyone in the same way that a really good Disney movie is for everyone. You have the rich orchestration, the complex music, but the story is not just for children. There's a level of it that children understand but there are also other layers that resonate with adults. There is also the sheer entertainment value of it. When I watch the old _Cinderella_ and _Sleeping Beauty_ movies from Disney with my children, I see so many things that I was not aware of as a child.

> I like the different ways I can experiment vocally. It's a lot of fun.

This particular production is very appealing to all ages. The puppets from Old Trout Puppet Workshop add a lot of visual interest and the scale that director Brenna Corner has been able to accomplish by making things so oversized that it makes us look small helps make it more interesting for everyone, not just children. She has focused on the less gruesome aspects of the story. I've seen other productions that have been made to be seen about child abuse. This one is not as dark as that. It hints at it because it's in there. It makes you questions why would those parents send those kids out so late. It makes me think about moments when you’re so stressed or tired that you maybe react more strongly than you would normally.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580745251/media/2020/02/SDOHansel2C8A0580_jvugol.jpg){{% /md %}}

<figcaption>Blythe Gaissert (on floor, left) in rehearsal for Hansel and Gretel, San Diego Opera, 2020. Photo courtesy of San Diego Opera.</figcaption>

</figure>

## You've performed a lot of new music, like _As One_ here at the San Diego Opera. How is new music different than performing the classics? Do you have a preference?

I don't really have a preference. What I enjoy about doing new work is the collaborative process in creating it and being able to create a character. It’s about being able to have a rapport with the composer and librettist. To feel you have some influence stimulates different parts of my creative brain. I also find it a luxury to be able to sing in my own language because I'm able to be even more immediate dramatically. I approach contemporary music in exactly the same way as classical and I always approach the story telling from the same place. It's the development process that's different.

## Is there a difference in the audiences they attract?

Yes, definitely, because of the subject matter. With _As One_, people have told me it's the first opera they’ve seen. They come to see it out of curiosity or because they have a trans family member or friend. Then they would like to see another opera. It's a much more diverse audience as far as their musical taste. They're not hard-core opera fans. So much contemporary music is influenced now by things like electronica, rock music, jazz. We're coming to a place where the opera that’s being composed is without genre, in that way, influenced by so many other kinds of music.

## You also perform with a classical alt-rock group called The Knells. Can you talk about that, and about doing that kind of crossover work?

[The group](http://theknells.com/) was founded by Andrew McKenna Lee who has a doctorate from Princeton in composition. He's played his solo guitar works with the LA Phil and he's produced a lot of David Little's work. There’s a great amount of interest in Europe for our music. We've had inquiries but we're usually too busy to drop everything and fly to Europe but now we’re going to a big festival in Portugal in May. It feeds another part of me and gives me inspiration. I like the different ways I can experiment vocally. It's a lot of fun.

> I find influence not always in classical music.

If it works to do other music and is helping the person to express themselves, I don't see a problem. I was told in my training by various people that I shouldn't be doing other things. I'm really glad I didn't listen because I am the artist that I am and have come to the point that I have come to where I feel like I have a different way of saying things that is completely valid.

Because I feel I have the training, it doesn't affect me technically in a negative way. It's actually been very positive, especially for new music, because it's given me a wider palate of colors to use when creating something.

## How important to you is the acting part of opera?

It's essential. I like to say I'm a singing actor. Obviously in opera, you have to be able to sing and you have to be able to express the text vocally in the best way. The acting is part of that. In my teaching, I always say if you really embrace what you’re saying in the text, it will help you sing better. It deepens the commitment physically. You’re going to engage your body, and your breath too, in a more complete way. It's so important.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1580745228/media/2020/02/Gaissert_c67xjy.jpg){{% /md %}}

</figure>

## Why do you sing?

I sing because I have to. I came to a point when I had my children when I realized there was something so much more important than I was. It was them. It made me make a choice about whether I really needed to do this, if singing was something that I had to have in my life. The answer was very obviously yes. It’s the way I express myself and the way I am able to contribute to the community in some way.

I did an interview for my son's class. He’s in the second grade. He asked what I was most proud of and how I wanted people to remember me. The answer was the same for both. I want people to remember that I made a difference in the world with my art and that I was a good mom. It's important for your children to see you do what you love.

## How did you end up singing opera?

I always sang. When I was six, I wanted to be Olivia Newton-John. My parents told me I was always a performer. I danced too and I did plays. I was doing a musical theater camp in the summers and I wanted to get better roles. I had been practicing along with my _Phantom of the Opera_ album at home and I wanted to sing the high notes better. I started lessons when I was 15 with Betty Shine, who was teaching at my local university, Lamar University, in Beaumont, Texas. She had a huge influence on me. She was the one who said I should look at Italian art songs and Schumann. I really liked it and it was a challenge. It seemed really natural to me.

> Wagner is becoming more comfortable and I’m looking at some Verdi roles.

Through the years there was a little back and forth because I didn't feel that the kind of music I was focused on as a young singer totally helped me express myself. As I discovered other kinds of music, and got involved more in contemporary music, it became clear that I could express myself the way I needed to but also have a focus on classical music.

## Do you have operatic singers from the past or present who are you heroes and heroines?

When I was first getting into classical music, I loved Cecilia Bartoli. I could listen to her _Portrait_ album over and over again. Also, Jennifer Larmore. Later on, I discovered Barbara Hannigan and Cathy Berberian and people who were into the new music form. I find influence not always in classical music. I'm a huge Glen Hansard fan. I find the way that he performs is like a master class for singers, in how to express text and be in the moment. It is from the gut and it's never exactly the same.

## Are there any singers from the past you wish you could have performed with?

Franco Corelli was so amazing. Aside from his beautiful voice, I love his musicality and intensity. I would love to have done a _Baby Doe_ with Beverly Sills. I really admire Giulietta Simionato and Fiorenza Cossotto and of course Marilyn Horne. I love singing the bel canto repertoire but I don’t unfortunately get very much opportunity to do that. Christa Ludwig is amazing and Janet Baker too. It’s not just the beautiful sound. They make exquisite sounds but their use of text is magical.

## Is bel canto one of the things you're aspiring to sing?

Every singer has their bucket list. My most desired one that I really really want to do before I die is Octavian in _Der Rosenkavalier_. The music is so incredible. That’s followed very closely by Charlotte in _Werther_, again because the music is amazing.

I feel like my voice has grown a lot in the last five years or so. Wagner is becoming more comfortable and I’m looking at some Verdi roles. I try to always learn and grow to just see what happens. Even if it's not something that becomes my wheelhouse, it's something that informs my other repertoire.

## What kind of music do you listen to?

I listen to a mixture of a lot of different things. I love jazz, like Coltrane. I like to listen to alternative vocal like Glen Hansard. I’m a huge Imogen Heap fan. I was just at the Grammys with my husband and she was the announcer for the afternoon awards. She has created gloves that allow her to be able to give hand cues to change the sounds that she's programmed. It's remarkable. It looks like she’s conducting. And Björk is also a huge influence for me. I think she’s brilliant. I like Elizabeth & the Catapult. I’m not a huge country fan but I do like classic country, which is funny because I grew up in Texas.