+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-09-16T15:01:00+01:00"
lastmod = "2016-09-19T19:12:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474035544822/2016-09-16---Audrey-Luna-credit-Brian-Kuhlmann.jpg.jpg"
primary_image_credit = "Photo: Brian Kuhlmann"
publishDate = "2016-09-19T09:22:00+01:00"
related_articles = ["articles/talking-with-singers-othalie-graham.md","articles/spotlight-on-caitlin-wood.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/royal-opera-house.md"]
related_people = ["scene/people/audrey-luna.md"]
short_description = "&quot;I can be left depleted after something as intense as premiering Exterminating Angel,&quot; says Luna. She relishes the chance to return home to Hawaii, which grounds her between high-paced singing gigs. &quot;In some way, it just fills my cup back up, and then I&#039;m ready to go out again.&quot;"
slug = "talking-with-singers-audrey-luna"
title = "Talking with singers: Audrey Luna"
+++

"That wasn't a decision," explains coloratura soprano [Audrey Luna](/scene/people/audrey-luna/) of her chosen life as an opera singer. "That wasn't a choice." 

Singing, for Luna, "was just always something that *was*." She credits her mother with spotting her star quality early on - extremely early on, in fact. "She said she named me 'Audrey Luna' because she said it sounded like a stage name," she laughs. She was born into the name Luna, and as for her mother's choice of Audrey, "'I thought it would sound good in lights,' is what she said."

Growing up, she had a strong interest in singing, and not much else. No model student in school, Luna says, "I was the teenager and the middle schooler that would go home and just listen to classical music all the time." She would use a tape player to record classical music on the radio; before she knew much about the pieces, she simply recorded "anything that I thought was beautiful."

"Funnily enough a lot of that was flute playing. I thought the higher and the faster, the better." Now, with her schedule full of roles like Zerbinetta and the Queen of the Night, Luna finds it a fond bit of foreshadowing.

The coloratura roles of Mozart and Strauss are nothing to scoff at; yet in recent seasons, Luna has made an extraordinary name for herself in the operas of Thomas Adès. She wowed audiences as Ariel in the 2012 Robert Lepage production of Adès's *The Tempest* at the Metropolitan Opera; the production is available to watch on [Met Opera on Demand](https://metopera.org/Season/On-Demand/), and it's easy to see why the *New York Times* called Adès's Ariel a "dazzling creation."

"That specific production was so extremely physical," Luna recalls of Lepage, who seemed to find inspiration for Ariel in his work with Cirque du Soleil. "I think it was my very first day," she laughs, "there were circus acrobats holding me above their head by one hand on my sternum!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474035060345/2016-09-16---Luna-Ariel---Ken-Howard.jpg.jpg)
<figcaption>Audrey Luna as Ariel in The Metropolitan Opera's *The Tempest*, 2012. Photo by Ken Howard.</figcaption>
</figure>

It's a role that looks difficult, and it's no illusion. "It was demanding in a lot of ways," Luna assures us. "I found these limits that I didn't know existed for me." Even the decision to audition for the role seemed daunting, and Luna knew full well that it could lead her career in a completely new direction. Now, she calls it "one of the best decisions of my life."

"It was good for me to know I was capable of even more, of singing even higher than I thought I could." Her initial time spent with the score had her convinced that Adès's writing was "impossible," but like any other role, she brought it to her coach. "My coach said, 'well, you're doing it!' And I said, 'I guess I *am* doing it!'"

"To sing that role, it took a different velocity and power of how the air moves through my body. It's something I'd never felt before, physically." Paired with a production that had her "running around like a little mosquito," Luna found in Ariel a new level of body engagement. "It was this different kind of core strength that I didn't know existed in my body."

This past summer at the Salzburg Festival, Luna sang Leticia in the world premiere of Adès's new opera, *The Exterminating Angel*, based on Luis Buñuel's 1962 film. She'll reprise her role when the opera comes to [The Royal Opera House](http://www.roh.org.uk/productions/the-exterminating-angel-by-tom-cairns) in Spring 2017, directed by librettist Tom Cairns and conducted by Adès himself. 

"There really isn't anything comparable to Tom's writing," says Luna when we asked about the vocal demands of her role in *Exterminating Angel*. Next to Ariel, Leticia comes with more legato, and a more all-encompassing range. "It's like he found yet another way to write for the coloratura voice." 

Adès wrote Leticia with Luna's voice in mind; that kind of flattery for a singer comes too with great responsibility, and Luna was grateful to the composer's level of communication during the early days of *The Exterminating Angel*. "He was always available via email," she says. Anything she wanted to know about potenital *ossia* options and dramatic intent, "He was just right there to answer the question."

"It was such a moment," Luna recalls of the first sing-through of *The Exterminating Angel*, with Adès in the room. "To see the little smirks on his face, the little smiles, how his face would light up hearing the people that he had envisioned singing these roles," she remembers, wishing that someone had made a "little documentary" about that part of the process. "I'll never forget how we all felt when we first heard the orchestra. It's so many colours, colours that you can't even imagine."

"It's kind of like being a part of history," she explains. "I don't take that lightly." 

## "What opera singer moves to Hawaii?"

Luna chatted with us from her home in Hawaii, which is a notably unique place for an opera singer to live. "What opera singer moves to Hawaii?" she agrees. "That makes no sense."

She calls it a "slow move" to the island. Her first professional job was for [Hawaii Opera Theatre](https://hawaiiopera.org/), and the company invited her back for two subsequent seasons. Luna realized that Hawaii was a place that kept her happy and healthy, and that "it works for me." 

"I can be left depleted after something as intense as premiering *Exterminating Angel*," says Luna. She relishes the chance to return home to Hawaii, which grounds her between high-paced singing gigs. "In some way, it just fills my cup back up, and then I'm ready to go out again."

Of course, living in the middle of the Pacific also means living far away from everything, and "travelling is a big deal for me." When her busy performing schedule keeps her away from her family, she almost always travels with her chihuahua, Roxy. "It does get boring, and it does get lonely. I got Roxy about five years ago now, and she comes on almost every job with me." 

She notes that a contract can include a fair amount of time not called to rehearsal, like when she's rehearsing for the Queen of the Night; downtime while away from home can get taxing, and Roxy helps keep Luna in a grounded routine. "I think that just keeps me sane," she adds, "just to have a reason to go outside every day, a buddy to cuddle with."

## "You just get to go to work and run around and play."

What sort of singing does Luna see for herself in future seasons? "I'd like to sing more Handel," she offers. "I sang a lot of Handel in school, and I really enjoyed it. Alcina would be lovely." She considers it an "inevitable" part of her vocal trajectory that she'll add roles like Konstanze (*Die Entführung aus dem Serail*), Lulu (*lulu*), and Violetta (*La traviata*) to her repertoire. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1474035042500/2016-09-16---Luna-Zerbinetta.jpg.jpg)
<figcaption>Audrey Luna as Zerbinetta in Virginia Opera's *Ariadne auf Naxos*, 2014.</figcaption>
</figure>

[Next month](http://audrey-luna.com/schedule/), Luna heads on tour with the Calder Quartet, to sing in Peter Eötvös's *Sirens Cycle*; after that, she'll sing Venus and Gepopo in a [tour of Ligeti's *Le grand macabre*](https://www.barbican.org.uk/music/event-detail.asp?ID=19270), semi-staged by Peter Sellars and conducted by Simon Rattle. Contemporary music is becoming a staple of Luna's calendar, yet the soprano is eager to revisit past roles, like Lucia and Lakmé. She's a lover of the rehearsal process, admitting, "How can you not, with Cunegonde, and Zerbinetta, and Gretel? You just get to go to work and run around and play."

Perhaps it's in part due to that playfulness in so many of the roles she sings, but it was a refreshing thing to hear Luna's humble, positive, and almost carefree approach to her high-pressure life. "I feel like a lot of the decisions in my life have been a series of risky ones," she says, adding that those risks, like auditioning for *The Tempest* and moving to Hawaii, were good gambles to make.

Luna's love of singing is something separate from her ability to make a living, giving her freedom of mind, and likely freedom of voice. "If I weren't making money doing it, that would be fine, too," she says. "I know I would have found a way to sing."

When we asked her why she makes singing her career, we loved her simple response: "Because I think it's the thing I was put on earth to do."

>For more with Audrey Luna, peruse her [performance schedule](http://audrey-luna.com/schedule/), and [check in with the ROH](http://www.roh.org.uk/seasons/2016-17/spring) starting in November to purchase tickets for *The Exterminating Angel*.
