+++
author = ["authors/michael-pecak.md"]
categories = "Interview"
date = "2018-12-08T20:04:00-05:00"
lastmod = "2018-12-10T10:22:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544317434795/sqArtur4_by-Andrzej-Swietlik-1000x1490.jpg.jpg"
primary_image_credit = "Artur Ruciński, baritone. Photo: Andrzej Swietlik."
publishDate = "2018-12-10T10:22:00-05:00"
related_articles = ["articles/historymaking-cast-in-chicagos-il-trovatore.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/artur-rucinski.md"]
short_description = "We discussed all things opera: the career, the &quot;life,&quot; the work, the music. Naturally, as compatriots, we touched on Polish music and reminisced on our experiences at the F. Chopin Academy of Music in Warsaw where we both studied, albeit ten years apart. We conversed in Polish. Below I provide an English translation of our conversation, edited solely to account for grammatical and syntactic necessities."
slug = "talking-with-singers-artur-ruciński"
title = "Talking with singers: Artur Ruciński"

+++
This Sunday, December 9, Chicago audiences had their final opportunity to see an unforgettable *Il trovatore*. A revival of Sir David McVicar's breathtaking production, this show features a cast that has "legendary" stamped all over it. Before the run closes, I had an opportunity to meet Polish baritone Artur Ruciński, who sings Count di Luna, and who makes a stellar LOC debut in this production.  
 
It's a privilege to meet some of Poland's operatic stars currently gracing the world’s most prestigious stages. Last season I interviewed tenor Piotr Beczała before his [vocal recital with pianist Martin Katz](/piotr-beczala/). Sitting together over some lovely pear-infused tea, Mr. Ruciński was a consummate gentleman, as thoughtful and generous in person as he is on stage.
 
We discussed all things opera: the career, the "life," the work, the music. Naturally, as compatriots, we touched on Polish music and reminisced on our experiences at the F. Chopin Academy of Music in Warsaw where we both studied, albeit ten years apart. We conversed in Polish. Below I provide an English translation of our conversation, edited solely to account for grammatical and syntactic necessities.

**Michael Pecak**: It's an exciting time for Polish opera singers of your generation. I'm thinking of singers such as tenor Piotr Beczała, baritone Mariusz Kwiecień (heard in LOC's [*Pearl Fishers*](/a-dreamy-indulgence-the-pearl-fishers-in-chicago/)), bass-baritone Tomasz Konieczny (who, together with Beczała, made an acclaimed debut at Bayreuth this past summer), soprano Aleksandra Kurzak, and yourself, of course. All of you are taking the world’s theaters by storm. 

**Artur Ruciński**: Yes, we have a strong team, it's true. It is very exciting and an honor for us to be appearing regularly at the world's most important venues.
 
**MP**: There must have been something in the water, so to say, when you all were growing up. 

**AR**: I really believe it's just simple and straightforward hard work and proving ourselves in each opportunity we take on. Of course, those opportunities increased exponentially after 1989 once the barriers — both literal and figurative — of the past finally dissolved. And we made sure to step up and reach out for every chance we could get.  

**MP**: It's certainly a boon to Polish culture and its reception abroad. Each of you has programs of Polish works that many people outside of Poland still do not know — not even in Europe and less so still in the U.S.

**MP**: Do you perform often in Poland these days? When was the last time you sang at the National Theater in your hometown of Warsaw?

**AR**: I gave a recital there earlier this year in January. At that time I was between performances in Rome of Verdi's *I masnadieri*. So, there was a recital and then a few days later I participated in a concert, again at the National Theater, relating to the centenary of Polish Independence. Unfortunately, these days, my appearances in Poland are all too rare. I would happily perform more in Warsaw since that's where my family and friends are. But, time just doesn't allow for it, sadly. In Poland, bookings are made maybe 6 months in advance or, at maximum, one year out. Currently, my calendar is already booked through 2022.
 
**MP**: How has your experience been so far here in Chicago. You're making your LOC debut in this run of *Trovatore*.

**AR**: I've been having a wonderful time in Chicago and at the Lyric with this production. I feel very comfortable here and I'm grateful for the public's warm reception of me.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544317306700/ArturRucinnski_ILTROVATORE_LyricOperaofChicago_LYR181114_074.jpg.jpg)
<figcaption>Artur Ruciński (Conte di Luna) in *Il trovatore*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
**MP**: What are your impressions of the opera scene in Europe vs. in the U.S.?

**AR**: I think things have really evened out nowadays, especially as regards the baseline quality of musicianship. One of the biggest differences, though, that I observe is the American attachment to or preference for more traditional productions. I'm not complaining about this; it suits me, actually, and aligns with my own aesthetic tastes. Of course, I don't have a prejudice against more modern productions, nor am I against helping a director realize a more contemporary vision, shall we say. But, as long as that vision and those ideas nonetheless elucidate the opera's libretto and premise - this is very important to me.
 
**MP**: This revival at LOC of McVicar's production certainly meets those criteria. 

**AR**: Yes! It's gorgeous and affecting in virtually every regard: the sets, the costumes, the staging. But above all, this production allows the audience to really see the relationships between the characters, to bear witness to their emotions, their stories. And every element complements the next, including my stellar colleagues, the conductor, the chorus, and orchestra — everyone is at the absolute highest level here. This production is truly a standout for me.
 
I feel that, unfortunately, there seems to be a tendency these days for certain directors to underrate the musical demands of a piece or to give less attention to the quality of the musical components of an opera: is this singer suited to this role vocally, does he/she really have the technique to do this or that? Of course, we are singing actors and a great deal is demanded of us. But there are directors who construct their vision of a production mainly from the perspective of theater. This is problematic. Once, a director kept telling me that I was singing too loudly. But what he genuinely didn't comprehend is that I needed to fill a 2,000 seat auditorium without a microphone. It’s those types of incidences that get very frustrating very quickly. But, in the end, these things generally have a way of working themselves out.
 
**MP**: This isn't your first time performing the Count di Luna. What is it like returning to a familiar role and a familiar score?

**AR**: There is always something new to be learned and discovered in these great works. It's a genuine pleasure for me to reopen a score after a period of time. I don't think I could ever get tired of certain roles. Certain roles fascinate me no end. And the ones that suit me especially, that sit in my voice well, those give me endless satisfaction. One such role is the Count di Luna. Whenever stepping into a new production, I always try to add a new layer to the character, both dramatically and musically, particularly those moments and nuances that bring out the character's inner complexities. Working with many different conductors and directors, one learns constantly. I mean, in a score like *Trovatore*, let's just say it: Verdi was a genius and there are great depths to be explored. It's one of the best parts of this career.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1544317357669/Artur6_by-Andrzej-Swietlik-1000x826.jpg.jpg)
<figcaption>Artur Ruciński, baritone. Photo: Andrzej Swietlik.</figcaption>
</figure>
 
**MP**: What are some bucket-list or dream roles you hope to do in the future?

**AR**: For sure more Verdi. But, I never like to rush things. I'm currently 42 years old; I'm planning that towards the end of this decade of my life I'll sing Rigoletto, Simon Boccanegra. Fairly soon I'll be making my role debut as Miller in *Luisa Miller*. Next season I'll be doing *Un ballo in maschera*. These, for me, are my next stepping stones toward heavier roles like Macbeth. Vocally, I feel like I can sing many things already. But, I make deliberate choices in how I pace my career and development as a singer, as an artist. 

From what I observe, many singers succumb to the temptation or to the pressure to sing everything and anything right away. I believe in deliberate work and careful planning. I recently sang my first Gianni Schicchi in Paris and the greatest compliment I received was when someone asked me "which time is this performing this role for you?" 

I believe there are emotional/psychological/intellectual aspects of roles that one should wait and develop in oneself before attempting on stage. One of the worst things is a superficial or shallow representation of a character. I think one of the reasons my career has the shape it does today is because I continue to make calculated plans for myself as an actor and as a singer. 
 
**MP**: What advice do you give to young singers?

**AR**: I believe one should never stop seeking more knowledge about one's vocal technique. Be open to learning from every teacher and coach you work with. Listen with critical ears to the recordings of past greats. Never merely imitate someone else, but rather follow the guidance of others towards your own unique formation, especially as regards technique. Every singer is a unique human being. There is only one vocal technique: not a German technique, or an Italian technique, but your own technique, and it's either going to be good or bad depending on how thoroughly you work toward understanding and honing your voice. Finally, be patient. This career is for intelligent people. It takes patience and thoughtful work.
***
 
*I'm grateful to LOC's Director of Media Relations Magda Krance for facilitating this meeting.*