+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-04-04T19:43:00+01:00"
lastmod = "2016-04-05T10:33:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459795500620/2016-04-04---Anna-Devin.jpg.jpg"
primary_image_credit = "Photo: Victoria Cadisch."
publishDate = "2016-04-05T09:47:00+01:00"
related_articles = ["articles/talking-with-singers-elizabeth-deshong.md","articles/talking-with-singers-leah-crocetto.md","articles/talking-with-singers-christine-goerke.md","articles/a-very-happy-20th-birthday-for-classical-opera.md"]
related_companies = ["scene/companies/welsh-national-opera.md","scene/companies/teatro-alla-scala.md"]
related_people = ["scene/people/anna-devin.md"]
short_description = "Devin feels &quot;completely at home in Handel&quot; and relishes the collaborative process of pulling the music off the page. &quot;You can&#039;t actually be wrong; you can have a difference of opinion between you and the conductor, but there&#039;s nothing to say that you&#039;re wrong. And I quite like that, because it means we can have interesting discussions about why you should do one thing and why you shouldn&#039;t do another.&quot;"
slug = "talking-with-singers-anna-devin"
title = "Talking with singers: Anna Devin"
+++

Irish soprano [Anna Devin](/scene/people/anna-devin/) was enjoying a rare week at home, when she spoke with us between performances of Susanna in [Welsh National Opera](/scene/companies/welsh-national-opera/)'s touring production of *The Marriage of Figaro*. "When you're in the UK when you're not so far from home, you can spend an awful lot of time trying to get home for a night," says Devin. "When I've had the year that I've had," she says, "I need to maximize the time I have at home, otherwise I'd never see my husband."

It's the flip side of success as a working opera singer, the sacrifice of time at home for time onstage. "That's the hard part of the job," agrees Devin, "and nobody really prepares you for it." The ability to handle a nomadic lifestyle, she says, is the difference between a singer with skills, and a singer who works year round. "You have to be able to look after yourself, you can't be overly needy, you have to be adventurous." She'd love to spend more time at home with her husband and her cat, Minnie, but as she succinctly puts it: "my passion for singing is stronger."

## A La Scala debut

Devin returns from her final *Figaro* performances in Plymouth on Sunday, and the next morning she heads to Milan to make her debut at La Scala as la bèrgere and la chauve-souris in Ravel's *L'enfant et les sortilèges*. La Scala has been on Devin's "bucket list" for a while, and she'll be visiting Milan for the first time. "It's really not a big part, so the pressure's not really massively on." Compared to her recent work as Susanna, she'll be able to enjoy some more freedom outside of the rehearsal room. "I'm really looking forward to having some time to spend doing stuff for myself, as well as having fun in Milan, getting to know the city, making some contacts over there."

## Strengths and versatility

Singing in *L'enfant* will add a bit of variety to Devin's calendar, which is more commonly filled with Handel and Mozart. She discovered early on that she had a strong connection to this music, and that her voice followed suit. "I feel completely at home in Handel and Mozart," she says. She loves the broad arc available to sopranos in Mozart's music. She's spent lots of time singing Susanna, Zerlina, Ilia, and Servilia; "I've just started looking at Fiordiligi, I hope to maybe do a Donna Elvira and that sort of thing."

Singing Handel, Devin revels in the endless options in his scores. "I love the fact that Handel gives you freedom to be a musician, and not just a singer," she explains. While some singers prefer the feeling of vocal spaciousness in the music of Puccini, Strauss, and other Romantics, Devin feels "completely at home in Handel" and relishes the collaborative process of pulling the music off the page. "You can't actually be wrong; you can have a difference of opinion between you and the conductor, but there's nothing to say that you're wrong. And I quite like that, because it means we can have interesting discussions about why you should do one thing and why you shouldn't do another."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459795840308/2016-04-04---Devin-Handel_Faramando.jpg.jpg)<figcaption>Anna Devin as Clotilde in Handel's *Faramondo*, Göttigen Handel Festival, 2014.</figcaption>
</figure>

When a singer carves out a niche for oneself, finding comfort and affinity in certain repertoire, it's often a balance between capitalizing on one's strengths, and staying versatile. Devin spent time as a Jette Parker Young Artist the [Royal Opera House](/scene/companies/royal-opera-house/), where she took advantage of a diversity of roles. "I got to look at First Nymph in *Rusalka*, I did some Donizetti, some Puccini, I did Mozart, I did some contemporary music. I'm really glad I didn't just pigeon-hole myself into Early Music."

"I think that some voices are better at doing a lot of different things, and some voices are better at doing one or two things," says Devin, "and I don't think either is better than the other. I think you have to trust that your voice will lead you in the right direction." That "right direction" can often come in conflict with the varied input young singers receive from teachers, conductors, and coaches, and Devin learned early on in her career about the subtle process of taking these notes.

She says of her time at Covent Garden, "If I had taken onboard absolutely every bit of information that everyone said, and everyone's opinion, you get so much contradiction that you would end up never singing well at all, because you'd have differing thoughts in your head the whole time." 

It can be an intimidating thing for a young singer to have a hunch about their voice, and to be advised they should go in a different direction. "Of course you can always improve, you can always progress, and I'm a great believer in that you're never the finished product." At the same time, Devin insists that it's one of the most important things for young singers to learn to do, "to take the opinions that really ring true to you, and if something doesn't, and it doesn't feel right, then discard it."

Devin has learned to differentiate between opinions and criticisms of her voice, verses of her person. "Not everyone's going to like you," she admits. "That's another thing we have to learn. Some people will really love you, and some people might really dislike your singing. And it's nothing to do with what you're doing, it's just that they don't like your voice, they don't have an affinity with the sound that you make."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459795920741/2016-04-04---JPYA_photo-Richard_H._Smith-3338_DEVIN_AS_MARIE_C_SMITH.jpg.jpg)<figcaption>Anna Devin as Marie in the Jette Parker Young Artists in the Linbury, 2012. Photo by Richard H. Smith.</figcaption>
</figure>

## Roles to look forward to

On top of her love for Mozart and Handel, Devin looks forward to the roles in her future. "I really want to sing Gilda in *Rigoletto*, and I want to sing Sophie in *Der Rosenkavalier*." She feels as though she could sing these roles right away, given the proper circumstances. "I mean, Gilda I wouldn't want to sing in a really massive house just yet." She also has her heart set on Cleopatra in *Giulio Cesare* ("That's one of my number one Handel roles that I still haven't sung."), and Giulietta in *I Capuleti e i Montecchi* ("It's a real singer's heaven, I'd say.")

But what if voice type were not a factor? "I think my number one would have to be Charlotte in *Werther*. But if it could be male or female, I'd happily sing Werther as well." On her fantasy wish list are also Salome, Butterfly, and Desdemona. "I enjoy theatre and opera that's quite, not intimate, but very direct," says Devin. "I like stuff that really gets into the nitty and gritty of the psychological part of the character." Though she'll likely never get hired to sing it, "I'd love to do Sparafucile! To sing that long, long, long note when he leaves the stage that goes on forever. Oh, it gives me tingles."

>Anna Devin has two more performances of The Marriage of Figaro at the Theatre Royal, Plymouth, on April 6th and 9th. For details and ticket information, follow our box office links below.
