+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-02T16:13:00+00:00"
lastmod = "2017-02-06T16:46:00+00:00"
preamble = "Throughout her starry career on stages from Vienna to Sydney, Romanian-born soprano [Angela Gheorghiu](/scene/people/angela-gheorghiu/) has always had a significant relationship with the Royal Opera House. She made her debut at Covent Garden in 1992, as Zerlina in *Don Giovanni*; she has since returned for what have become definitive performances of *Tosca*, *La traviata*, *La rondine*, and *La bohème*, and to sing for the 1999 reopening of the Royal Opera. She has sung for Queen Elizabeth II and Barack Obama, and her extensive discography is Grammy award-winning.\n\nThis month, Gheorghiu is back in London to sing the title role in the first revival of David McVicar's [*Adriana Lecouvreur*](http://www.roh.org.uk/productions/adriana-lecouvreur-by-david-mcvicar) at the Royal Opera, alongside American tenor [Brian Jagde](/talking-with-singers-brian-jagde/) as Maurizio. She spoke with us about maintaining her own ideals in the rehearsal room, and staying true to her art form."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486053870722/2017-02-02---Angela_Gheorgiu_pc_Cosmin_Gogu.jpg.jpg"
primary_image_credit = "Photo by Cosmin Gogu."
publishDate = "2017-02-04T09:55:00+00:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-jamie-barton.md","articles/talking-with-singers-luca-pisaroni.md","articles/in-review-adriana-lecouvreur-at-roh.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/angela-gheorghiu.md"]
short_description = "&quot;Often colleagues are scared to say &quot;no&quot;, they fear that they would no longer be invited any more. Everyone wants to be able to sing a lot. Sometimes singers want everything, too fast and too soon. Nobody really constructs a real career, a personality which may, in the future, fill the concert halls and theatres. Many colleagues have difficulties and concerns with modern productions, but once again, no-one has the courage to refuse to perform on this basis.&quot;"
slug = "talking-with-singers-angela-gheorghiu"
title = "Talking with singers: Angela Gheorghiu"
+++

## When the opera industry is as competitive as it is today, how can young singers have their opinions and voices heard without risking their career?

Where is the competition?  Because I do not see it, in that way.

Competition is when you as an artist have the power and there are at least 10 others in the world who can do the same thing as you.  Everybody does what he/she is capable of doing and not what is always the best for him/her.  Nowadays, the conditions to start a career are modest. Nobody has the courage or strength to ask for the desired title, the desired director or stage partners.  

Does the opera industry seem competitive to you?  There are the same two or three tenors or sopranos who appear in productions all over the world, regardless of which theatre. Furthermore, a new production from the Royal Opera House for example, can circulate as a new production in a number of different theatres all over the world.  This was the case with *La rondine* and *Adriana Lecouvreur*.

The young singers and my colleagues have not had the courage to say no for example to an ugly production or to a repertory that does not fit their voices.  I am very strong in this way, as I have said "no" much more frequently than "yes".

All directors rely on the physique of singers, seemingly to listen to artists with their eyes alone, forgetting about style, or whether the artists have the voice for a particular style. Often colleagues are scared to say "no", they fear that they would no longer be invited any more.  Everyone wants to be able to sing a lot.  Sometimes singers want everything, too fast and too soon.  Nobody really constructs a real career, a personality which may, in the future, fill the concert halls and theatres. Many colleagues have difficulties and concerns with modern productions, but once again, no-one has the courage to refuse to perform on this basis.  

Even eminent artists are pulled by the ears of management.  I do believe that opera managers should consult the artists because by doing things without consultation can lead to disagreements and failure.  Every director who may have strange or crazy ideas can be asked to reconsider their point of view.  I have been lucky to be able to have my career unfold in an almost ideal way.   

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486144772887/2017-02-02---JONAS-KAUFMANN-AS-MAURIZIO-ANGELA-GHEORGHIU-AS-ADRIANA-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Jonas Kaufmann (Maurizio) and Angela Gheorghiu (Adriana) in *Adriana Lecouvreur*, ROH. Photo by Catherine Ashmore.</figcaption>
</figure>

## Being such a celebrated singer, what kind of sacrifices does this imply?  

I could answer that the sacrifice is total, supreme, it's the pressure of one's own life.  I dedicated my whole life to opera worldwide.  Actually, I believe that not only a famous artist has this pressure.  I have taken everything so seriously since I finished my studies in the conservatory. The families of all artists who have an international career are sacrificed.  All have problems.  You have to have the luck that your life partner understands and supports you in everything you are doing.  A human being who is every week, or every month in a different city, a different country, in a different hotel or apartment cannot be called "ordinary".  

Changing the time zone may also change your life.  Children are never together with their parents, only during holidays. It is never easy, I can assure you.  The public may have the impression that we were born on a stage somewhere and have to be perfect for every performance for 30 years or even more. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486144944406/2017-02-02---LA-RONDINE-ANGELA-GHEORGHIU-AS-MADGA-DE-CIVRY-CATHERINE-ASHMORE.jpg.jpg)
<figcaption>Angela Gheorghiu as Magda de Civry in *La Rondine*, ROH. Photo by Catherine Ashmore.</figcaption>
</figure>

## How have you maintained your professional focus while the media was so interested in your personal life?

I did not do anything, that is why it is so interesting and the media is interested in my private life.  I do not know how I managed, but that's the truth.  All this is a mystery to me.  This year my biography will be published, but I am still living my biography and my memories.

## What do you think separates a good performance from a great one?

The difference in opera is in fact only made by the artists themselves.  It is clear that the presence of a great conductor or director helps, but I saw divine performances which did not feature stars as well.  When I see the hundreds of people queuing up for tickets in Vienna or elsewhere, I do ask myself and realise how a personality and a big talent, how an artist having the sacred fire of creation can make a difference.  And there is God, for sure!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486144991905/2017-02-02---Angela-Gheorghiu---Marguerite---Catherine-Ashmore.jpg.jpg)
<figcaption>Angela Gheorghiu as Marguerite in *Faust*, ROH. Photo by Catherine Ashmore.</figcaption>
</figure>

## Is there anything about the career that you wish you had known before you made your major debuts?

I knew from the very beginning of my career what I wanted to become.  Even in my student period between the ages of 18 – 24 , I had these plans in my mind.  At the age of 18 I was already prepared in my mind for a big career.  I was convinced that I would perform at the Royal Opera House, at the Met, in the Vienna Staatsoper and that I would make recording and films, and that is indeed exactly what happened.

I live a fulfilled dream. However, every day, I ask myself if  the people around me will accept my ideas and wishes.  I had this fear of not being accepted. I have been fighting all the time to make people understand that my "classicism" represents nothing other than the modernity of the era in which the composers created their operas. Opera is the most complex art form and I want to respect it and accept its evolution. An evolution however, should not destroy what the composer and writer created. The beauty of opera and actuality will never die, because the same score will be discovered by new generations. That is what I have tried to do and been part of and I hope will continue to do in the future as well.

>Adriana Lecouvreur plays at the Royal Opera House from February 7 March 2. Angela Gheorghiu will sing Adriana in five performances (7, 10, 17, 24, 27 February), reaching her 150th performance with The Royal Opera on 27 February.  Armenian soprano Hrachuhí Bassénz will sing the role on 21 February and 2 March. For full details and ticket information, [click here.](http://www.roh.org.uk/productions/adriana-lecouvreur-by-david-mcvicar)
