+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-09-15T13:04:00-04:00"
lastmod = "2017-09-24T23:32:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495063509/2017-09-15---Haji%2C-Andrew-Haji---Credit-Veronika-Roux.jpg.jpg"
primary_image_credit = "Photo: Veronika Roux."
publishDate = "2017-09-24T23:32:00-04:00"
related_articles = ["articles/talking-with-singers-rene-barbera.md","articles/aria-guides-una-furtiva-lagrima.md","articles/talking-with-singers-matthew-polenzani.md","articles/james-robinson-elixir.md","articles/he-saidshe-said-a-sweet-elixir-at-the-coc.md","articles/lighter-fare-vancouver-operas-the-elixir-of-love.md","articles/anticipation-cmim-aria-semifinals-part-i.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/andrew-haji.md"]
short_description = "After high school, Haji went not into music, but into computer science. After just two years - and a realization that he was miserable - he &quot;quickly abandoned ship&quot;. He took a year off, during which he met with his high school music teacher, discussing the beginnings of his plan to pursue music."
slug = "talking-with-singers-andrew-haji"
title = "Talking with singers: Andrew Haji"
+++

"You know coming in to an aria like that that the audience has some sort of expectation," says tenor [Andrew Haji](/scene/people/andrew-haji/), of the well-known ["Una furtiva lagrima"](/aria-guides-una-furtiva-lagrima/) that Nemorino sings near the finale of Donizetti's *The Elixir of Love*. "When you really get into a role, when you dig into a character, you have to make it your own. Create that aria as you're singing it.

Versatile, and with an experienced air even as a still-young tenor, Haji has kept an impressive schedule of enviable repertoire. Like the other staple tenor roles he sings (Rodolfo in *La bohème*, Alfredo in *La traviata*, and Tamino in *Die Zauberflöte*), singing Nemorino comes with an awareness of the artists and stylistic choices that have come before. "You can't emulate a well-known performance from a well-known singer just to please the audience," says Haji, who prefers to put his energy into a performance that moves his listeners. "To sing it in a way that touches the audience is even harder than singing all the notes right."

## "There's something special about Adina."

The [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s production of Donizetti's *bel canto* comedy, [*The Elixir of Love*](http://coc.ca/PerformancesAndTickets/1718Season/ElixirofLove.aspx), is directed by James Robinson, and runs at the Four Seasons Centre **October 11 to November 4**. The run will mark Haji's first professional performances of Nemorino, the young man whose lovesick pining for Adina paves the way for antics both hilarious and dangerous, eventually leading to two lovers' finding their way to each other.

"There's something special about Adina," says Haji, putting himself in Nemorino's shoes. "She's a firecracker, and I think that's very attractive to Nemorino." The pair have spent their young lives in the same small town, and the familiarity has turned - at least on Nemorino's part - into hopeless devotion for the smart, beautiful, book-loving Adina.

*The Elixir of Love* is a story so full of devices that it almost seems like a meta-tale of young love. There's unrequited passion, jealousy, a travelling salesman (or conman, depending on how you look at it), and even mention of the biggest love story of them all, *Tristan and Isolde*. Despite the storytelling tropes, Haji still sees *Elixir* as something timelessly simple. "[Nemorino]'s just completely in love with her."

Robinson's production moves the action out of the 18th-century setting in Romani's libretto, and into "Anytown, Ontario", shortly before World War I. For Haji, the 20th-century setting helps to raise the stakes of the story - and Nemorino's rash decisions - to new heights. 

"The audience knows that if I'm signing up to be a soldier, I'm heading off to war," he says. Even before Nemorino puts his life on the line by enlisting, "He's put down to a very low place. But he just keeps getting back up, because he's so hopeful that one day, Adina might actually return his love."

"It's clear that Nemorino really, really loves this girl, and he'll stop at nothing to let her know that."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1505495037203/2017-09-15---Haji-Flute-16-17-03b-MC-D-3687.jpg.jpg)
<figcaption>Andrew Haji as Tamino in the Canadian Opera Company's production of *The Magic Flute*, 2017. Photo: Michael Cooper.</figcaption>
</figure>

## "I had never taken a voice lesson."

"The COC is absolutely my home company," says Haji, whose history with the Four Seasons Centre stage started when he was a member of the COC Ensemble Studio. "Now that I'm out of the Ensemble and I'm coming back, it feels like coming home to a company that I know. I'm comfortable with the stage, I'm comfortable with all the staff here." He even has comfort in his castmates for *Elixir*, fellow COC Ensemble alumni and "good friends" [Simone Osborne](/talking-with-singers-simone-osborne/) (Adina) and [Gordon Bintner](/scene/people/gordon-bintner/) (Belcore).

For audiences in Toronto and abroad, Haji is easy to imagine as a natural staple of the operatic stage, yet as he puts it, "I almost didn't sing".

After high school, Haji went not into music, but into computer science. After just two years - and a realization that he was miserable - he "quickly abandoned ship". He took a year off, during which he met with his high school music teacher, discussing the beginnings of his plan to pursue music.

"I had never taken a voice lesson; I had never considered singing professionally as a potential career path," he recalls. Still, with few options left to him, Haji dove into singing "head first."

"Ten years later, I am so glad that I made that decision," he says. Now, with an international career that's flourishing, Haji can't quite imagine himself doing anything else. "I like having the power to affect people, to make them think or to make them feel a certain way." 

Haji still flexes his techie skills, and he has even registered [techietenor.com](https://www.techietenor.com/), where he offers IT services. "I still enjoy fixing things for people, helping people figure techie things out," says Haji. And though his may not be an equal devotion of time spent in opera and in technology, Haji certainly finds that "the two things really balance each other out." A refreshing change from the emotional heights of a life in opera, "computers gives me a break from that emotional side, from having to pour my heart out."

"If I was just singing 24/7 I'd probably go crazy," laughs Haji, half serious. Yet if you've heard him sing, his quick follow-up is no surprise:

"I love to do what I do. It's a real luxury to be able to do it."

>Andrew Haji takes the stage as Nemorino in [The Elixir of Love](http://coc.ca/PerformancesAndTickets/1718Season/ElixirofLove.aspx) at the Canadian Opera Company, October 11 to November 4. For details and ticket information, follow our box office links below.
