+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-26T12:11:00+00:00"
lastmod = "2017-03-01T10:22:00+00:00"
preamble = "[Classical Opera](scene/companies/classical-opera/) is in the third year of [MOZART 250](http://www.classicalopera.co.uk/mozart-250/), a 27-year project chronologically celebrating the works of W.A. Mozart in the 250th anniversary of their composition. On **March 21-22**, they present a fully staged production of Mozart's first dramatic work, [*The First Commandment*](http://www.classicalopera.co.uk/performances/mozart-first-commandment/), written when the composer was only 11 years old. \"In spite of its title, The First Commandment is not an overtly religious work but unfolds rather like a musical mystery play, following the story of a young drifter who sleeps off his latest bout of hedonism, as the Spirit of Christianity pleads with Justice and Compassion to save his soul and help him find deeper meaning in his life.\"\n\nClassical Opera welcomes tenor [Alessandro Fisher](/scene/people/alessandro-fisher/) in his company debut, to sing Christian in *The First Commandment*. We spoke with Fisher about his young career, his long wish list of roles to sing, and his secret passion for proper *focaccia*.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1488111119496/2017-02-10---Alessandro-Fisher.jpg.jpg"
publishDate = "2017-03-01T09:51:00+00:00"
related_articles = ["articles/ian-page-mozart-imagination.md","articles/spotlight-on-beth-hagerman.md","articles/spotlight-on-william-ford.md"]
related_companies = ["scene/companies/classical-opera.md"]
related_people = ["scene/people/alessandro-fisher.md"]
short_description = "&quot;This is my first project with them, however I&#039;ve been wanting to work with them for ages because I&#039;ve not only loved their productions and recordings, but have also only ever heard positive things about the rehearsal and production process. It’s all very well putting on a beautiful piece of music, but the atmosphere that is created in the rehearsal room is absolutely crucial in developing a positive, friendly working environment.&quot;"
slug = "talking-with-singers-alessandro-fisher"
title = "Talking with singers: Alessandro Fisher"
+++

## Why do you sing professionally?

Er, that's a tough question… My mother was herself an opera singer, and began to make the move to teaching when I was born. As a result opera was all around me right from day one, and I would even sometimes sit in on her lessons, totally enthralled. I guess that removed any kind of 'stigma' that opera sometimes has for people of my generation. My first ever CD was of *The Magic Flute* and I would listen to it wherever I went, pretty much on loop. Being surrounded by opera from such a young age totally 'normalised' it for me and there was never any doubt in my mind that a career in the arts was just as realistic a path to follow as any other, provided you're willing to work incredibly hard…! 

My mother in no way pushed me into this career, in fact she made it perfectly clear that the joy you can feel performing in front of an appreciative audience can sometimes be challenged by the crushing defeat of a rejection, or a bad review/bad feedback etc.… so I was never under any illusion that I would definitely succeed. Despite her best attempts, however, as time passed it became clear to me that there really was nothing else I would rather do. The joy, and pain, that I can feel when performing a role, or singing a Schubert song cycle, or singing any piece of music for that matter, is totally unparalleled. Singing was for me, a calling.

## Do you have any roles that are still left on your "bucket list"?

Most of them! I'm only at the beginning of my career! The very first production I was taken to see at ENO when I was only a few years old was Jonathan Miller's *Mikado*, and I have been back to see it every time it’s been revived. I’ve always said that the day I get to perform Nanki Pooh in that production I'll have achieved one of my longest-held dreams. I'd also love to play Rodolfo one day, but that’s probably quite a few years off yet!

## What do you look forward to most about working with Classical Opera?

This is my first project with them, however I've been wanting to work with them for ages because I've not only loved their productions and recordings, but have also only ever heard positive things about the rehearsal and production process. It’s all very well putting on a beautiful piece of music, but the atmosphere that is created in the rehearsal room is absolutely crucial in developing a positive, friendly working environment.

## What do you know now about the career that you wish you had known 10 years ago?

One of the many advantages of growing up surrounded by singers was that I had some idea of what I was letting myself in for when thinking about pursuing this career. That being said, it's one thing hearing about it from the people living it, and quite another living it for yourself. I have learnt that patience is almost as important as hard work. While you will derive a huge amount of satisfaction from good performances, things don't happen overnight and it really is a much more difficult and emotionally challenging path than I could possibly have foreseen at 18! I was perhaps also slightly naive to the nomadic nature of this life - living out of suitcases from one contract to the next, often having to change plans at the drop of a hat, can take its toll on friendships and relationships!

## If you didn't sing for a living, what would you do instead?

Serious answer or silly answer? I suppose I can give both… Serious answer is definitely something that would keep me within the world of opera and classical music in general. With my linguistic background I would be interested in translation (not necessarily just of opera, but of other literary texts as well) and language coaching or perhaps I could be tempted away completely and retrain in international law. 

The silly answer is to open a focacceria. Like every good Milanese boy I spent my summers on the Ligurian coast, about half an hour west of Genova - the home of focaccia. The 'focaccia' we are sold in the UK is a pale imitation of the original, so I'd love to bring one of my friends over - heir to one of the oldest baking dynasties in the village I spent my holidays in - and set up a properly authentic focacceria! Given what we Brits seem to be willing to pay for cheap-to-make Italian products (pizza/ice cream), I think we could make a fortune!!

>Classical Opera presents The First Commandment, March 21-22 at St. John's Smith Square. For more details and tickets, [click here.](http://www.classicalopera.co.uk/performances/mozart-first-commandment/)
