+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-02-11T17:09:00+00:00"
lastmod = "2017-02-20T15:31:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486833196309/2017-02-10---Ailyn-Perez---Rebecca-Fay.jpg.jpg"
primary_image_credit = "Photo: Rebecca Fay"
publishDate = "2017-02-20T10:31:00+00:00"
related_articles = ["articles/talking-with-singers-christine-goerke.md","articles/talking-with-singers-sondra-radvanovsky.md","articles/talking-with-singers-corinne-winters.md","articles/arts-money-waste.md","articles/talking-with-singers-zachary-nelson.md","articles/talking-with-singers-brenda-rae.md","articles/a-kind-of-twisted-egotistical-apotheosis-faust-in-chicago.md","articles/roundtable-an-operatic-triple-threat.md"]
related_companies = ["scene/companies/teatro-alla-scala.md","scene/companies/the-metropolitan-opera.md","scene/companies/houston-grand-opera.md"]
related_people = ["scene/people/ailyn-prez.md"]
short_description = "&quot;I would tell everybody that the work is real,&quot; she says with a laugh. &quot;Just because now you&#039;ve sung at the Metropolitan Opera or have a new production, or have reached your dream role...the work still remains.&quot; Pérez describes it as having to &quot;reintroduce yourself all the time,&quot; taking charge of her own professional choices and constantly looking ahead to the next project."
slug = "talking-with-singers-ailyn-perez"
title = "Talking with singers: Ailyn Pérez"
+++

"There's stage fright no matter where you sing," says soprano [Ailyn Pérez](/scene/people/ailyn-perez/), who's currently in Milan to sing what has become one of her signature roles, Violetta Valéry, in Liliana Cavani's production of [*La traviata*](http://www.teatroallascala.org/en/season/2016-2017/opera/traviata.html) at the famed [Teatro alla Scala](/scene/companies/teatro-alla-scala/). "Maybe it's just part of being a soprano," she muses, "but there is nothing that I sing that doesn't have a legacy behind it of great, great singers."

"I have found it helpful just to ask a fellow artist how they take courage," says Pérez of finding her place among that legacy. "Yesterday I saw Roberto Bolle, the world's most celebrated male ballet dancer, and asked him about stage fright. He gave me a beautiful response: 'Forget worrying about who is there and what will be said, and instead, give yourself over to the character and be as devoted to the moment of the story as possible.'"

With roles like Violetta and Mimì in *La bohème* becoming staple repertoire for Pérez, she is well aware of the operatic giants who have performed the same roles in past decades. "You can't get too haunted by the ghosts of the past," says Pérez. Adding some words of advice for fellow lyric sopranos, "you have to get used to it right away."

For Pérez, Verdi's beloved Violetta "never feels ordinary to me." It's a role she sings a lot, yet it demands too much to let her grow bored. "Just like any jog around the park feels different, so would singing a role," Pérez explains. When she revisits a role like Violetta, she strives to be more technically efficient, and works for "more beauty of sound"; with each new production comes a new geography of the stage and lighting. With so many variables, Pérez finds little challenge staying invested in roles she sings frequently. "A lot of that freshness comes from concentrating on doing your job."

"Violetta, in particular, has so many musical and dramatic moments that are as varied as recounting every petal of a flower," Pérez says. "There's so much care needed in crafting a good arc to portray her not only in every scene, but to develop her as naturally and powerfully as Verdi writes her. It's a much more heroic approach to the character Marguerite Gautier (inspired by the real life story of Marie Duplessis) found in Alexander Dumas, fils' *La Dame aux Camélias*."

*La traviata* marks a return to La Scala for Pérez, after her debut in 2010 as Amelia in *Simon Boccanegra*, opposite Plácido Domingo. She will be in good company once again in *Traviata*, working with maestro [Nello Santi](https://en.wikipedia.org/wiki/Nello_Santi), and sharing the stage with Leo Nucci as Giorgio Germont. "I'm very excited," she admits. Of course, to sing Verdi in Milan is no less exciting. "It's astounding when you hear Verdi played by this orchestra. There's nothing like it," she swoons. "You can tell that the people have beeen living with this music for so much time. You can hear the tradition."

"It's an extraordinary experience to work with our director Liliana Cavani, who is greatly helping us all - myself, Leo Nucci and Francesco Meli - in how we look and move while singing. She wants a more realistic approach in conversation and does away with the obvious places of movement at cadences, and technically, just singing out downstage center. It's part of becoming the character in a natural way...more real, more sincere, and ultimately, more moving and credible."

Pérez calls her collaboration with maestro Santi "a labor of love! He has shown me how to declaim and sing the text with greater pathos by changing a few breaths, portamenti, and a more caressing approach to the phrasing."

Pérez senses the strong connection that Italians have with their opera, and she loves the high level of investment in the art form. Like at opera houses worldwide, she has developed a relationship with audiences at La Scala, and she believes that well-loved operatic classics allow them to discover new talent. "There's nothing more thrilling than when the music you're expecting is sung beautifully, and acted with great care and nuance," she explains. "I think that's what's so thrilling about this art form. No one's perfect, but boy, is everyone giving their best!"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487023827261/2017-02-13---HGO-Otello-Photographer-Lynn-Lane.jpg.jpg)
<figcaption>Ailyn Pérez as Desdemona in *Otello*, Houston Grand Opera, 2014. Photo by Lynn Lane.</figcaption>
</figure>

## "Hello, role model!"

One way that Pérez recharges from her hectic performing schedule - and the emotional cost of the roles she sings - is through working with young people. She collaborates with [Time In](http://timeinkids.org/mission/), a New York-based organization that offers high-quality arts and music education to at-risk students. Pérez connected with Time In in a very 21st-century way: "I saw them on Instagram!" She met with founder Cyndie Bellen-Berthézène, whom she describes as "basically one woman times a hundred. She's quite an army in herself."

Pérez has since joined the Advisory Board for Time In, and she has worked with the students herself, introducing them to opera and even recreated the Café Momus scene from *La bohème*. "Their reality is challenging," she says of the Time In kids. "To have heard some of the background of some of the students' stories, I'm astounded." Pérez admits it would be "very difficult" to consider her own life without music, and working with at-risk youth offers some career perspective. "I come back to a better place, a healthier dose of reality when I meet these kids."

Aware that arts education is in particular peril in the 21st century, Pérez considers herself "lucky that there was music education in my school." Her work with organizations like Time In help contribute to the tangible data proving that arts and music education has enormous beneficial power. "The way we teach music, the way we learn languages, the way we're inclusive, music speaks to all of that in terms of diversity and inclusion."

"I don't think music education should be there just to make more artists," says Pérez. "It should be there because it's part of a skill, like reading and writing and science and math. It should be as foundational as that."

Though it's no substitute for quality music education, Pérez looks to outlets like Twitter and YouTube as flickers of hope for arts-curious youth today. "You have so much content now that you have access to, for no money," she explains, referring to the numerous online platforms available for streaming opera. That access is not a solution *per se*, but it's "certainly a lot to grow on." Pérez is excited by the idea of how easy it is for young people to hear opera and opera singers. "You go on YouTube, you type in [a] name, and there you go. Hello, role model."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487023775076/2017-02-13---Ailyn-Perez-Manon-in-Valencia-Photo-Credit-Tato-Baeza-Palau-de-les-Arts-Reina-Sofia.jpg.jpg)
<figcaption>Ailyn Pérez (Manon) and Vittorio Grigólo (Des Grieux) in *Manon*, Palau de les Arts Reina Sofia, Valencia, 2010. Photo by Tato Baeza.</figcaption>
</figure>

## "The work is real."

"All of the things people tell you are true," says Pérez fondly of her life as an opera singer. "It's a really tough career, you sacrifice a lot of your personal life for it." She credits her "very real and honest" mentors for being frank with her about the job; yet there exists no single Singing Career, and Pérez has still found herself surprised along the way.

"I would tell everybody that the work is real," she says with a laugh. "Just because now you've sung at the Metropolitan Opera or have a new production, or have reached your dream role...the work still remains." Pérez describes it as having to "reintroduce yourself all the time," taking charge of her own professional choices and constantly looking ahead to the next project.

Success, she has discovered, is no permanent thing. "You have so many big moments in your career that are *big* - but boy, they end. It's a really strange feeling to go through." The thrill of the work, the investment in the role, it can become all-consuming; yet when the gig is over, Pérez recalls thinking, "that's a great performance, but where's your life?"

Perhaps the most meaningful lesson Pérez has learned from her 10-year professional career has also been the most humbling. "No one cares for your own business more than you," she says. "It's up to me to choose the people I want to continue to be supportive, or who I turn to." She recalls "a lot of anxiety" at the start of her career, and being preoccupied with surrounding herself with the "right people". She now knows that her support system, no matter how loyal they may be, "they're not responsible for my ups and downs."

"It's up to me to discern and create a great support system and team. A support system goes beyond the career of singing and is more about spiritual growth, community, personal happiness, and a private life."

Pérez sympathizes with the fear that can come with shedding the mentors and champions of one's academic or pre-professional career. She offers some advice for young singers: "Just remember that it's still your own responsibility. Try not to be too afraid."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1487023871796/2017-02-13---Hamburg-Traviata-photos-by-Monika-Rittershaus.jpg.jpg)
<figcaption>Ailyn Pérez as Violetta in *La traviata*, Staatsoper Hamburg, 2014. Photo by Monika Rittershaus.</figcaption>
</figure>

## "I want all the experiences that I can pass down."

Pérez is a singer with exhaustive love for her medium. She believes in the "no small part" credo, that the collaborative recipe of opera is what thrills audiences the most. Everything that's difficult about the career - travel, unwarranted feedback, the pressure to give nothing but excellent performances - Pérez seems to funnel through her passion for singing.

"Certainly when the audience is happy, you get a lot back. But you almost can't sing just for that," she explains. She's not immune to personal investment in her work, and still finds it "really hard to separate" her voice from her person. Her travel schedule is still busy, and she has learned to build her own communities in each new city she visits. "But that ends. It's not your home."

Yet Pérez's love of singing seems strong enough to outweigh the tough stuff. "I've kind of made peace with what I'm doing," she says, knowing that little else brings her as much satisfaction. "I think the most that I can teach and offer would be based on singing," she says, adding that she would love to coach singers, but only after striving for as many of her own career milestones as she can. "First, I want all the experiences that I can pass down," she says. "The kids won't listen to me if I haven't gone out and done it."

With roles like Suor Angelica and Rusalka on her wishlist in future seasons, there still remains plenty for Pérez to strive for. "I love singing. I'm still very, very happy with what I'm doing."

>La traviata opens at Teatro alla Scala on February 28, starring Ailyn Pérez as Violetta, Francesco Meli as Alfredo, and Leo Nucci at Giorgio Germont. For details, [click here.](http://www.teatroallascala.org/en/season/2016-2017/opera/traviata.html)
