+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-12T00:13:00+01:00"
lastmod = "2017-03-29T23:13:00+01:00"
preamble = "<p>\n\tLike many others in the Canadian opera scene, I first met <a href=\"https://twitter.com/aitkramer\" target=\"_blank\">Adrian Kramer</a> as a baritone in the COC Ensemble Studio. Recently, Adrian made a dramatic and successful shift into tenor singing, and I'm not the only person who heard a truly exciting leap forward. As a natural musician and a very smart singer, I was eager to ask Adrian about what it takes to change vocal fach. Whose idea was it to move from baritone to tenor, and what kind of work was involved? Adrian offers up some fascinating insight on the question of singing comfortably and voice types.\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1490825454330/2017-03-30---Adrian-Kramer.jpg.jpg"
publishDate = "2015-02-17T14:12:00+00:00"
related_articles = ["articles/cesaroni-isis-osiris-new-opera.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/adrian-kramer.md"]
short_description = "​Like many others in the Canadian opera scene, I first met Adrian Kramer as a baritone in the COC Ensemble Studio. Recently, Adrian made a dramatic and successful shift into tenor singing, and I&#039;m not the only person who heard a truly exciting leap forward. "
slug = "talking-with-singers-adrian-kramer"
title = "Talking with singers: Adrian Kramer"
+++

<h2>What do you call good singing?</h2>
<p>
	I think it's a sense of some amount of effortlessness. When a round resonance is positioned and working optimally, you get "less is more", or whatever cliché you want, or "more bang for your buck". In the moments that I've been fortunate enough to experience some measure of that…there has been that sense of doing almost nothing. It's a matter of onset, I think, and properly placed resonance, and then everything else sort of takes care of itself, and you're free to focus on communication. That's also a big part of it, when you get offstage and you felt like you were singing well, it often is because you were performing well, and the setup was correct, so you were free to explore that other part of what we do.
</p>
<h2>Can you talk about your transition from baritone to tenor?</h2>
<p>
	It was pretty immediate. There was maybe a month or six weeks of me warming up higher, singing [arias] through, trying to see what my stamina was through. Immediately my stamina was better, because I was functioning in the proper place, and the voice just sort of sat. It had been so muscular and driven down, pressed down, airy and wobbly from tension, because I was below that resonance. When I freed myself, after about a month, it just felt like it sort of sat "in there", and it turned where it wanted to turn. I was able to carry the proper resonance down, and integrate the right amount of chest into everything.
</p>
<p>
	If there was going back to zero as a tenor, the acceleration back to something like 60 % was really quick. Even that 60% was so much more healthful than what my 90% had been as a baritone.
</p>
<figure data-type="quote">
<blockquote>
	There were some people who said "I think you're a tenor", but nobody was willing to say, "you're a tenor and you should switch now".<br>
	
</blockquote>
</figure>
<p>
	The first time I actually sang anything publicly as a tenor was some excerpt pieces from <em>Die schöne</em> <em>Müllerin </em>in the tenor key, which I'd performed as a baritone. I started to well up during one of them, because I'd never felt that freedom of resonance, and ability to communicate with my voice in what I felt was a free and honest way. That was a very moving moment for me as a performer.
</p>
<h2>When was the tenor question first posed?</h2>
<p>
	The suggestion was peppered throughout my first ten years of singing. There was a split camp idea about me. A lot of people thought, "Oh no, you're a <a href="http://en.wikipedia.org/wiki/Baritone#Bariton.2FBaryton-Martin" target="_blank">Baryton-Martin</a>; you're so sensitive; it's a beautiful sound; for opera, it'll be a specific thing, but you'll do it well; as a recitalist it's so worthwhile".
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428793847855/KramerRBA-Chris-Hutcheson.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ucj7oR1FB59VY2u8WoBbzaPOIfg86EAAfy0moebq96BQjd0WuSAtjK59HDxoDHxvHqvCUe1emEVgLLoZkgItSUhMVd0" src="http://lh3.googleusercontent.com/ucj7oR1FB59VY2u8WoBbzaPOIfg86EAAfy0moebq96BQjd0WuSAtjK59HDxoDHxvHqvCUe1emEVgLLoZkgItSUhMVd0=s1200"></a><figcaption>Photo: Chris Hutcheson</figcaption></figure>
<p>
	There were some people who said "I think you're a tenor", but nobody was willing to say, "you're a tenor and you should switch now". No teachers, no coaches, nobody wanted to be, I think, accountable if it didn't work. That's fair enough; the relationships between a singer and a coach, or a singer and a teacher are delicate things. It's a great deal of trust that has to be given, and I just didn't run into anyone who wanted to take that particular bull by the horns. That was also a valuable lesson for me to learn, that people care, and people are interested, but nobody cares as much as you do. I realized that I was the only one who was going to take ownership of it and do it.
</p>
<figure data-type="quote">
<blockquote>
	I had great concerns about what was happening technically, and I wasn't able to fix them.<br>
	
</blockquote>
</figure>
<p>
	There was always the suggestion, and I toyed with it at the last year of my being at the COC Ensemble [Studio], and it just wasn't right. And of course it wasn't right; I was singing the Jailer and Marullo and covering Dandini and singing Sid in <em>Albert Herring</em> or whatever it was. That's what can't happen; it can't happen overnight. You don't have that structure built, that musculature, that muscle memory. You can't just free it up and start singing Tamino. You <em>can</em>scream high Cs, and I was always able to do that as a baritone; but sustaining that <em>tessitura</em>, it's taken me at least a year of re-learning and re-training that musculature.
</p>
<h2>What was your process of developing tenor technique?</h2>
<p>
	I finished my time at the Canadian Opera Company, and I found work was getting more inconsistent, and of course that's part of the reality of leaving a young artist programme, too. But also, I had great concerns about what was happening technically, and I wasn't able to fix them, and I had 12 years of experience working technically. No teachers were able to really fix them. My greatest concern was the middle, which, you know, if your middle and your<em>passaggio</em> aren't sounding healthy, there's an issue. But it was wobbly, it was airy, it was out of tune, I couldn't at times fully engage my sound. I only had the option of something colourful and artistic.
</p>
<p>
	I moved home for a summer, and just started re-tooling and singing at a wall. And after four or five months of that I, through that process, talked to my friend Topher Mokrzewski about playing through some things. He was immediately very encouraging about it, and so I screamed at him a few times. The first people to really be supportive of it were <a href="http://www.juilliard.edu/faculty/marlena-kleinman-malas?destination=node/19630" target="_blank">Marlena</a>[Malas], when she was visiting Toronto, who I sang some arias for, and <a href="http://schmopera.com/wendy-nielsen-on-teaching-singing/" target="_blank">Wendy</a> [Nielsen], and<a href="http://www.thestar.com/entertainment/music/2012/08/26/canadian_opera_companys_alexander_neef_hides_in_plain_sight.html" target="_blank">Alexander</a> [Neef]. When you have ears like that, and experts of that ilk confirming that you're making the right decision, because it's a scary one to make, that was very helpful in my deciding to continue above and beyond my gut knowledge that clearly this was the right thing.
</p>
<h2>Have you met anyone skeptical of your new <em>fach</em>?</h2>
<p>
	Not one. The really encouraging thing is that everybody who's new, who never heard me as a baritone, I've had them say, "Well, you only made the switch a year ago, and it sounds very natural and right." And everybody who I worked with as a baritone and subsequently heard me as a tenor, every single coach, conductor and teacher is like "Yeah, absolutely". Alexander [Neef] actually said after hearing me, "Well, the good news is you're definitely a tenor".
</p>
<p>
	There have been no nay-sayers in that regard. Lots of people have said, "Oh, I always knew you were a tenor".
</p>
<p>
	It's not just a vocal change, it's a branding change, it's an identity change, the kind of things you're cast for, how you're thought of. Everybody says, "It's not only a more natural vocalism, but this is how you look, how you seem, it makes sense now."
</p>
<p>
	For more Adrian, follow him on <a href="https://twitter.com/aitkramer" target="_blank">Twitter</a>.
</p>
