+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2018-05-26T17:25:00-04:00"
lastmod = "2018-05-29T09:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527459289056/_LPP4373.jpg.jpg"
primary_image_credit = "Photo: Liviu Popa."
publishDate = "2018-05-27T18:16:00-04:00"
related_articles = ["articles/talking-with-singers-michael-fabiano.md","articles/interviewing-the-greats-virginia-zeani.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
short_description = "I have different favorite singers, especially for the roles that I am singing. For Traviata, it&#039;s the great Virginia Zeani or Anna Moffo, for Konstanze in Entführung it&#039;s Eda Moser. For her interpretation, energy on stage, and the passion that goes into the singing, it&#039;s of course Maria Callas."
slug = "talking-with-singers-adela-zaharia"
title = "Talking with singers: Adela Zaharia"
+++

*Adela Zaharia is singing the role of Gilda at the LA Opera from May 27 to June 3, 2018. She was the first place winner of the 2017 Operalia competition. She hails from Arad in Romania and currently lives in Dusseldorf, where she has a contract with Deutsche Oper am Rhein.*

### How early did you know that you wanted to be a singer, and specifically an opera singer?

I started studying piano when I was six and then switched to music theory. I was actually preparing for the admission exam in the musicology section of the music academy. Then in my last year of high school, I participated in a singing competition for students my age and I received the first prize. That came as a big surprise but it also raised questions about whether I should pursue singing and if that could actually be what I was supposed to do.

### What influenced you in that decision?

I come from a modest background and my parents had nothing to do with the music world. But out of four children, three of us ended up as professional musicians. My brother is a conductor and teacher in a music high school and my sister sings in the Philharmonic choir back home.

I started singing early, in church, so I always knew I could sing and had some talent. I continued singing with the high school choir but I never gave much thought to pursuing it as a career. I was taking private singing lessons to help me with the small solos in school concerts and this is how I came to be prepared for the competition. I will remember forever: I sang two songs and "Deh vieni, non tardar", Susanna's aria
from *Le Nozze di Figaro*. That was such a demanding aria for me at that time. It is so lovely when I remember how I was struggling with it.

### Did you like opera at an early age?

My first contact with opera came very late when I was already in tenth or eleventh grade. We don't have an opera company in Arad, so the first performance I ever saw was *Die Fledermaus* performed by a company that was touring. I was fascinated and very intrigued. I might say I see a pattern here. The things that I find most complicated and intriguing are the ones that catch my interest the most.

After high school, I went to the music academy in Cluj, in the heart of Transylvania, 250 kilometers from home. I got my bachelor's degree there and then a master's degree. The situation was extremely difficult in Romania at that time. As a young singer you had almost no chance at a permanent contract in an opera house and I couldn't make a living from the ocasional concerts I was offered. So things were not looking promising at all. 

In my last year, I got to do an audition in Berlin, my first audition outside of Romania. The agency I was working with at the time asked me to go to a second, unplanned audition later that day at the Komische Oper. They immediately offered me a two-year contract in their young artists program. I was one of the lucky people to get my first contract right after my studies.

From there, things started moving and I was offered a contract with Deutsche Oper am Rhein in Dusseldorf, where I had the fantastic chance to debut dream roles like Konstanze, Donna Anna, Lucia, and Gilda this season. To go directly from being in the young artists program to singing these roles in an important operahouse was more than I could have hoped for. It was and still is a very good place for me to develop.

### With so much nowadays about the #metoo movement and as so many women speak out about having been sexually assaulted, is the story of *Rigoletto* relevant to us today? How do you go beyond making Gilda just another naïve victim?

It is written in the music. In the third act, when Gilda is brought to the palace after being kidnapped from her father's home, she says loud and clear that she still loves the Duke. It's an intriguing question for me - how much of all that did she consider abusive and an aggression? Was it just the horrible moment of kidnapping or also what is implied to have happened in the Duke's chambers? It is strange after everything that's happened, when she says that she loves him and will love him no
matter what he does. This nuance is often highlighted and used in modern
productions of *Rigoletto* in the second act.

I think today's women would react differently. Many opera scenarios seem
impossible in this day and age. So many of the social relations in *Rigoletto* would be completely unrealistic. I don't even think we can start comparing our modern society norms with those of that specific era. Women today are infinitely more powerful after centuries of struggle. I like to think that Gilda could not be as naïve today.

With all the roles that I sing, I take into consideration all the details of the story, the time when it was written, the social circumstances, and the history. That gives a better understanding of the psychologically build of the character. The LA Opera production is a classical *Rigoletto* production, so when I perform it, I try to transpose myself to that era. I need to put the modern woman and singer aside so that I can portray a believable character that's completely integrated in Victor Hugo's story. With modern productions, the situation of course changes and more of the story can be interpreted or filtered through our personal modern perspective.

### As this is your first time performing in the U.S., do your expectations from different audience change the way you might perform?

I don't let the circumstances I sing in affect my performance. When I prepare for a performance and go on stage, I go with the same mindset and determination, as well as the same adrenaline rush, no matter where or what I sing. I'm aware that audiences are very different, even from city to city, not to mention from country to country. Of course, when I get feedback from the audience, it motivates me. It makes the evening more exciting, more uplifting. However I cannot let it affect me if I don't receive the same visible feedback. I try to perform 100% every evening and I can only hope I will offer a memorable evening and a time worth spending in the opera house.

### What was it like singing in the Operalia Competition, and working with Plácido Domingo?

The entire Operalia experience has been a dream for me. I honestly didn't realize what was happening until a few days after, when I was at home and unpacking. I was never one of those singers who knew they would make it. It has been a very complicated journey, with downs just as extreme as the ups, so Operalia was my "I made it" moment - and such an overwhelming one. This is why I cried like a child when I was awarded the first prize. And now I don't have any decent looking photos of that moment (laughing). While I was there, it was a carousel of emotions and a constant rush. On top of that, I got to work with Maestro Domingo. 

Thinking about it beforehand, I was extremely intimidated but when I met him after the second round, as we were talking about the repertoire we would choose for the third round, the first thing that struck me was how human, warm and open he is. After shaking hands with him and seeing what an amazing and generous person he is, after seeing the good and positive energy that surrounds him, I couldn't be nervous anymore during the coaching. I was just ready to take in all the tips and knowledge he had to share. I was like a sponge trying to assimilate as much as I could.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527459347591/HDAdela.jpg.jpg)
<figcaption>Adela Zaharia, soprano. Photo: Kartal Karadegik.</figcaption>
</figure>

### Who are your operatic influences?

The history of opera singers is so vast and there are so many that were exceptional in their repertoire. I have different favorite singers, especially for the roles that I am singing. For *Traviata*, it's the great Virginia Zeani or Anna Moffo, for Konstanze in *Entführung* it's Eda Moser. For her interpretation, energy on stage, and the passion that goes into the singing, it's of course Maria Callas. For belcanto, it is the fantastic Mariella Devia. I'm the kind of singer who takes a bit from everyone. There were and are so many extraordinary singers in every voice type. I try to take the positives from every singer and learn from that.

### Do you ever wish you could have performed with one of the great singers of the past, maybe one of your idols?

[Rather than dreaming about singing with iconic singers of the past] I do dream about singing with current legends. I've had the chance to sing with Ludovic Tezier and I was extremely impressed. I also had the luck to sing with Piotr Beczala and it was such an uplifting experience. Both were pure lessons in singing technique. Being in the presence of good singers and singing together not only motivates me but literally helps me sing better. I am very receptive and this is why I have stage partners that I love to perform with. I sing better just by hearing them by my side. 

It might sound silly but this is the reason why I am very careful about what recordings I listen to because I could just as easily adopt unhealthy singing habits. When I prepare a role debut, I avoid listening to it performed by other singers. This is how I've done it till now and this is what works the best for me. I first strictly study what the music tells me, together with the libretto and the literature that inspired it. Then of course I work with coaches until I get to a point where I have my version, where it feels comfortable and I have a clear vision about it, both technically and from the interpretation point of view. Only after that will I listen to a few versions, sung by singers that I admire and who have some vocal similarities with me. That's only after I've done the whole process by myself. It's because I don't want to adopt any of the habits or be influenced by the mannerisms of any particular singer. That is what made each one of them unique and it cannot serve us in the exact same way. We also have to acknowledge that we don't sing today the way they used to sing 100 years ago, or to be honest, not even 20 years ago. This is why, while I may appreciate a singer's vocal technique, it does not automatically mean I also like how it is put to use. I try to find my own way before searching for inspiration. Individuality is very important for me. One of the most flattering critiques for my Lucia was that I sung and played it like Donizetti would have written it for me. For me that is a huge compliment. It means I have found my way to it, that my voice worked together with my body and gave a very personal and intimate performance, BEING Lucia for a few hours.

### What role does social media like Twitter and Facebook and YouTube have in your career and also in opera?

Before Operalia I didn't pay any attention [to social media] as a singer. I had a private profile but that's all. Since, I've become more and more aware of the importance of social media, but I'm still a baby at it, still figuring it out.

I do it now out of respect for the people who are interested in my journey as a singer and because there are so many people out there who are genuinely happy and supportive of my work. I must say though I am not the kind of person who feels the need to share every thought and every moment of the day or thousands of selfies. I swore to myself I would keep it real on social media. Life is not only rainbows and butterflies, and being an opera singer is not only glamour and high-class events. So yeah, some might be disappointed!

One of the aspects that's also very important, and I wish I could do more about it, is to offer recordings to the public around the world. Not everyone gets to see a live performance and many people ask for recordings but you can't offer much because of rights. It is so important to be visible and luckily that is one of the things I gained with Operalia. The semifinals, which were only streamed on Facebook, had more than 200,000 viewers. I am glad I learned this only after performing though.

Social media provides another approach to opera for young audiences. I find this to be one of the most important aspects. The business is not the same as it was 10 years ago, not to mention further back. Both social media and technology are shaping the landscape of the opera world. I think we need to make sure that it contributes to the development of this complex and profound art form in a positive way.

>Adela Zaharia sings Gilda in LA Opera's production of Rigoletto, May 27 to June 3. For details and tickets, [click here.](https://www.laopera.org/season/1718-Season/rigoletto/)
