+++
author = ["authors/jenna.md"]
categories = "Interview"
date = 2022-05-02T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "For tour dates, merch, and more, head to Rosé's website at [omgheyrose.com](https://omgheyrose.com/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1651345081/media/2022/04/sqRose_1_1_drlzmg.jpg"
primary_image_credit = "Photo courtesy of Voss Events."
related_articles = ["articles/talking-with-singers-jamie-barton.md", "articles/the-ride-of-the-dragkyries-how-to-name-an-opera-drag-queen.md"]
related_companies = []
related_people = []
short_description = "“When you think of the voice as having, like, the sound of an emotion instead of just sounding pretty, that's a really exciting thing to do. It makes it more like a mime performance than just lip syncing.”"
slug = "talking-with-drag-queens-rose"
title = "Talking with drag queens: Rosé"
youtube_url = ""

+++
Call it an excuse to binge _Drag Race_ if you must, but there's undoubtedly common ground in the worlds of drag and opera. [Jamie Barton](https://www.schmopera.com/talking-with-singers-jamie-barton/) knows it. [Blythely Oratonio](https://blo.org/blythely/) knows it. Even [Canada's indie opera scene](https://operacanada.ca/drag-and-opera/) knows it. And the cool thing is that these two artforms — both very into gender-bending, exaggerated drama and mixing the visual with the musical — are influencing each other and making each other better.

Living smack in the middle of that Venn diagram where opera intersects with the art of drag is [Rosé](https://omgheyrose.com/), the Scottish-born queen best known for being a finalist in season thirteen of _RuPaul’s Drag Race_. She has appeared on _The Voice_ and _America's Got Talent_, and she's one-third of the drag queen girl group [Stephanie's Child](https://www.instagram.com/stephanieschild/?hl=en), alongside [Lagoona Bloo](https://www.lagoonabloo.com/) and [Jan Sport](https://twitter.com/janjanjan) — meaning Rosé doesn't just lip sync, but she real-life sings.

For anyone with even a whiff of a theatre-kid background, watching Rosé kill it on that show made perfect sense: she showed up _ready_.

"I've always been someone who is really into the study and preparation of a performance," Rosé says in a phone call from Copenhagen, between rehearsals for the [_RuPaul’s Drag Race Werq the World_](https://omgheyrose.com/#tour) tour. "I really liked to have everything so set and exhaust all of the control that I actually have over my body and my capabilities so that when the moment comes to actually perform it, I can truly let go and trust."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651345238/media/2022/04/Rose_pinkcar_1_nnsrld.jpg){{% /md %}}

<figcaption>Photo courtesy of Voss Events.</figcaption>  
</figure>

I remember spotting it early on, watching Rosé's season of the show: she was the sort of queen who practiced technique, in the same way that opera singers do. They think, rehearse, repeat; and then onstage, they trust the preparation.

Though she's not the only one who takes a technical approach to her art, Rosé is rare among working drag queens. "There's a lot of us now to be honest, but it's more uncommon to have someone who takes the process strategically and seriously as I still do."

In her sixth year of doing drag, Rosé comes from a "dense education" in the performing arts. She attended Wichita State University — the same place that gave us Alan Held and Joyce DiDonato — with the intent to become an operatic tenor. (If you want to hear some of that great tenor sound, check out ["The Devil in the Details"](https://www.youtube.com/watch?v=vtFjN6x7aTc).)

<figure data-type="video">{{% md %}}<iframe width="919" height="517" src="https://www.youtube.com/embed/vtFjN6x7aTc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}</figure>

"I think what always attracted me to opera was first of all the drama, how dramatic everything is," says Rosé. "It's so exciting to be in the room with voices that can carry that way."

> "I was absolutely fucking hideous!" Rosé hollers with a big, wide laugh.

Still, the life of a strapping tenor wasn't quite the right fit for Rosé. "Something that was indicative of me possibly being more of a stellar drag artist than opera singer was the fact that I was always far more obsessed and keen on performing the soprano and mezzo roles," she says. "The men's roles didn't really appeal to me; those characters and what they had to sing about, you know, hardly sparked my joy."

What does spark her joy, though, is paying homage to opera with that great performance medium, the lip-sync.

"I also low-key love to lip sync to arias," Rosé says before I hound her with follow-up questions. "I like to do it, you know, in a comedic way. So of course my favorite is 'Non più mesta' by Cecilia Bartoli, because it is iconically hysterical, and of course everyone knows how wildly expressive Cecilia is." (She's right, we all do.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651345264/media/2022/04/Rose_bw_2_3_eaitkp.jpg){{% /md %}}

<figcaption>Photo courtesy of Voss Events.</figcaption>  
</figure>

I've always thought that the lip sync was a fascinating mode of expression. It's weird, because in one sense there's very little that's original about a lip-sync performance: it's someone else's song and someone else's voice. But seeing an excellent lip-sync performance is like a lesson in something that any great opera singer is constantly chasing: precision, and subtext for days.

"Something that is a commonality between singing and lip syncing is \[that\] you must know the music. You have to know the music as though it's coming from you," Rosé says. With her training as a singer, she goes the extra step of showing the exaggerated physicality of a singer's breath, sound placement, and even their high-note vowel choice. "I sort of like, place my tongue down and start raising my soft palate like I'm singing," she laughs.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651345365/media/2022/04/Rose_red_1_62_tmjgu2.jpg){{% /md %}}

<figcaption>Photo courtesy of Voss Events.</figcaption>  
</figure>

I asked Rosé who she loved lip syncing to best, and the answer is perfect: Barbra Streisand. "There's something about Barbra," she says in the understatement of the century. "Her voice is one of the most emotive voices I think we've ever had."

Rosé is clued into one of the big truths about great singers, which is that they don't just sing well, but they infuse meaning into the sound of their voices.

"That is the kind of stuff for me, as an actor, that it's so fun to lip sync," she says. "When you think of the voice as having the sound of an emotion instead of just sounding pretty, that's a really exciting thing to do. It makes it more like a mime performance than just lip syncing."

> "RuPaul was there in full drag and it was completely shocking and _appalling_ how amazing she really looks in person!"

One of the big overlaps between drag and opera comes in the creation of characters. Opera singers draw their characters from scores and text, and bolster their choices with input from historical figures ([Mary, Queen of Scots](https://youtu.be/Ij8E-Z6DMR4), anyone?), pop-culture influences, and a lot of careful thought.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651345567/media/2022/04/Rose_Mary_1_47_ysly8a.jpg){{% /md %}}

<figcaption>Rosé as Mary, Queen of Scots. Photo courtesy of Voss Events.</figcaption>  
</figure>

Drag queens take character development a step further, inventing what’s essentially an alter-ego for their professional life; every choice they make, from their look to their performing style, circles outward from their character.

So I find it beautiful and surprising that, despite her technical approach to her art, the character of Rosé was born out of instinct.

"When I started doing \[drag\], it was really a form of rebellion for me to kind of counteract all of that rigidity that I had always been taught to implement in everything I do," she says.

Rather than being a product of traditional character analysis, Rosé was organic, "kind of like unleashing an explosion of all of the things that I had suppressed: a lot of femininity, a lot of profanity, a lot of stuff that makes me feel more myself."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651345280/media/2022/04/Rose_suit_DSC01163-6_dfjvxy.jpg){{% /md %}}

<figcaption>Photo courtesy of Voss Events.</figcaption>  
</figure>

Authenticity plus great technique has always been a winning combination onstage, and it's part of why Rosé saw lots of immediate success when she started in drag. But I was curious about the elements of the art form that she had to work at:

"I was absolutely fucking hideous!" Rosé hollers with a big, wide laugh.

In Rosé, "the joke was that she was really rough around the edges," she says with a smile. "It really brought me a lot of joy to throw that stuff onstage and feed that to people for once."

Drag marked an unfamiliar foray into imperfection for Rosé, but she took it as a challenge to bring her look up to the level of her onstage skills. "For me, when I started drag, the main challenge and still what I work on the most," she says, "is my aesthetic and my appearance, because it's obviously such a huge part of the art form."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1651498345/media/2022/05/Rose_tartan_2_30_xq7hzl.jpg){{% /md %}}

<figcaption>Photo courtesy of Voss Events.</figcaption>  
</figure>

When I was debating whether or not to ask Rosé about RuPaul, I considered another connection between drag and opera: getting to work with one's idols. For an up-and-coming queen, the chance to work alongside someone like RuPaul Charles is akin to the young opera singer who gets to be Annina to Renée Fleming's Violetta, or Cassio to Pavarotti's Otello.

So, I asked Rosé about meeting RuPaul on the first day of filming _Drag Race_.

"RuPaul was there in full drag and it was completely shocking and _appalling_ how amazing she really looks in person!" Rosé laughs, before adding with a bit of venom, "Like, _so beautiful_."

But it was actually her latest brush with celebrity that most impressed Rosé, while filming an upcoming episode of _iCarly_, directed by Melissa Joan Hart. "I couldn't believe it," she recalls. "I was like, 'Holy shit, like Sabrina, the fucking Teenage Witch is directing me in this camp show and I'm in drag, this is so crazy!"

> "Hmm, I wonder where my career can take me in the future?"

And once she got over the craziness, she did that thing that opera singers do when they settle into the idea of working with those they look up to: they learn from them.

"That was a really cool experience, and also kind if nice to see somebody who I've admired and watched for years do something that they're not necessarily known for," Rosé says of Hart in the director's chair. "Kind of thinking in my own life like, 'Hmm, I wonder where my career can take me in the future?'"

Though she's currently _Werqing_ her way around Europe and keeping her hustle alive, the only future I'm craving from Rosé is for her to bring that Bartoli lip sync to Canada. Please?