+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-28T11:43:00-04:00"
lastmod = "2015-07-29T08:53:00-04:00"
preamble = "American stage director [James Marvel](/scene/people/james-marvel/)'s career has taken him across the United States and Canada (including the Centre for Opera Studies in Italy and Opera on the Avalon), not to mention gigs in South Africa, Belgium, Italy, Chile, Poland and South Korea. In 2014 he founded [Marvel Arts Management](http://www.marvelartsmanagement.com/), which has a roster of seven directors, four conductors, and four designers. James is a busy guy, which is why I was thrilled when he took the time to give such a smart and impassioned interview about his work. Enjoy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438114086801/MarvelHeadshot.jpg.jpg"
publishDate = "2015-07-29T08:11:00-04:00"
related_articles = ["articles/spotlight-on-christopher-james-ray.md","articles/talking-with-singers-othalie-graham.md","articles/talking-with-directors-frederic-wakewalker.md","articles/talking-with-directors-jennifer-williams.md"]
related_companies = ["scene/companies/wolf-trap-opera.md","scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
related_people = ["scene/people/james-marvel.md"]
short_description = "American stage director James Marvel&#039;s work has taken him across the United States and Canada (including the Centre for Opera Studies in Italy and Opera on the Avalon), not to mention gigs in South Africa, Belgium, Italy, Chile, Poland and South Korea. In 2014 he started Marvel Arts Management, which has a roster of seven directors, four conductors, and four designers. "
slug = "talking-with-directors-operas-marvel"
title = "Talking with directors: opera&#039;s Marvel"
+++

### 1. What turned you on to directing opera?

Opera is the ultimate art form, and it is a culmination of everything that I  love: music, poetry, drama, dance, and design. It is a collaborative art form that is greater than the sum of its parts. Outstanding colleagues challenge us everyday to create an artistic product that serves as a catalyst for our lives. It is a cathartic force that challenges us to examine every aspect of our lives as human beings. 

My parents love opera and brought me to my first opera at the age of seven. I sat on the edge of my seat for the entire performance, stunned and amazed by the power and beauty of spectacle before me. The conductor of that performance was Maestro Anton Coppola, whom I have worked with on two occasions since becoming a professional opera director. To say that I feel grateful and honored to have worked with him is an understatement. 

Despite my background in violin, literature, and theatre, I had never considered becoming an operatic stage director. As an actor working at the Williamstown Theatre Festival, I met stage director Darko Tresnjak, who became my mentor. It was he who suggested I follow this career path, and I was open to the possibility. I decided to pursue it with singular vision, and I am happy every day that I get to practice this art form, which continues to stretch and challenge me on a daily basis. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438114115566/MarvelSalomeToledo.jpg.jpg)<figcaption>A scene from Marvel's production of *Salome* at Toledo Opera.</figcaption>
</figure>

### 2. In opera, what is difficult about your job? What's easy? 

The only part of my job I don’t enjoy is making rehearsal schedules. Generally, I find the process of engineering logistical solutions to be quite enjoyable, except in the case of scheduling. However I recognize it as an essential component of my work, as a well-designed plan is an important component in creating a fluid and pleasant working atmosphere. I believe that everyone has the right to enjoy coming to work everyday. 

I find the rest of my job to be easy. Preparing a production concept with the design team is thrilling. Preparing blocking and staging that illimunates the story is a challenge I embrace. Working with my colleagues is almost always a pleasure. I even enjoy the tech process. 

### 3. What kind of responsibility do you, as a director, have to your audience? What about to your cast? 

My first objective is always to honor and respect the spirit of the composer’s work. I also believe it is essential to respect, challenge, and delight the audience. They have honored us with their presence and support, and I want every show I direct to be something they remember for the rest of their lives. I want to challenge and uplift them without ever pandering or being pedantic. I also believe it to be of the utmost importance to respect the companies who have entrusted me with the profound responsibility of creating a product that will be appealing to their audiences. I have no tolerance for self-indulgent productions that alienate their audiences and therefore create a need for companies to rebuild trust with their audiences. It’s bad for business and benefits no one. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438114136363/MarvelZaideWolfTrap.jpg.jpg)<figcaption>A scene from Marvel's *Zaïde* at Wolf Trap Opera. Photo: Eric Melear.</figcaption>
</figure>

My responsibility to my cast is to create a vivid, visceral, and dynamic artistic product that allows them to shine as individuals and as an ensemble. Singers are the CEO’s of their own business as well. They work diligently to create a brand that is synonymous with excellence. If a certain concept doesn’t work for a singer, they will never be able to commit to the concept with the kind of dedication and investment that is necessary to create a world-class artistic offering. Therefore respect, dialogue, diplomacy, and compromise are essential components in creating any successful artistic endeavor. 

### 4. What does opera need more of? What does it need less of? 

All opera companies require vision both artistically and fiscally in order to survive. I rather adore the trend of producing works in more intimate venues, as it can create a more visceral and intimate experience than can be achieved in larger auditoriums. Using a smaller venue also means that the overhead in building new productions is smaller, allowing companies to be more adventuresome in creating new designs and exploring repertory that is unfamiliar to their audience. 

A far greater sin than economic failure is the failure to understand that our art is not valuable unless it is relevant. Discovering what is relevant to our audience, our community, and our industry should be the driving passion of all performing arts organizations. I believe we are in the midst of a new renaissance. New operatic works are being written and performed with ever-increasing frequency. It has already been seven years since the reality of the “new” economy took hold. The resulting artistic outpouring has been more of a bang than a whimper. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438114148488/MarvelLucretiaTennessee.jpg.jpg)<figcaption>A scene from Marvel's *The Rape of Lucretia* at the University of Tennessee. Photos: S Katy Tucker and Chelsea Marlow.</figcaption>
</figure>

### 5. Do you have a "bucket list" opera that you'd love to direct? Why? 

I would love to direct any opera by Richard Strauss. His music speaks to me profoundly, and I love the challenge his genius presents. I was thrilled to direct *Salome* for Toledo Opera several years ago and would welcome productions of *Elektra* and *Der Rosenkavalier*. I would also love to direct Alban Berg’s *Wozzeck* and *Lulu* for the same reasons mentioned above. I have a particular fondness for Monteverdi, and I love directing contemporary works. My recent production of Larry Delinger’s one-woman opera *Amelia Lost* for Marble City Opera has been among the most interesting and rewarding experiences of my career.
