+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-31T20:34:00-04:00"
lastmod = "2018-06-03T16:48:00-04:00"
preamble = "Stage director [Jennifer Williams](/scene/people/jennifer-williams/) just added a world premiere to her growing résumé, in *Backwards From Winter* at the Center for Contemporary Opera. Williams is an industrious young director, assisting the likes of Francesca Zambello, Paul Curran, and David Alden, and producing her own work at Miami Music Festival, Pittsburgh Opera, and with DC Public Opera, of which she is the founding Artistic Director.\n\nWilliams gave us a brilliant chat about the director's role in opera, potentially problematic themes of centuries-old works, and how she incorporates technology into her productions."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527814374802/sqJenniferWilliamsHipHighlineNYC_TopFiveRUSH-FULL_6.jpg.jpg"
primary_image_credit = "Photo: Lucas Godlewski."
publishDate = "2018-06-02T17:20:00-04:00"
related_articles = ["articles/opera-directors-an-unfair-disadvantage.md","articles/talking-with-directors-operas-marvel.md"]
related_people = ["scene/people/jennifer-williams.md"]
short_description = "&quot;My philosophy as a director is this: that opera at its best is a place where the possible can encounter the impossible, challenging our notions of what our reality could be like. Imagination and empathy are what shift perspectives and start conversations about what our world could be like. It&#039;s a mistake to underestimate its value.&quot;"
slug = "talking-with-directors-jennifer-williams"
title = "Talking with directors: Jennifer Williams"
+++

## What do you think is the role of the director in opera?

I am a storyteller who puts opera in conversation with our contemporary world. When I am preparing a new production, I begin with the questions: why this story; why now? My concept focuses in on a central conflict that resonates with our world today – abuses of power, gender politics, class conflict, for example. These conflicts are very much at the center of both new works and the standard repertoire; to my mind, it is a director's job to illuminate them and start a conversation about them.

In addition to that, what makes a story compelling is empathy. For a moment, an audience can experience the world through another's eyes and experience emotions different from their own. Opera offers a uniquely intense experience of empathy because it allows an audience to connect with characters on many levels – experiencing the music, text and visual world all at once gives us access to many layers of meaning as well as an unparalleled depth of emotional experience.  And in our modern world, empathy is becoming an increasingly revolutionary act.

My philosophy as a director is this: that opera at its best is a place where the possible can encounter the impossible, challenging our notions of what our reality could be like. Imagination and empathy are what shift perspectives and start conversations about what our world could be like. It's a mistake to underestimate its value.

My overarching goal as a director is to make opera more accessible without dumbing it down, working to break down both imagined and actual physical barriers between audiences and artists. I want to make the performances relevant and relatable to audiences, and engage with modern life and culture rather than stand apart from it. I always incorporate new technology into my productions, and also include immersive, site-specific elements that tie in to the story and augment the experience - for instance, I created a site-specific, immersive installation of *Don Giovanni* in the Mayflower Hotel in DC, and *The Turn of the Screw* in a haunted house that was built the same year the novella was written, with a soprano-aerialist (Marisa Lenhardt) performing the role of the ghost Miss Jessel from a trapeze rigged above the audience. 

I love to incorporate new technology and play with audience expectations - at the moment my focus is on video projection. I feel that we interact with screens so much in modern society, and so I try to explore the middle ground between staring at a screen by yourself on one hand, and on the other sitting in a theater surrounded by others, watching a live production…I think there's much to explore in the intersection between these two poles, and I use video projections not as a means to provide cheap scenery, or to upstage or distract from singers, but rather to elucidate their inner thoughts, and augment the storytelling with another visual element that creates a different set of expectations.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527814476260/the_turn_of_the_screw_0250.jpg.jpg)
<figcaption>*The Turn of the Screw*, DC Public Opera, 2017. Photo: Andrew Propp.</figcaption>
</figure>

## What do you find unique about working on world premieres, as opposed to traditional works in the opera canon?

A world premiere is uncharted territory. While you don't have the advantage of learning from the successes and mistakes of previous productions, you also have an immediate impact on how the story is framed, how it resonates with its first audience and even its identity in the repertoire. When I am directing a traditional work, I am entering an ongoing conversation – sometimes one that is centuries old. I am a director who comes to the table with strong ideas and an active approach to storytelling, so I am comfortable in both worlds.

We just opened the world premiere of *Backwards from Winter*, a monodrama for soprano, electric cello and computer by Douglas Knehans and Juanita Rockwell, produced by Center for Contemporary Opera in New York. I have also directed new productions of Mohammed Fairouz's *Sumeida's Song*, Ricky Ian Gordon and Royce Vavrek's *27*, Jake Heggie and Gene Scheer's *Three Decembers*, as well as workshops of works in progress. I'm very active in the contemporary opera scene and love the collaboration and boundary-pushing that happens there. Having face-to-face conversations with composers and librettists is great – when I am preparing a Mozart opera, for instance, I'll sit down with my copy of his collected letters – but with a new work, we can just have coffee, and collaborate directly throughout the design process and in rehearsals. Very often, a work may go into its premiere without a real workshop, or conversations around a new production will prompt revisions – so as a director I also fulfill a dramaturgical role in bringing the story to life for the first time. It is thrilling to be on the cutting edge of the art form in that way.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527814424068/BackwardsfromWinter_CenterforContemporaryOpera_LucasGodlewski_1.jpg.jpg)
<figcaption>*Backwards From Winter*, 2018, Center for Contemporary Opera. Photo: Lucas Godlewski.</figcaption>
</figure>

### How do you address social issues inherent in some classic works (ie. misogyny, racism) that come out of the time in which they were written?

The reality is that none of those social issues – beginning with misogyny and racism – has gone away in our present time; they merely take different forms (if that).

A misconception is that producing a "traditional" production emancipates everyone from dealing with the uncomfortable social issues that are very much at the center of these works. Passive storytelling, in reality, makes artists and audiences complicit in perpetuating harmful tropes and stereotypes. You can produce an opera in its original period and still confront these issues. How human beings are portrayed onstage matters – it is part of a larger conversation – and presenting harmful tropes and stereotypes as "tradition" is simply destructive.

To give an example from the feminist angle: when I first came to opera, I was turned off by how the women were always victims (the "dying soprano" trope), but as I looked closer I saw that the music and underlying story elements didn't always support that narrative. I decided to dig deeper, and in my productions I work to present women not as victims, but as empowered and in control of their own destinies. Many operas deal with abuses of power and power dynamics, but they don’t have to be disempowering. For instance, the Don Giovannis of the world gain their power by isolating women, but in that story ultimately the women come together and unite against him. In *Bohème*, Mimì makes the conscious choice to come back to Rodolfo even though she knows it will cost her her life, so she can be with him at the end - it's a powerful, personal choice not to be alone when she dies, and she chooses to die on her own terms.

My process as a director begins with a close reading of the score. I came to directing via composition and am a polyglot, so I revel in the details while keeping my eye on the big picture. As a storyteller, I am a student of history; in my productions, I put historical moments and the forces at work within them in dialogue with our present. Whether productions are set in an historical period or updated it to our present moment, that storytelling choice should not be a means of diverting attention away from these social conflicts – rather, it should shine a light on them and start a meaningful conversation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527814415602/SumeidasSong_PittsburghOpera_DavidBachman.jpg.jpg)
<figcaption>*Sumeida's Song*, 2015, Pittsburgh Opera. Photo: David Bachman.</figcaption>
</figure>

## What have you learned about singers in your work as a director?

I love working with singers because they have such interdisciplinary imaginations. I began my career as a theater director with a focus on Shakespeare and Greek drama – I worked at Chicago's renowned classical theater, Court Theatre, prior to focusing on opera – so bringing poetic language to life through dynamic, very physical staging and text-driven approaches to drama have always been at the core of my work. While no two artists are alike, I find that a lot of singers enjoy working this way. 

At the professional level, every singer has their own specific approach to acting and accessing the emotional life of their characters. My aim as a director is to bring those diverse approaches together into an ensemble, and push that ensemble to the next level to tell the most dynamic version of the story possible. That begins with having open-ended conversations about the characters, story and score in rehearsal and ensuring all artists' ideas are heard and included. 

Opera is collaborative – a director can't shut out ideas; it's her task to create a space in which everyone on her team can be creative in pursuit of a common story. The future of opera relies on this kind of collaboration, on the pursuit of empathy and imagination, and on a commitment to telling stories for our time.

>For more with Jennifer Williams, follow her on [Twitter](https://twitter.com/jwdirector), [Facebook](https://www.facebook.com/jenniferwilliamsdirector/) and [Instagram.](https://www.instagram.com/jwdirector/)
