+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-11-02T20:11:00+00:00"
lastmod = "2016-11-10T11:01:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478119433038/2016-11-02---Frederic-Wake-Walker.jpg.jpg"
publishDate = "2016-11-10T10:53:00+00:00"
related_articles = ["articles/talking-with-directors-operas-marvel.md", "articles/4-shows-to-perk-up-the-postholiday-blues.md", "articles/lore-lixenberg-is-the-mother.md"]
related_companies = ["scene/companies/mahogany-opera-group.md", "scene/companies/teatro-alla-scala.md"]
related_people = ["scene/people/frederic-wakewalker.md"]
short_description = "&quot;I love going into these places and working with kids,&quot; says Wake-Walker. &quot;It&#039;s wonderful. I learn so much.&quot; He jokes that working primary school students is &quot;pretty much the same&quot; as directing the singers at La Scala, and adds that for any aspiring director, young people offer valuable learning experiences. &quot;Kids ask questions that even the pros at La Scala are sometimes a little bit embarrassed to ask.&quot;"
slug = "talking-with-directors-frederic-wake-walker"
title = "Talking with directors: Frederic Wake-Walker"

+++
Director [Frederic Wake-Walker](/scene/people/frederic-wake-walker/) recently opened his new production of *Le nozze di Figaro* at [Teatro alla Scala](/scene/companies/teatro-alla-scala/), the first to take the place of the 1981 staging by the late Giorgio Strehler. "It was a pretty funny gig to follow," says Wake-Walker of taking over the legacy of someone he calls "the greatest director to have worked at La Scala." 

The "funny gig" is no small house debut for Wake-Walker, and he "relished" the opportunity to add his voice to the long, illustrious history of La Scala. With his *Figaro*, he found focus and direction by paying homage to Strehler, and referencing his production. "I do that with everything. I don't just create something abstractly. I think very much about the context in which the production takes place," he explains. "I think if you're going to make theatre that feels really alive and really connected to the audience, then you have to recognize where you are, and where you've come from to get to that point."

Wake-Walker is not the first director to see that Mozart's *Figaro* is "an incredibly complex piece," full of characters who are "finely drawn." He sees the story of love, marriage, status as one that represents all people, and one that takes us through "all the issues of the world." 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478535063085/2016-11-08---Photo-credit-BresciaAmisano-Teatro-alla-Scala-3.jpg.jpg)
<figcaption>Rehearsing *Le nozze di Figaro* at La Scala. Photo by Brescia Amisano, copyright Teatro alla Scala.</figcaption>
</figure>

"One very powerful dichotomy within the piece is the logical versus the magical," says Wake-Walker. On one side are the practical elements of Da Ponte's libretto, like letter-writing and hiding behind the correct doors; at the same time, he sees the piece begin to pull away from the pragmatic, towards the magical. For Wake-Walker, that moment of spirituality and "stillness" culminates in the final scene, where the characters shift from secrecy and tricks to absolution.

"It's an impossibility, it's a world where everyone is loving and forgiving," he explains. "And yet it's there right in front of us on the stage." With this final image, Mozart and Da Ponte pose a question to the public: "Why can we put it up here, why can it not exist over there, [in real life]?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478535126548/Photo-credit-BresciaAmisano-Teatro-alla-Scala-4.jpg.jpg)
<figcaption>Frederic Wake-Walker rehearsing *Le nozze di Figaro* at La Scala. Photo by Brescia Amisano, copyright Teatro alla Scala.</figcaption>
</figure>

Staging masterpieces in historical theatres is only one way that Wake-Walker creates opera. He is the Artistic Director of [Mahogany Opera Group](/scene/companies/mahogany-opera-group/), and currently in the midst of their ambitious [Snappy Operas](/great-ideas-snappy-operas/), a project designed to create operas for and with young people aged 7-11. Mahogany works with ten regional partners to create ten new operas, created and performed by over 1500 primary school students across the UK.

"I'm going to go from the rehearsal room in Milan to a primary school in west Cumbria, which is pretty cool," says Wake-Walker. Mahogany has already developed the first Snappy Opera, *The Itch Witch* by Emily Hall and Toby Litt, and now they're working on the next four. The Snappy Operas will travel to various regions in the UK, along with scores and teaching resources to help schools pick them up independently of the workshop process. Developing these ten Snappy Operas "is also a way of building these ongoing relationships with these ten regions in the UK," Wake-Walker explains. With these relationships, Mahogany can develop teams of conductors, directors, and répétiteurs for each region, and Wake-Walker looks forward to "whole follow-up programme" planned for the future, including larger-scale commissions for children's operas.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1478535159349/2016-11-08---Photo-credit-BresciaAmisano-Teatro-alla-Scala.jpg.jpg)
<figcaption>Frederic Wake-Walker rehearsing *Le nozze di Figaro* at La Scala. Photo by Brescia Amisano, copyright Teatro alla Scala.</figcaption>
</figure>

"I love going into these places and working with kids," he says. "It's wonderful. I learn so much." He jokes that working primary school students is "pretty much the same" as directing the singers at La Scala, and adds that for any aspiring director, young people offer valuable learning experiences. "Kids ask questions that even the pros at La Scala are sometimes a little bit embarrassed to ask," he explains. "They challenge you, as well. You have to be really watertight with your concept, your explanation of things."

It's a conscious decision for Wake-Walker to include in his schedule projects like Snappy Operas in his schedule, alongside more mainstream work at La Scala, the Glyndebourne Festival, and the Opéra national du Rhin. He enjoys the variety, and plans to maintain it for seasons to come. "After La Scala I've sort of got these mad, big opportunities coming up. But I think it would all be sort of meaningless if I didn't also have projects that took me into schools in Cumbria," he explains. "They all sort of connect somehow."