+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-10-11T16:12:00-04:00"
lastmod = "2017-10-16T19:33:00-04:00"
preamble = "British conductor Oliver Zeffman is one of those tirelessly ambitious young artists, having built up impressive experience conducting new and traditional symphonic and operatic repertoire. In 2010 - at just 16 years of age - he founded the [Melos Sinfonia](/scene/companies/melos-sinfonia/), which is embarking on its most ambitious tour to date with an in-concert presentation of George Benjamin's *Written on Skin*. \n\nWe spoke with Zeffman about taking on the work of living artists, making the performances his own, and the exhaustively rewarding process of creating one's own professional opportunities."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507752889727/2017-10-11---Zeffman---71b.jpg.jpg"
primary_image_credit = "Photo: Andy Staples."
publishDate = "2017-10-16T19:33:00-04:00"
related_articles = ["articles/spotlight-on-christopher-allen.md","articles/talking-with-conductors-harry-bicket.md","articles/in-review-written-on-skin-at-roh.md","articles/talking-with-conductors-riccardo-frizza.md","articles/talking-with-conductors-george-jackson.md"]
related_companies = ["scene/companies/melos-sinfonia.md"]
related_people = ["scene/people/oliver-zeffman.md"]
short_description = "&quot;I set up the Melos Sinfonia at 16 - no-one is going to invite a wannabe conductor with zero experience in front of their orchestra, so you&#039;ve got to start something yourself. Ask your friends from school, from youth orchestra, their friends and relatives. You&#039;ll probably be terrible to start out with (I was at least!) but over time you get better, they get better, you build a wider network of players and at some point you&#039;ll be making good music!&quot;"
slug = "talking-with-conductors-oliver-zeffman"
title = "Talking with conductors: Oliver Zeffman"
+++

### What do you find unique about touring a piece like *Written on Skin*, which has a performance history closely associated with George Benjamin, Barbara Hannigan, and Christopher Purves?

It's a little daunting! The original production is such a landmark - and particularly when the piece has been conducted so extensively (and recorded) by the composer himself, it can be hard to have a fresh approach that convinces yourself, let alone others. Having said that, because there has only really been this one version of the opera - and one which everyone knows so well - it's easier in many ways to do something new as your own ideas are crystallised very much in correspondence or opposition to the original production. It also helps that there's no long and weighty performance tradition that we have have to fit into/fight against, and it's very exciting to still be one of the first groups that gets to perform on this fantastic opera.

## What advice do you have for young artists interested in starting a company or ensemble?

Just do it! I set up the Melos Sinfonia at 16 - no-one is going to invite a wannabe conductor with zero experience in front of their orchestra, so you've got to start something yourself. Ask your friends from school, from youth orchestra, their friends and relatives. You'll probably be terrible to start out with (I was at least!) but over time you get better, they get better, you build a wider network of players and at some point you'll be making good music! 

In terms of finding financial support, look up who sponsors all the major arts organisations and just write to them. It's a long and tedious process and most people won't reply, but if you're really excited by your project and can convey this excitement to others then you'll find support out there. I think my idealism (some would say naivety) served me well when I started: I didn't really know what I was doing, so I just did it!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1507752819828/2017-10-11---Oliver-Zeffman-3.jpg.jpg)
<figcaption>Photo: Nick Rutter.</figcaption>
</figure>

## What does it feel like to conduct an ensemble, when everything is going well, or "right"?

I don't think anything is ever going to be perfect! To me a good conductor (or artist in general) is someone who thinks they can always do better, they can push a little more at the next set of rehearsals, the next performance. That's what makes it so exciting! When you come back to a piece for a second time, things are always different. I did a performance of *Il Tabarro* last year and at the time I was, broadly speaking, very happy with it. We recorded it for archive and listening back even a few months later to some of the parts I was originally most happy with, lots of the tempi, for example, seemed not at all right. 

Your ideas of how a piece "should be" change as you learn more and develop different tastes. I love conducting of course, and when things go well it’s a fantastic feeling. Although of course as a conductor you don’t produce any sound, being the impetus behind the sound an orchestra makes is a very special feeling. 

## What pieces do you have still on your performance wish list?

There's so much I want to do! If we just stick to opera, I'd love to do some more Puccini - *La bohème*, *Tosca*, *Madama Butterfly*. Verdi's *Otello* is perhaps my favourite opera, though I don’t see myself getting the chance to conduct it anytime soon - probably *La traviata* (which I also adore will be first). I'd also absolutely love to work on *Eugene Onegin* soon; the four big Mozart operas - I've so far only conducted *Die Entfühurung aus dem Serail* and *Der Schauspieldirektor*; *Bluebeard's Castle*, *Der fliegende Holländer*, *The Turn of the Screw*; the Strauss operas (and also the J. Strauss *Die Fledermaus*) - the list goes on! 

As far as contemporary works go, I'm keen at some point to conduct George Benjamin's other opera(s); Thomas Adès' *Powder her Face*, Julian Anderson's *Thebans*, Mark-Anthony Turnage's *Anna Nicole* are all favourites. I’m also a big fan of Salvatore Sciarrino's work and would love to conduct his operas too. 
