+++
author = ["authors/michael-pecak.md"]
categories = "Interview"
date = "2019-02-13T17:34:22+00:00"
disclaimer = ""
image_gallery = []
postamble = "I'm grateful to Magda Krance for arranging this meeting with Maestro Christie. For details and ticket information for LOC's _La traviata_, [click here](https://www.lyricopera.org/concertstickets/calendar/2018-2019/la-traviata-opera-tickets)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1550079017/media/2019/02/sqMichaelChristieJamesDaniel.jpg"
primary_image_credit = "Photo: James Daniel."
related_articles = ["articles/michael-christie-new-opera-that-the-box-office-loves.md"]
related_companies = ["scene/companies/minnesota-opera.md", "scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/michael-christie.md"]
short_description = "\"You know, thank goodness that we're beginning to deal more and more with questions and issues of diversity. But Young Artist Programs can't deal with the diversity questions if there isn't a pipeline beforehand.\""
slug = "talking-with-conductors-michael-christie"
title = "Talking with conductors: Michael Christie"
youtube_url = ""

+++
When Schmopera first [interviewed conductor Michael Christie back in 2016](/michael-christie-new-opera-that-the-box-office-loves/), he was right in the thick of his tenure as Music Director of Minnesota Opera. Riding a stream of high-profile and highly lauded world premieres and commissions of new operas, Christie and the company established themselves among today's foremost new-music performers and as brilliant exemplars of what a 21st-century opera company could be.

Maestro Christie is currently in Chicago to make his mainstage debut at Lyric Opera of Chicago with [Verdi's _La traviata_](https://www.lyricopera.org/concertstickets/calendar/2018-2019/la-traviata-opera-tickets). This venerable staple of the operatic canon might initially seem puzzling in light of Christie's skills and accomplishments with new music. (As of this writing, Christie has won a Grammy Award for his recording of Mason Bates' _The &#40;R&#41;evolution of Steve Jobs_ with Santa Fe Opera).

> "Already I have three southern-Californian composers lined up for new pieces. I've found an immense reserve of talent in that part of California and I'm excited to tap into it."

At the peak of the recent Polar vortex, I had the opportunity to catch up with Mo. Christie during a cancelled day of rehearsals due to the cold. What came through most vividly in our conversation are his qualities of thoughtfulness and forward-looking, which he applies consistently to scores whether they were composed 200 years ago or last week. Being a licensed pilot, he sets his sights on a newer and broader horizon not only for himself as a conductor, but for opera in America more generally.

Christie works with some of today's most celebrated living composers. The names of Mason Bates, Mark Adamo, Osvaldo Golijov, Paul Moravec, Ricky Ian Gordon, and Kevin Puts (whose Pulitzer-Prize-winning opera _Silent Night_ was commissioned and premiered by Christie and Minnesota Opera) figure prominently and regularly on Christie's programming.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550191305/media/2019/02/LYR190213_196.jpg){{% /md %}}

<figcaption>Michael Christie in rehearsal for La traviata at Lyric Opera of Chicago. Photo: Todd Rosenberg.</figcaption>

</figure>

**Michael Pecak (MP)**: Considering the august living-and-breathing company you keep, what is it like for you to come back to the long-departed Verdi and the score of _Traviata_.

**Michael Christie (MC)**: I find it quite liberating because when you work with living composers, and you see the human element in creating a piece, you realize that they're restricted by the same little dots on the page as Verdi was. Living composers strive to get the drama out of a scene; it's like being an architect, building a powerful scene. It's clear to me that past composers wanted the same. So, I try to be as imaginative with Verdi as I am with a new piece. When I open the score, it's like I hear it saying: "be dramatic with me!" If a moment invites an additional second or two of time for the characters to look into each other eyes before saying "Addio," then it should be done. The audience would rather have that than pedantic counting of eighth-rests.

> "Every time I open a new score, I say to it: 'tell me about your language. How do you use the language?'"

**MP:** Works like _La Traviata_ are so steeped in "tradition" by now: there are certain recordings that to this day are venerated and emulated. When approaching a classic, Christie goes for a more sweeping temporal scope.

**MC**: With a lot of the standard repertoire, I try to dig back as far as I can on YouTube. I like to get a comparative overview of performances: "Oh, this is how they did it in the 1940s in that country, then in the 1960s they were doing such and such things." Then Carlos Kleiber came along and did this totally miraculous thing. So yeah, I lean a lot on YouTube for those historical records.

**MP**: Many of those ancient recordings are really incredible, especially by the likes of, say, Adelina Patti (1843-1919) singing bel canto. Verdi himself was a great admirer of hers! In this recording of, for example, "Ah, non credea mirarti" one is instantly swept away by her expression (even if the voice itself perhaps shows some of its age; it was recorded already toward the end of her life.)

<figure data-type="video">{{% md %}}<iframe width="806" height="453" src="https://www.youtube.com/embed/w2LY6YLHn7U" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>

She sings with such flexibility, but all guided by a rhetorical expressivity. It's not about calculation or the careful placement of everything, but about the declamation of the text and its emotions.

Of course, expressivity is timeless and Christie finds that as he comes to know more and more singers through various productions, he'll frequently call them up ahead of time to say "hey, we have this show coming up in five or six months. Remember what we did in the Mozart? You can also do that in Moravec."

As for general, but foundational, advice for young singers and conductors, Christie believes that preparation is key. But preparing a score by Mozart is one thing and one by Moravec another.

**MP:** What is the preparation process like as a conductor for a new score versus a canonic work?

**MC**: I would say it's not dissimilar, actually. Of course there are different considerations, but that's typical of any score. But with a new work, something that I'm increasingly more aware of, is that in the earliest performances, we are laying a path toward a tradition in a certain sense. Consequently, I try to be a little bit careful with certain choices. I always like to call up the composer with questions, like "what exactly is the relationship between the stage and pit at this moment?" "Is it more atmospheric? More internal character? Emotionally driven?" Also, every time I open a new score, I say to it: "tell me about your language. How do you use the language?" When the use of the language or the expressivity of the language isn't obvious, that's when I start thinking "Hm, how are we going to make this work?"

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1550191443/media/2019/02/LYR190213_021.jpg){{% /md %}}

<figcaption>Michael Christie in rehearsal for La traviata at Lyric Opera of Chicago. Photo: Todd Rosenberg.</figcaption>

</figure>

**MP:** The other two components of Christie's three-fold professional credo are: be collegial and be supportive. Building a sense of community is at the core of Christie's work. Although, no longer at the helm of Minnesota Opera, Christie is passionate about community development and engaged leadership. He's currently following a string of high-profile invitations as a guest conductor at opera houses and universities, while also balancing a new orchestra directorship of the New West Symphony in Ventura County, CA. "Audience development," says Christie, "is a top priority for me with this new position." One initiative he is spearheading there is strikingly 18th-century in concept: making use of intermission time to showcase new works by regional composers.

**MC**: Our first plan is that immediately once the first half concludes, we're going to hold a ten-minute interview with the artist(s) while the orchestra takes their break. The audience will be able to ask questions and participate as well. I've done this now at other places and it's gotten enthusiastic feedback. The other plan is called "Entr'acte." The intermission will be extended slightly and the during the last five-or-so minutes, we’re going to offer a new work. The audience will be free to sit in and listen, but won't be obliged to. The piece will be new (or new-ish, let's say). Already I have three southern-Californian composers lined up for new pieces. I've found an immense reserve of talent in that part of California and I'm excited to tap into it. I envision that some of the pieces will be with orchestra, some will be with small ensemble. I want to send a message to the audience that there will be new music on every concert. You're free to hear it or not, but if you do want to hear it, you'll be assured that it is there.

> "Something I'm determined to address if I get a chance to be part of a leadership team at a company is the pre-YAP pipeline and post-YAP career development."

**MP**: Looking ahead, Christie is open about his aspirations to be music director of another major opera company. Having had the Minnesota Opera experience, Christie is determined to challenge lingering stereotypes about conductors being disinterested in any aspects of a productions beyond the music itself. "I love those things," Christie exclaims. "I love knowing how the masking is done for this and how the lighting is done for that, letting the director know that I notice things and that I'm there to help in the whole endeavour." I can't help but suspect that being a pilot influences his musical sensibilities. "I never thought about it that way," he replies, "but now that you say it, yes, I totally agree: an opera is indeed like a large aircraft to steer."

Building on his thoughts from 2016's interview, Christie is even more conscientious about the development of young artists, a pertinent fact considering the numerous Ryan Opera Center artists participating in this LOC production of _Traviata_.

**MC**: One of the big questions for opera is how we manage the training programs, and even before the YAP phase. You know, thank goodness that we're beginning to deal more and more with questions and issues of diversity. But Young Artist Programs can't deal with the diversity questions if there isn't a pipeline beforehand. And also, what is of equal consequence, is what happens after the singers leave a program. Something I'm determined to address if I get a chance to be part of a leadership team at a company is the pre-YAP pipeline and post-YAP career development.

**MP**: With Maestro Christie conducting and Arin Arbus directing, [LOC's _La traviata_](https://www.lyricopera.org/concertstickets/calendar/2018-2019/la-traviata-opera-tickets) promises to be a thoughtful and engaging production. The show opens this Saturday evening, February 16, and runs for 10 performances. Don't miss it, Chicagoland!