+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-08T18:18:00-04:00"
lastmod = "2018-05-08T21:01:00-04:00"
preamble = "It's far from being one of his best-known operas, yet Donizetti's *Pia de' Tolomei*, after Dante's *Divine Comedy*, has a memorable performance history. Its 1837 premiere happened only after the burning down of Venice's La Fenice and the production moved to the Teatro Apollo, and with a slight delay after a singer fell ill, and Donizetti had to rewrite the bass role for a baritone.\n\n*Pia de' Tolomei* now sees its American premiere, **May 27 to June 8** at the Spoleto Festival USA. The production is directed by Andrea Cigni, and conducted by Lidiya Yankovskaya, currently the Music Director of Chicago Opera Theater and a resident artist at National Sawdust with the Refugee Opera Project.\n\nWe spoke with Yankovskaya about performing rare works, and her respect for the singers she conducts."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525817833043/sqlidiya_yankovskaya.jpg.jpg"
publishDate = "2018-05-08T21:01:00-04:00"
related_articles = ["articles/spotlight-on-christopher-james-ray.md","articles/gordon-gerrard-music-doesnt-really-work-without-breath.md"]
related_companies = ["scene/companies/spoleto-festival-usa.md"]
short_description = "&quot;Being an operatic singer is one of the most challenging jobs in the world - not only do you have to be a great musician, but you also have to be a great actor, to be able to move convincingly on stage, to sing in half a dozen languages without an accent, and to know your part to such an extent that if something goes wrong - you don&#039;t miss a beat.&quot;"
slug = "talking-with-conductors-lidiya-yankovskaya"
title = "Talking with conductors: Lidiya Yankovskaya"
+++

## What does it feel like to conduct an orchestra and singers, when everything is going right?

The amazing thing in performance is to see the many elements in an opera come together into one.  When I am on the podium, I am in a unique position to experience the entire orchestra, chorus, soloists joining musically and dramatically with the visual aspects of the opera.  That's hundreds of people and countless sonic and visual elements combining into one great whole, with the conductor as a focal point through which all these things flow to the audience.  It's an exhilarating feeling - a visceral experience of the pinnacle of human capacity for creativity and collaboration. 

## How would you describe the job of a conductor? How does it differ in opera, versus symphonic music?

A conductor's principal role is to connect the musicians in front of her and to allow them to give their optimal performance.  This is done through a careful balance between conveying a unified vision for the work (mainly through gesture in the moment, but also through rehearsal), while giving the musicians space to create, to listen, and to express.  My responsibility is to know all aspects of the score in and out and to portray what I believe the composer's vision for the work to be.  In opera, I also have the essential responsibility to ensure that the musical and dramatic aspects of the work are fused into a unified whole.  I strongly believe that an operatic performance can only be fully successful when the drama and the music become one.  A great composer will do a lot of this work for the performers, but it's the conductor's responsibility to ensure that we work with what is in the score, combined with the director's vision for the piece, so that the music consistently heightens the dramatic impetus and vice versa.  

Practically speaking, my job is much more complicated in an operatic context than in a symphonic performance.  First, there is the libretto: I have to be very familiar with all aspects of the text, in whichever language it appears - to truly understand the meaning of every single word and how the music underscores this meaning, to have a feel for the natural "musical flow" of the language, and, together with the director, to aid singers in their dramatic delivery of the text (especially in recitative).  

Additionally, there is the issue of not only combining and orchestra with soloists, but combining an orchestra with soloists who often cannot hear the instrumentalists well from the stage, and who have to worry about a great deal of physical movement during performance. There is a lot more to do in terms of keeping the forces together and to adjusting in the moment in case of emergency; with so many people and elements in play, almost always something goes wrong, and even if it doesn't, the dramatic drive of the performance means that the unexpected is to be expected.  

The conductor's job is to ensure that no one in the audience notices when a delay with a set piece, a forgotten line, or a missed entrance occurs.  In bel canto repertoire, in particular, there is also a great deal of spontenaiety, so the singers and I have to ensure that we are always 100% in the moment and aware of each other, as musical timing adjusts slightly, or something changes in a recit for dramatic effect, or a singer decides to vary their embellishments on a given phrase. 

## What are the unique challenges in performing a piece like Donizetti's *Pia de' Tolomei*, an unknown work by a well-known composer?

*Pia* went through many iterations in its development, often with the composer making changes for practical or censorship rather than artistic reasons (there is even a version with a happy ending!).  The existence of so many different versions makes it challenging to ensure that we choose the correct performance options, that the orchestra has the materials they need, etc.  However, this is easier to do for a well-known composer, as those of us performing the work are already very familiar with the composer's style; I have the context of knowing Donizetti's many other operas, and this is especially helped by the fact that Donizetti recycled a lot of his material from work to work.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525817856852/PiadeTolomeiproductionphoto1creditImaginariumCreativeStudioPisa.jpg.jpg)
<figcaption>A scene from *Pia de' Tolomei*. Photo: Imaginarium Creative Studio Pisa.</figcaption>
</figure>

## What pieces are still on your wish-list to conduct?

I've done some Wagner in concert performances, but not in the theater.  Wagner's music matches my sensibility, and I'd love to have an opportunity to do something like *Tristan und Isolde* in the near future.  Another work that I've done sections of in various concert situations but would love to conduct in full is Debussy's *Pelléas et Mélisande*.  On the symphonic side, I've conducted some of Mahler's symphonies and other works, but there are still so many more. I hope that over the course of my lifetime, I will have an opportunity to conduct Mahler's full oeuvre.  There are also some operas that I've already conducted, but would love to come back to, again and again, including Verdi's *Otello* and Tchaikovsky's *Queen of Spades*. 

## If you could sing any role in an opera (and sing it well), which one would it be?

Although I never pursued it as a primary vocation, I studied voice seriously in graduate school and performed a bit professionally in operatic roles and also professional choral ensembles.  Having had this experience, I am even more certain that I very much prefer being a conductor to being a singer.  Being an operatic singer is one of the most challenging jobs in the world - not only do you have to be a great musician, but you also have to be a great actor, to be able to move convincingly on stage, to sing in half a dozen languages without an accent, and to know your part to such an extent that if something goes wrong - you don't miss a beat.  Plus, a singer's body is their instrument so they constantly have to worry about how they take care of themselves, how much they sleep, what they eat and drink, what the air they are breathing is like, and more - something as simple as an allergic reaction to a colleague's cologne can destroy a performance.  

Singers have to rely heavily on their many collaborators - on the director who gives the blocking, the costume designer who dresses them, the conductor who shapes the music with them, etc. etc.  If one of the many elements that go into an opera fall through - hot and uncomfortable costumes that make breathing difficult, props not where they should be, conductor is not connecting with the vocalist, director gives blocking that is contrary to what they have to do physically & dramatically - if any of these things happen, a singer loses the freedom to perform their best.  

To me, this last aspect of the job is perhaps the most difficult... I'd much rather be a conductor, in a position to empower the people in front of them to give their best performance.  I'm thrilled that on a daily basis, I can have an opportunity to be in awe of my singer colleague's talents and can share the music-making with them.  I would never want to trade jobs with any of them.

>*Pia de' Tolomei* runs at Spoleto Festival USA, May 27 to June 8. For details and tickets, [click here.](https://spoletousa.org/events/pia-de-tolomei/)
