+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-01-28T12:37:00-05:00"
lastmod = "2018-01-29T09:18:00-05:00"
preamble = "London-based conductor [George Jackson](/scene/people/george-jackson/) is the winner of the 2012 Jeunesses Musicales Conducting Competition in Bucharest, and the 2015 Aspen Conducting Prize. At major opera houses in New York, Paris, and Vienna, he has assisted under Robert Spano and Yves Abel.\n\nJackson is currently in Rijeka, making his debut with the Orchestra of the  Croatian National Theatre. Later this season, he makes his debut with [Opera Holland Park](/scene/companies/opera-holland-park/), conducting a new production of *Così fan tutte*.\n\nWe spoke with Jackson about the rush of conducting an orchestra, and the challenge of building up \"flying hours\" as a young maestro."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546195261/media/2018/12/George-Jackson-pc-Alexa-Wilding.jpg"
primary_image_credit = "Photo: Alexa Wilding."
publishDate = "2018-01-28T21:05:00-05:00"
related_articles = ["articles/talking-with-conductors-oliver-zeffman.md", "articles/talking-with-conductors-harry-bicket.md"]
related_companies = ["scene/companies/opera-holland-park.md"]
related_people = ["scene/people/george-jackson.md"]
short_description = "&quot;Walking into the rehearsal room with a new orchestra is pure psychology: I find that my antennae are up, reading the room&#039;s complex dynamics in the first few minutes.  It&#039;s part of the job that I love most, because it&#039;s essentially a multiplied version of one-to-one interaction.&quot;"
slug = "talking-with-conductors-george-jackson"
title = "Talking with conductors: George Jackson"

+++
## What does it feel like to conduct an orchestra when everything is going "right"?

It's the best feeling in the world!  The level of communication within the orchestra is completely open, and everybody can read each other's mind, like a giant string quartet.  A good analogy is probably with driving a car: you no longer consciously "change gear" or "check the mirrors", and can really focus on "the journey".

When things are going "right", there is a sense of spontaneity too, a reminder that the stuff written down on the page is just a starting point.  I have found that the most exciting performances are late into a 10-concert tour, when everybody on stage has developed a sense of freedom, derived from really knowing the music and knowing each other: a caffeine injection from an animated audience one night can intensify the music making and keep things fresh!

## What about conducting did you have to work the hardest at?

Gaining experience, especially in a way that balances quality and quantity.  At the beginning, the physical technique of conducting can feel unnatural and strange - imagine a child putting a violin under their chin for the first time.  But the problem is: whereas the child violinist will develop musicality alongside the instrument, beginner conductors are already well-rounded adult musicians, usually with professional instrumental experience.  So, young conductors have to spend time "catching up".

Finding an orchestra to build up "flying hours" with is a challenge, and you need an entrepreneurial spirit to create those opportunities.  I was an obsessively proactive student, and wrote endless letters to conductors and their managers looking for opportunities.  I was lucky to meet several important mentors who were generous enough to offer me experience, whether as an assistant, or conducting their own orchestras.  Summer festivals in the US, such as Aspen, even offer a unique orchestra dedicated to training conductors!

## How do you approach the first rehearsal with a new orchestra? How do you balance respect for the players, with your own position of leadership?

Walking into the rehearsal room with a new orchestra is pure psychology: I find that my antennae are up, reading the room's complex dynamics in the first few minutes.  It's part of the job that I love most, because it's essentially a multiplied version of one-to-one interaction.

Respecting the players within a leadership context depends on the culture you are working in (each country has its own set of expectations for conductors).  But a big mistake is to force the relationship by being unnatural.  Nobody can pretend to be a personality that they aren't, so the most effective manner of meeting a new orchestra is by being yourself.  Orchestras can smell bullshit a mile off, and they have the power to make your life very difficult.

My mentor, the American conductor Robert Spano, taught me that conductors aren't in the business of telling the orchestra (verbally) how to play, or what to do.  Physical gesture, combined with repetition, is a way to respect the players' integrity whilst also preparing for the performance (I think it's fitting that the French word for rehearsal is *répétition*).

## What do you find unique about conducting singers?

I wouldn't use the term "conducting singers": it feels too direct! A good relationship with a singer feels like a dialogue, or a healthy tennis rally, where the energy of each other's work spurs on the other.  The process is totally collaborative and (please excuse the cliché) reflects the 'electricity' aspect of the job: a conductor connecting a circuit.

Each individual singer brings his or her own physicality, mentality and musicianship to the stage: our role in the pit is one of support.  We have to do everything within our power to ensure that they are comfortable since, to quote the great Canadian conductor Yves Abel: the singer is facing the audience (unlike the conductor!) and may have "blinding lights in their faces and a costume that is perhaps too tight around the neck".  Sympathizing with the challenge of what singers do is fundamental.

## Do you have any pieces on your career "bucket list"?

I love new opera, so I hope that many pieces in my career "bucket list" have yet to be written!

Last year, I worked for the London-based label Opera Rara, who record and promote forgotten operas of the bel canto period: I definitely caught a bug there! I found a parallel with performing new music, where the feeling of discovery ignites the entire working dynamic.  Pieces like Auber's *Manon Lescaut*, Halévy *Guido et Ginévra* and Hérold's *Zampa* are very much on my bucket list, and I dream of collaborating with directors who wants to stage that kind of repertoire.

Aside from that: Britten operas, Haydn symphonies and, one day, Benedict Mason's football opera *Playing Away*…