+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-09-24T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "[_Il viaggio a Reims_](https://www.semperoper.de/en/whats-on/schedule/stid/Viaggio-en/61461.html), conducted by Francesco Lanzillotta and directed by Laura Scozzi, runs at Semperoper Dresden, Sept. 28 to Nov. 4."
preamble = "Italian conductor Francesco Lanzillotta, Music Director of the Macerata Opera Festival, is currently in Dresden to help open Rossini's [_Il viaggio a Reims_](https://www.semperoper.de/spielplan/stuecke/stid/Viaggio-en/61461.html) (Sept. 28-Nov. 4). The production is the latest in Lanzillotta's impressive repertoire of _bel canto_ opera - classics like _La traviata_ and _L'elisir d'amore_ are scattered across his calendar - and Rossini's operas take a certain care from the podium.\n\nWe spoke with Lanzillotta ahead of his opening night at the Semperoper, about Rossini traps and opera's future:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569349774/media/2019/09/sqFrancescoLanzillotta-ManuelaGiusto_dsicfz.jpg"
primary_image_credit = "Francesco Lanzillotta, conductor. Photo: Manuela Giusto."
related_articles = []
related_companies = []
related_people = []
short_description = "\"Even the idea of tempo should be very flexible depending on the meaning of the words. Sometimes, even if we don't have a change of tempo written in the score, we should understand when it is necessary to move the musical line forward.\""
slug = "talking-with-conductors-francesco-lanzillotta"
title = "Talking with conductors: Francesco Lanzillotta"
youtube_url = ""

+++
## What are the unique skills necessary to conduct Rossini? What do you think are some common traps or pitfalls with his operas?

The first skill is to know where the main accent of the musical phrase should be stressed. This idea also depends on where the strong accents of the words are and in general which kind of verse is used. In the Italian language there are many different kinds of verses like, "quinario, senario, settenario etc." with different characteristics and the music very often follows them.

Even the idea of tempo should be very flexible depending on the meaning of the words. Sometimes, even if we don't have a change of tempo written in the score, we should understand when it is necessary to move the musical line forward.

We think that playing "leggero" means to play "piano" and this is a big mistake. It means that there are some main points in the music that need to be stressed and then relaxed.

## How does the role of the conductor differ between opera and symphonic work?

I don't think it is so different. Taking care of details such as searching for the right sound and the right idea of "fraseggio", understanding the style of a composer and his identity are the same goals when conducting both opera and symphonic works.

Of course in opera a conductor must understand what kind of voices he has and find a solution if his previous ideas don’t work so well with them. He should be resilient.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569349739/media/2019/09/FrancescoLanzillotta-ManuelaGiusto_wxzsfy.jpg){{% /md %}}

<figcaption>Francesco Lanzillotta, conductor. Photo: Manuela Giusto.</figcaption>

</figure>

## What makes a conductor "singer-friendly"?

As I said before, a conductor must understand the characteristics of the singers that they have in their production and try to model their musical idea on them. Sometimes it's important to convince a singer that he or she can do what you want, even if he or she is not convinced. In order to do this, it's necessary to explain every detail clearly and precisely.

At least, a conductor has to love voices and think about opera as a great teamwork.

## What kind of communication skills does a conductor need to work in opera?

There are a lot of skills that a conductor should have. We could speak about how to create a good work atmosphere, to be convincing about his ideas, and to have a good technique to bring the orchestra and the singers together.

But the most important skill is impossible to describe: it is about the wave of music that must fill the theatre and bring all of the musicians, singers, and choir in a secret place full of magic during a performance. This is the difference between a good conductor and a great conductor.

> I have a dream: I would like to conduct Bernstein's _Mass_, because it is a courageous score.

## What does opera need more of? What does it need less of?

Opera needs a different kind of promotion, focused on the future. It needs to reappropriate its social role, starting from new ideas of promotion using all the possibilities that technology gives us. It even needs more courage to discover all the productions of the last century.

At the same time, it needs fewer vocalists and more interpreters.  We shouldn't forget that opera is theatre, and we have to use the words to tell a story and not only to sing beautiful sounds.

## Do you have any "bucket list" operas that you'd love to conduct? Why?

I have a dream: I would like to conduct Bernstein's _Mass_, because it is a courageous score full of incredible ideas, amazing music, and it is the most authentic representation of crossover music.