+++
author = ["authors/michael-pecak.md"]
categories = "Interview"
date = "2019-10-05T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Lyric Opera of Chicago's production of [_Luisa Miller_](https://www.lyricopera.org/productions/2019-20/luisa-miller/) runs Oct. 12-31."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1570226877/media/2019/10/sqEnriqueMazzolaJean-BaptisteMillot_v2phae.jpg"
primary_image_credit = "Photo: Jean-Baptiste Millot."
related_articles = ["articles/3-ways-to-have-a-great-first-rehearsal.md", "articles/talking-with-conductors-harry-bicket.md", "articles/talking-with-conductors-lidiya-yankovskaya.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/enrique-mazzola.md"]
short_description = "\"Luisa is a character totally surrounded by men who, in that time, control her life. But her father speaks up for her. This makes me think, 'Bravo, Giuseppe! You are speaking about important things for your time.'\""
slug = "talking-with-conductors-enrique-mazzola"
title = "Talking with conductors: Enrique Mazzola"
youtube_url = ""

+++
[Enrique Mazzola](/scene/people/enrique-mazzola/) has been a hot topic lately in the opera world. And rightfully so. Just a few weeks ago, Lyric Opera of Chicago announced that the acclaimed Italian conductor will become the company's [new music director as of the 2021-22 season](https://www.lyricopera.org/about-lyric-opera/leadership/announcement/).

Lyric audiences got to know Mazzola in recent seasons in Donizetti's _Lucia di Lammermoor_ (2016-17) and Bellini's _I puritani_ (2017-18). He's currently in town preparing Verdi's [_Luisa Miller_](https://www.lyricopera.org/productions/2019-20/luisa-miller/), which opens October 12 at the Lyric Opera House, and which kicks off the company's early-Verdi series planned over the course of the next few years, and all to be conducted by Maestro Mazzola.

Verdi and the Italian bel canto occupy a central place in Mazzola's repertoire. But for the dynamic and thoughtful future leader of LOC, there are wider horizons to be explored both inside and outside the opera house. In a recent conversation I had with the maestro, we discussed his thoughts on _Luisa Miller_, Italian opera, and his vision as a 21st-century music director.

To preserve the richness of Maestro Mazzola's responses, I present them below mostly in their entirety. They have been edited purely for syntax and flow.

***

## Although Verdi's _Luisa Miller_ has been done recently at various opera houses in Europe, the opera is nonetheless not that well known, particularly in the US. Where does (or should) this opera fit in the Verdi canon and what makes it a special work for you?

**EM**: I've been reflecting a lot lately on what is the place of _Luisa Miller_ in Verdi's oeuvre. Why is it that _Luisa Miller_ is less known, but an opera from just a few years later like _Rigoletto_ is known across the world? 

My thinking is that there are very iconic elements in the operas that followed _Luisa Miller_, namely _Rigoletto_,_Traviata_, and _Trovatore_. In _Rigoletto_ there is this man with a hunchback, and it becomes memorable; the audience will leave the theater and never forget this strange, suffering man. 

The plot of _Luisa Miller_ is a very beautiful romantic tragedy, but maybe there aren't as many iconic elements. But, I would like to say, that if we speak of the beauty of the music, the bellezza – let me use the Italian word because it applies so much in this case – the bellezza of _Luisa Miller_ is absolutely of the same level as in _Traviata_. The quality of the composition and the emotional impact of _Luisa Miller_ is the same. 

Theaters, then as now, preferred to present the more iconic titles for audiences and I think _Luisa Miller_ suffered for 150 years from this problem.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570227044/media/2019/10/Mazzola4-Jean-BaptisteMillot_iprwjo.jpg){{% /md %}}

<figcaption>Enrique Mazzola, conductor. Photo: Jean-Baptiste Millot.</figcaption>

</figure>

## Throughout his life, Verdi struggled with appeasing censors, so there is often this tension in his operas of negotiating intimate dramas between characters with bigger revolutionary political ideas.

**EM**: Yes, around 1848 was really a troubled period in Italy, when the country was coming out of many revolutionary movements. The opera _Luisa Miller_ of course is based on Schiller, but it is Schiller through the filter of Verdi. The character in the opera of the father, Miller, is in a way the figure of a liberal man. There is a very important moment in which he speaks to Wurm, who wants Miller to force Luisa to marry him. Miller replies, "No, I respect the freedom of Luisa to choose the person she loves."

> "In many ways _Luisa Miller_ is like a study opera in which Verdi explores possibilities that he will develop over the next decades of his life."

Verdi is writing in the middle of the 19th century and here we see a clear generational gap in ways of thinking about society. This for me is one of the revolutionary aspects of this opera. Here is a character who is speaking up, really, for women's rights. Luisa is a character totally surrounded by men who, in that time, control her life. But her father speaks up for her. This makes me think, "Bravo, Giuseppe! You are speaking about important things for your time."

## You are highly regarded for your interpretations of the bel canto repertoire. For a conductor, what are the challenges that are unique to Verdi and particularly to an opera like _Luisa Miller_?

**EM**: I would like to underline the fact that as regards early Verdi, we are still speaking about bel canto style. The tendency is to think of bel canto as Rossini, Bellini, and Donizetti, and then suddenly a guillotine and no more bel canto. The young Giuseppe Verdi grew up in a world dominated by the operas of Bellini and Donizetti. He couldn't escape this; his own first early style was fully bel canto.

_Luisa Miller_, though, is a good example of how, gradually, Verdi begins to explore new possibilities within the style. Many of the formal structures remain, like recitativo, aria, cabaletta. But within these structures Verdi tries new things, new types of accompaniments in the arias and different combinations of colors and dynamics in the orchestration. He's beginning to establish what will later be his true style - the "Verdi" style. We can hear already some musical ideas, which come more fully in his late operas. 

> "To be a conductor is not only to be inside the walls of the opera house or the concert hall, but to be connected to people outside as well."

Many times, we stop in rehearsal and someone says, "Maestro, this seems like _Otello_, or this is like _Ballo_, or that like _Aida_." In many ways _Luisa Miller_ is like a study opera in which Verdi explores possibilities that he will develop over the next decades of his life.

## How do you approach your first rehearsal with a new ensemble?

**EM:** Of course a conductor has to have a global idea of the whole piece from the beginning of the process. But equally important is to know who you are working with because there is usually a big difference between one's initial concept and the final result. But this is natural because we are all human beings. Then through collaboration there is a common development of ideas. This is how I work. I love to listen, and through listening I try to convert all the ideas to one global vision for the piece.

As conductors, we have to accept that we are working with people, other human beings, who have developed their own ideas. For me, it is a pleasure to listen and to tie together all the ideas. This is what I feel my job is as the conductor, generally.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1570227012/media/2019/10/Mazzola3Jean-BaptisteMillot_jcnpan.jpg){{% /md %}}

<figcaption>Enrique Mazzola, conductor. Photo: Jean-Baptiste Millot.</figcaption>

</figure>

## How do you see your role as a music director of a large opera company in the 21st century?

**EM**: I was music director for seven years in Paris, of the Orchestre National d'Île-de-France. There I learned that being music director is not just about the connection of a conductor with an orchestra, but the connection of a conductor with the community. To be a conductor is not only to be inside the walls of the opera house or the concert hall, but to be connected to people outside as well.

> "I would also like to find time to dedicate myself more to contemporary works."

This is my personal mission with Lyric opera of Chicago: to have this be the opera house of all Chicagoans. This means that we at Lyric are ready to go outside the walls to meet new people, people who maybe have not yet had the possibility to get to know us, who haven’t experienced opera. Also connecting with young people who maybe don't know what an explosion of emotions opera is. We need to tell them. This is my vision of an opera house in the 21st century.

## What are some dream projects you would like to realize in the future, possibly with Lyric Opera of Chicago?

**EM**: This _Luisa Miller_ is the first step in a beautiful early-Verdi cycle, which I will conduct entirely. This project will allow us to explore some unknown Verdi titles. It's been a long time since I conducted Puccini, so I think I would like to re-enter the world of Puccini here at Lyric. And with my new music family here, I think it's also time to look at early German Romantic repertoire. So probably some early Wagner will be on the schedule for my repertoire.

I would also like to find time to dedicate myself more to contemporary works. When I was a young conductor, I was conducting lots of contemporary music. Also, the Lyric has fantastic programs like [Lyric Unlimited](/the-positive-impact-of-community-created-performances/) that bring opera to the community. I would like to also be involved in such projects.

***

_With Maestro Mazzola at its helm, LOC has a bright future ahead. It will be exciting to witness the changing of the guard over these next few seasons. I am grateful to Magda Krance, LOC's Director of Media Relations, for arranging and facilitating this interview._