+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-05-30T21:35:00-04:00"
lastmod = "2018-06-01T09:01:00-04:00"
preamble = "British-Italian conductor [Damian Iorio](/scene/people/damian-iorio/) has spent his 2017/18 season on podiums from the UK to Japan. Currently, he is in Paris, rehearsing [*Boris Godunov*](https://www.operadeparis.fr/en/season-17-18/opera/boris-godounov) at Opéra Bastille (**June 7 to July 12**).\n\nIt was great to talk with Iorio about the psychology of working with an orchestra, and his unofficial résumé of duets with famous singers."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527730017553/sqDamianIorio.jpg.jpg"
publishDate = "2018-05-31T11:42:00-04:00"
related_articles = ["articles/gordon-gerrard-music-doesnt-really-work-without-breath.md"]
related_companies = ["scene/companies/opra-national-de-paris.md"]
related_people = ["scene/people/damian-iorio.md"]
short_description = "&quot;Regardless of whether I am with a new orchestra or not, I wish everyone a &#039;good morning&#039; and then start playing immediately. It is important not to waste any time and both sides need to learn about each other.&quot;"
slug = "talking-with-conductors-damian-iorio"
title = "Talking with conductors: Damian Iorio"
+++

### What does it feel like to conduct an orchestra and singers, when everything is going right?

There is sense of freedom, a sense that everyone is connected and expressing the music as one. I always try to develop the understanding and trust between myself, the singers and the orchestra. This helps to free everyone up mentally and physically, which allows everybody to express themselves in a much more unified manor, and to effectively express the emotion and drama of the piece. 

This takes a lot of hard work and many hours of rehearsal time, but for me, the most important thing is to create that connection between myself and everybody else.

My job is also to inspire the performers and develop their feeling and understanding of the music to a point where they feel that it comes from within. If there is a good level of understanding and a connection between a singer and the conductor, then there really is no need for them to watch the conductor. Everybody reads each other without actually needing to look or speak, and that’s what the ideal is, and that is what I look for. Ultimately, the goal is to ensure that the music is being expressed in a clear and interesting way. This feeling creates a sense of freedom, and a sense of everybody being on the same journey and expressing things together as a team.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527730100727/Re%CC%81pe%CC%81titionsBorisGodounov17-2.jpg.jpg)
<figcaption>Rehearsal for *Boris Godunov*, Opéra de Paris. Photo: Elena Bauer/OnP.</figcaption>
</figure>

## What pieces are still on your wish-list to conduct?

I always like to explore and expand my repertoire. I've got a very mixed background given that I'm half English and half Italian, and I've spent years of my life living in Russia and Scandinavia, so there are many works from those countries I'm very interested in performing at some stage. However, I'd say that Mahler's 2nd Symphony is a dream piece I would really love to conduct - it is a work that has had a big impact on me. I heard the Berlin Philharmonic perform it with Claudio Abbado when I was a student and can still remember how much it moved me. I can still remember being there in the hall very vividly. I spoke to my uncle, who was principal 'cello with the London Symphony Orchestra (LSO), about Abbado and his mastery of Mahler's symphonies. My uncle played with Abbado a lot when [Abbado] was chief conductor of the LSO, and he would tell me about how Abaddo was able to make such sense of the big Mahler symphonies.

As far as the opera repertoire goes, I would love to conduct Tchaikovsky's *Queen of Spades*, which is set in St. Petersburg. For those of us who have studied in St. Petersburg, this work means a lot. It's an incredibly deep, traumatic piece. I have studied it and seen it performed many times, but haven't yet had the chance to conduct it. I would also put Wagner's *Parsifal* on my conducting wish list. I would like to start delving deeper into Wagner's operatic repertoire in the future.

### How would you describe the job of a conductor? How does it differ in opera, versus symphonic music?

The essential role of the conductor is to interpret the music being performed, but it's not quite as simple as that! You need to have a good idea about what you believe the composer is trying to express in order to make strong choices relating to colour, tempi, dynamics and so on. More importantly, and particularly with the really great orchestras around the world with the absolute highest level of technical ability, your job is to inspire them and direct them to speak in one, unified way. Everybody has an opinion about how quiet or how loud something should be, or how short or long a note should be, and my job as conductor is to guide them, to get them all to agree on one way to play something with the right emotion and expression.

Opera is slightly different because there's so much going on onstage. When you're dealing with complicated staging situations you sometimes have to approach it in a different way, and some situations are out of your hands as a conductor. You have to trust your singers, building that relationship as I mentioned before, but I think the underlying thing is that you need to inspire the musicians and create a powerful performance. With opera, you are also dealing with the director, and that is two people having a lot of input in an equal manner. There is an opinion that it is very different to conduct opera or symphonic programmes, but I disagree! You have to be clear with what you want from the performers, know your score inside out, and know exactly what you want to say with the music. This is the same whether you're doing a Mozart symphony or a Wagner opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1527730087002/Re%CC%81pe%CC%81titionsBorisGodounov17.jpg.jpg)
<figcaption>Rehearsal for *Boris Godunov*, Opéra de Paris. Photo: Elena Bauer/OnP.</figcaption>
</figure>

### How do you approach a first rehearsal with a new orchestra? What do you think an orchestra looks for in a new conductor?

Regardless of whether I am with a new orchestra or not, I wish everyone a "good morning" and then start playing immediately. It is important not to waste any time and both sides need to learn about each other. I'll be listening carefully and working out the ensemble's character, how much they already know about the repertoire we're doing, how easy it is for them to play and which areas I'll need to work on with them, whether it's the quality of sound, the meaning behind the music, or a certain passage. You have to build a level of trust and communicate effectively so that they feel you're being open with them. There is an old saying that a conductor should never disturb, but should allow musicians to play as well as they can.

In an unfamiliar conductor, the orchestra is looking for someone musical, and someone who can bring something new to the repertoire they are playing, whether that be a new work for them, or something they know well. They want somebody to lead and inspire them, and make their ensemble sound fantastic!

### If you could sing any role in an opera (and sing it well), which one would it be?

I would probably say that I wouldn't sing at all because I'm not a particularly good singer! Having said that, in opera rehearsals, the conductor often has to sing a line because the soloist is absent, or the director needs to go through some technical changes on stage and you have to sing a bit of the score. I actually had to do this recently, as I am currently rehearsing for a production of *Boris Godunov* at the Opéra Bastille in Paris. I get to sing quite a few opera roles in this way! I could even claim to have sung duets with some of the world's most famous singers, because of having to fill in for various people during rehearsals. Then again, it's not "well sung" from me, so I'll stick to conducting thank you very much!

>[*Boris Godunov*](https://www.operadeparis.fr/en/season-17-18/opera/boris-godounov) runs at Opéra Bastille June 7 to July 12. For details and tickets, [click here.](https://www.operadeparis.fr/en/season-17-18/opera/boris-godounov)
