+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-10-20T13:17:00-04:00"
lastmod = "2018-10-22T11:21:00-04:00"
preamble = "Maestro Carlo Rizzi is in good company this fall. He's set to conduct two back-to-back productions at the Metropolitan Opera, starting with [*Tosca*](https://www.metopera.org/season/2018-19-season/tosca/) - featuring superstar [Sondra Radvanovsky](/talking-with-singers-sondra-radvanovsky/) - followed quickly by Boito's [*Mefistofele*](https://www.metopera.org/season/2018-19-season/mefistofele/), with Michael Fabiano as Faust and Christian Van Horn in the devilish title role. After his stretch at the Met, Rizzi heads in February 2019 to Welsh National Opera to conduct Verdi's [*Un ballo in maschera*](https://wno.org.uk/whats-on/un-ballo-in-maschera-verdi) and Donizetti's [*Roberto Devereux*](https://wno.org.uk/whats-on/un-ballo-in-maschera-verdi).\n\nWe spoke with Rizzi about the alchemy that happens between conductor and orchestra, and his fantasy tenor role."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540055599922/sqCarloRizzi-TessaTraeger.jpg.jpg"
primary_image_credit = "Photo: Tessa Traeger."
publishDate = "2018-10-20T13:58:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md","scene/companies/washington-national-opera.md"]
short_description = "&quot;When I start to work with a new orchestra, the first thing that I do is to play through the piece or through large chunks of it. This allows me to get to know the way of playing of the orchestra and, likewise, the orchestra gets to know my way of conducting and if I have a deep knowledge of the piece. This is something, by the way, that experienced musicians know immediately, and you earn or lose their respect in these first moments.&quot;"
slug = "talking-with-conductors-carlo-rizzi"
title = "Talking with conductors: Carlo Rizzi"
+++

### What does it feel like to conduct an orchestra, when everything is going right?

I would like to clarify that, for me, "going right" does not mean technical perfection in the execution of the music. This is obviously also very important but it's not always the determinant factor of the success of the performance. 

For me things "go right" when there is the right feeling of mutual trust between the conductors and the players and singers. Things go right when there is an absolute unity between the orchestra and me in the musical direction that we are going to give to the piece that we are playing. A lot of this work happens during the rehearsals, but the beauty and the inscrutability of making music is that not always the same ingredients give the same result. Every performance is different and some are better than others and in some of them, when everything "goes right", to be a conductor is quite simply the most enjoyable job in the world.

### What pieces are still on your wish-list to conduct?

I have conducted for over 30 years and in this time I covered a very wide range of repertoire both in the concert hall and in the opera theatre (a couple of years ago I conducted my 100th opera title). I haven't conducted Mahler 8 yet, and I would like to approach this monumental work. In the operatic field I think that for every conductor there is the lure of Wagner's *Ring*, and I am not immune from that.

### How would you describe the job of a conductor? How does it differ in opera, versus symphonic music?

The first thing that a conductor must do is to be able to communicate through the hands with the orchestra. The figure of the conductor became necessary with the increased size of orchestras and the more complex rhythmical writing. This is the ABC of the job, like for an actor being able to be understood clearly when he speaks. But this is not only what makes a real conductor. I have been lucky in my life to see performances and rehearsals of Carlos Kleiber, that I consider one of the greatest (if not the greatest) conductors that I came across. The word that better describes what he was doing is "inspirational". This is what makes a conductor stand out from the others. It is difficult to define how to achieve this (in fact only very few conductors can do it) but when it is there then special performances happen.

This is true both for symphonic and operatic music, with the difference that, technically, in opera there are many more things for a conductor to deal with. Chorus, singers, the distance between the pit and the stage and sometimes some staging that is less than helpful to reach a successful coordination between all these different factors. But, beside this, the job of the conductor is always to inspire and unify the skills of many musicians, either in the opera theatre or the concert stage.

### How do you approach a first rehearsal with a new orchestra? What do you think an orchestra looks for in a conductor?

One person walks into a room (no, it's not the beginning of a joke) and in 2 or 3 days of rehearsals he has to forge a very close working relationship with another 70/80 people. There is no other job in the world that has this kind of immediate impact. Getting to know each other is therefore the very first thing and it must happen pretty quickly. This is why, generally, when I start to work with a new orchestra, the first thing that I do is to play through the piece or through large chunks of it. This allows me to get to know the way of playing of the orchestra and, likewise, the orchestra gets to know my way of conducting and if I have a deep knowledge of the piece. This is something, by the way, that experienced musicians know immediately, and you earn or lose their respect in these first moments.

After this first approach it is important to start to work in detail, but without being pedantic or overwhelming. Orchestras want a conductor that gives directions, that is clear, that takes into consideration their way of playing. More that anything I believe that orchestras want to be inspired by a conductor who can and should be the catalyst for everything.

### If you could sing any role in an opera (and sing it well!), which one would it be?

I've always loved the power of the human voice, the nuances, the expression, the feelings that can be heard in a vocal phrase. Singing is like an enhanced way of talking, a way to amplify our feelings as human beings. This is why, if I could sing, I would definitely want to perform a role full of nuances and passion and I would choose Rodolfo in *Bohème*. I have been lucky enough to hear this role sung at La Scala by Pavarotti at the peak of his career when I was a young student and it was pure magic. If to this we add the fact that if I should save one score from flood or fire it would be *Bohème*, the choice is easy.

