+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-12-29T21:05:00-05:00"
lastmod = "2018-01-01T19:53:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514599352183/2017-12-29---Alex_Joel_credit-Julia-Wesely-9467.jpg.jpg"
primary_image_credit = "Photo: Julia Wesely."
publishDate = "2018-01-01T19:53:00-05:00"
related_articles = ["articles/talking-with-conductors-harry-bicket.md","articles/gordon-gerrard-music-doesnt-really-work-without-breath.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/alexander-joel.md"]
short_description = "&quot;I actually started off by doing only operetta,&quot; Joel notes, insistent that learning to lead operas with a lot of rubato is the best way into the technique of conducting. &quot;You have to know how to really control the orchestra with singers, to feel where they&#039;re going to move.&quot;"
slug = "talking-with-conductors-alexander-joel"
title = "Talking with conductors: Alexander Joel"
+++

"I think it's brilliant," says maestro [Alexander Joel](/scene/people/alexander-joel/) of David McVicar's production of *Rigoletto*, currently [onstage at the Royal Opera House](http://www.roh.org.uk/productions/rigoletto-by-david-mcvicar). "Probably the best production of *Rigoletto* I've ever conducted."

McVicar's staging of the Verdi favourite is one that makes good use of the ugly parts of the story, beginning with a disquieting first scene. "It's more than a party, it's an orgy," adds Joel. "It really shocks you right into the piece." 

The production reminds its audience of the disparity between Rigoletto's world, and that of his boss, the Duke of Mantua; McVicar has Rigoletto schlepping around the stage with the meager help of two walking sticks, making it hard to ignore the jester's physical disability as a kind of cruel icing on the cake of his wretched life. Forced to work the potentially dangerous job of a court jester in order to provide for his daughter, Gilda, "Rigoletto is in a conundrum." 

"He has to make fun of all the people in the Duke's court, so he retains the favour of the Duke. In doing so, he provokes their wrath." Be it unconsciously, or the result of a malicious decision, the Duke essentially forces Rigoletto to be an outcast. "He knows he has to be horrible to keep working, to feed his daughter." Of course, the final nail comes when the Duke decides to seduce the naïve, sheltered Gilda - Rigoletto's only living family. "He's desperately scared of losing her."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514599380636/2017-12-20---SOFIA-FOMINA-AS-GILDA%252C-DIMITIRI-PLATANIAS-AS-RIGOLETTO-ROH.-PHOTO-BY-MARK-DOUET_31B2293.jpg.jpg)
<figcaption>Sofia Fomina (Gilda) and Dimitri Platanias (Rigoletto) in Rigoletto, ROH, 2017. Photo: Mark Douet.</figcaption>
</figure>

From the podiums of major opera houses in London, Berlin, Amsterdam, Munich, and Tokyo, Joel has had an up-close look at the work of great directors, and he has grown to understand the difference between stagecraft and shock value. "It bothers me when you can tell the stage director has no technique - no, as you call it in German, *Handwerk* - and just puts shocking things on stage to distract from the fact that he doesn't know what he's doing." 

He admits, "Unfortunately, I've experienced that a lot."

Still, Joel knows well that working in opera is inevitably a collaborative, co-operative action, where the conductor and director are working with the same source material: the score. 

"I try to support the work of a director as much as I can," he says, aware that the experience of a weeks-long rehearsal process can depend greatly on relationships like the one between himself and a stage director. "If there is a problem - something as banal as a singer's standing too far [upstage] and you can't hear him - if you've got along well with the director in the staging rehearsals, when you get to the final rehearsals he'll be more inclined to help you."

## "You start to see music from the point of view of the human voice."

Joel's conducting career began as many have traditionally done, from the piano bench as an operatic coach and répétiteur. "You have to really know how to accompany a singer: lead a singer, help a singer, feel a singer. What voice is he in tonight? Shall I do the tempo slightly faster, slightly slower?" The ability to make these decisions comes out of working closely with singers - in the way that coaches do - which is why perhaps until a few decades ago, "careers used to be made" at the piano.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514599407175/2017-12-29---Alex_Joel_credit-Julia-Wesely-9633.jpg.jpg)
<figcaption>Alexander Joel, conductor. Photo by Julia Wesely.</figcaption>
</figure>

As a rehearsal pianist, Joel played for stagings, did some offstage conducting, and worked under the maestros who would give him his first chances to conduct a professional performance. "It takes many years to develop as an opera conductor," he says, likening the work to a pilot's job of safely flying a plane. "You've got to really know all the possible options to make the plane fly smoothly; one wrong thing, and the whole plane can crash."

"I actually started off by doing only operetta," Joel notes. He echoes the sentiment of Herbert von Karajan, that learning to lead works with a lot of rubato - like the waltzes of operetta - is the best way into the technique of conducting opera. "You have to know how to really control the orchestra with singers, to feel where they're going to move."

After mastering operetta, conducting the sweeping elasticity of a Puccini opera is a natural next step. From there, "a Verdi opera's not quite as difficult," he says, who posits that even the music of Wagner and Strauss are more technically accessible to those used to conducting Puccini and operetta. 

Of course, next to the lighthearted tunes of operetta, the cerebral, murky operas of Wagner and Verdi are often hard to resist for young conductors. Yet Joel warns of starting out too deeply in the repertoire. "If you're given that option, you'll not do it properly." That understanding of singers is the way in not only to conducting opera, but to music as a whole. "Once you do operas, conducting symphonic works is not a problem. You start to see music from the point of view of the human voice."

"Conducting opera is far more complicated than one could perhaps think," Joel says of his work. "The mere keeping everything together, that alone is a job in itself."
