+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-14T09:04:00-06:00"
lastmod = "2017-06-15T22:24:00-06:00"
preamble = "Award-winning Canadian composer [Omar Daniel](/scene/people/omar-daniel/)'s work is full of collaboration, blending the acoustic with the electronic, and commissioning texts from writers like Anne Michaels and Yann Martel. Daniel's works for singers are extensive, including small-scale works for voice and piano, to vocal chamber ensembles, to his opera [*The Shadow*](https://tapestryopera.com/the-shadow-2009/), which premiered in 2009 at with [Tapestry Opera](/scene/companies/tapestry-opera/). He is an Associate Professor of composition at Western University, and he was a pupil of John Beckwith's at the University of Toronto.\n\nIn a concise interview that piques curiosity, Daniel talks about the composers who inspire him, and the problem-solving element of his craft.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497581380037/2017-06-12---Omar-Daniel.jpg.jpg"
publishDate = "2017-06-15T21:29:00-06:00"
related_articles = ["articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-ivan-barbotin.md","articles/talking-with-composers-alexina-louie.md","articles/talking-with-composers-juliana-hall.md","articles/talking-with-composers-david-t-little.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/omar-daniel.md"]
short_description = "&quot;Writing music is like building a house. Some decisions are based on inspiration (what material is the floor? Oak, maple? What colour is the stain going to be?). Others are based on using simple tools to build: a hammer and nails. When I am uninspired, there is always hammer-and-nail work to do.&quot;"
slug = "talking-with-composers-omar-daniel"
title = "Talking with composers: Omar Daniel"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

Perhaps the best way to describe this is by referencing other composers who inspire me.  Two composers that I always look to for compositional advice (I chat with their ghosts) are Bela Bartók and Beethoven.  They both create work that I never tire of listening to, that is rich and complex, that asks the listener to rise to the artistic moment, and that make me want to be a better person.  

Beethoven is fearless.  If you play the opening thirty seconds of each of the 32 piano sonatas, they are each so original and unique, yet clearly Beethoven.  His sense of imagination is jaw-dropping.  Bartók is also unique - extremely so;  I am surprised how popular he is, considering his singular musical language.  Whenever I analyze one of his works, I think: "really...? this language is so unlike anyone else".  He also is a composer who believes that architecture, structure, is the key to a great artistic work.  His *Music for Strings, Percussion and Celesta* is so highly structured, but for me, it has a profound emotional impact.

## How do you write music when you're not feeling particularly inspired (yet)?

Writing music is like building a house.  Some decisions are based on inspiration (what material is the floor?  Oak, maple? What colour is the stain going to be?).   Others are based on using simple tools to build:  a hammer and nails.  When I am uninspired, there is always hammer-and-nail work to do.

## How do you think the perception of being a working composer compares to the reality of the job?

The reality is: a lot of hard labour, and a fair bit of solitary, lonely time.  The perception can be that composers sit and improvise happily, and that it is fun to compose.  I do look forward to composing, but writing music is essentially problem solving:  making hundreds of decisions at any given moment. I like to use the term "house arrest - hard labour".

## Do you have a song/album/artist that you'd consider a guilty pleasure?

Oh, many. I don't feel guilty about any of my listening tastes, and I have (by all accounts), some questionable favorites.  My kids like popular music, and recently they've learned Journey's "Don't Stop Believing".  Some might consider that a guilty pleasure, but I will debate anyone regarding the merits of that song.  I specifically bought a bass guitar so I could learn the bass line. Then I learned P.J. Harvey's "Bring You My Love", and Rage Against the Machine's "Bulls on Parade".  As far as classical music goes, Vivaldi's *Four Seasons* is still my go-to listening experience.  It does get overplayed, but for good reason.  

## Out of your body of work, what are you most proud of, to date?

That changes.  I recently heard a work of mine that I wrote in my late 20s.  It fell out of favour with me for twenty years, but now it sounds pretty good.  My relationship with my own music and with other artists' work is dynamic, and changes in unpredictable ways.  I would say that often the works that I am most fond of are ones that came from a strong relationship with the performers, and that were the type of collaboration that culminated in an excellent performance.  They create a whole "experience" of composition and interpretation that has a lasting impact on me.
