+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-04-16T01:52:59+00:00"
disclaimer = ""
image_gallery = []
postamble = "For more with Mark Grey, [visit his website](http://markgreycomposer.com/)."
preamble = "Mark Grey is unique among opera composers: he's only written one (so far), based on and sharing a title with Mary Shelley's infamous novel, _Frankenstein_. His work just went up at La Monnaie, and was followed this month with his _Frankenstein Symphony_, at Rome's Auditorium Parco della Musica.\n\nGrey is also a sound designer, having worked with the likes of the Kronos Quartet, John Adams, and Philip Glass.\n\nWe spoke with Grey about his composing process, and his unique vantage point on the performing arts:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1555379766/media/2019/04/sqGREY04-IMAGE-BY-StellaOlivier.jpg"
primary_image_credit = "Mark Grey, composer and sound designer. Photo: Stella Olivier."
related_articles = ["articles/michael-christie-new-opera-that-the-box-office-loves.md", "articles/talking-with-composers-brian-harman.md", "articles/talking-with-composers-aaron-gervais.md"]
related_companies = ["scene/companies/la-monnaie.md"]
related_people = []
short_description = "\"Getting my hands dirty planting the earth, tending to the land with a chainsaw, baking and brewing, reading, and maybe driving up the Highway 1 coastline will ultimately blow out any cobwebs. Also, long walks and hikes really get my ideas flowing.\""
slug = "talking-with-composers-mark-grey"
title = "Talking with composers: Mark Grey"
youtube_url = ""

+++
### How would you describe your musical aesthetic? How have you heard it described by others?

I often hear that my music is very colourful. I spend a great deal of time working on orchestration and exploring acoustic and electronic instrument combinations, harmonic and rhythmic relationships to help further evoke an emotional state in which I am trying to set. One of the most profound experiences in writing an opera, such as _Frankenstein_, is that all of the emotions are laid out, on stage, in Technicolor.

>We are demanding more clarity from our artistic experiences and opera is no different.

### How do you write music when you're not feeling particularly inspired (yet)?

I am always inspired by the family, friends, colleagues, music and art surrounding me. I might at times procrastinate (who doesn't), but to remedy this I find myself working on non-musical projects around home. My wife and I live in a fixer-upper farmhouse on seven acres of timberland about 45 minutes north of San Francisco. There are endless projects around the property.

Getting my hands dirty planting the earth, tending to the land with a chainsaw, baking and brewing, reading, and maybe driving up the Highway 1 coastline will ultimately blow out any cobwebs. Also, long walks and hikes really get my ideas flowing. I imagine Mahler taking long walks in the Austrian Salzkammergut to find inspiration.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555379880/media/2019/04/creacio_final.jpg){{% /md %}}

<figcaption>A look at the scenic design for Mark Grey's opera, Frankenstein, La Monnaie, 2019. Image: Alfons Flores.</figcaption>

</figure>

### What are the unique challenges of working on the sound design of a live genre like opera? What might an opera fan find surprising about your sound design for opera and concert work?

Sound design in opera and orchestral concert music is a fairly new concept – set and costume designers have been around for centuries. As we find ourselves deeper in the 21st century, the way in which we listen to music is changing due to the advent of digital audio recordings, television, live HD opera simulcasts and performances of all genres using high-quality sound systems.

We are demanding more clarity from our artistic experiences and opera is no different. As more living composers write more operatic works, the rules will continue to change. Composers are explorers and we always test the grounds on which we stand. Wagner built his own theatre to create his perfect sound world. One could say that he was an early pioneer of sound design.

>I never feel guilt in music, no matter what genre or flavour.

### How do you think the perception of being a working composer compares to the reality of the job?

There is often the perception that when creative writers have that "flash" of inspiration, the work is done. For myself, after those initial inspirational moments, the reality of the work schedule is often a rigorous 5am through 7pm routine – often without days off, and in solitude. For the _Frankenstein_ opera, I sustained this for 14 months. That is the reality.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1555379896/media/2019/04/GREY01-IMAGE-BY-StellaOlivier.jpg){{% /md %}}

<figcaption>Mark Grey, composer and sound designer. Photo: Stella Olivier.</figcaption>

</figure>

### Do you have a song/album/artist that you'd consider a guilty pleasure?

Not really. I never feel guilt in music, no matter what genre or flavour. Composers experience life through their sonic palettes. I tend to live by the ethos, keep an open ear.

### Out of your body of work, what are you most proud of, to date?

Each work is a piece of me – like Victor and the parts which make up his creature. All of the individual works make up the body. Without one work, there are no others.