+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-11-13T13:52:00-05:00"
lastmod = "2017-11-19T21:04:00-05:00"
preamble = "American composer [Mark Adamo](/scene/people/mark-adamo/), known best for his widely performed debut opera, *Little Women*, recently saw the DVD and Blu-Ray release of his latest work, [*Becoming Santa Claus*](https://store.cdbaby.com/cd/thedallasopera). On **December 2**, National Sawdust presents [*A Night of Mark Adamo*](https://nationalsawdust.org/event/a-night-of-mark-adamo/), featuring selections of the Adamo's music and a live chat with the composer himself.\n\nWe had the chance to ask Adamo about tackling a story as well-known as that of Santa Claus, his own perception of his aesthetic, and the tricky combination of musical notation and stage direction."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510700462425/2017-11-14---square---MA%2C-solo%2C-empty-pavilion%2C-side-glance.jpg.jpg"
primary_image_credit = "Mark Adamo, composer, from The New York City Opera tour, to Tokyo and Nagoya, of Mark Adamo’s Little Women: portraits courtesy Joe McNally."
publishDate = "2017-11-19T20:33:00-05:00"
related_articles = ["articles/talking-with-composers-alexina-louie.md","articles/kevin-puts-i-know-who-i-am-as-a-composer.md","articles/american-opera-projects-youre-seeing-the-opera-in-microcosm.md"]
related_people = ["scene/people/mark-adamo.md"]
short_description = "What&#039;s your style?&quot; is a famously unanswerable question. I can certainly talk about values, which other opera creators may share, or not. Certainly I&#039;m a composer who would rather give the illusion of working in close-up, rather than longshot; by which I mean that I want my music to sound as if it is inflected — no, as if it is generated — by the character who&#039;s singing it, rather than generated by some preconceived orchestral plot or procedure."
slug = "talking-with-composers-mark-adamo"
title = "Talking with composers: Mark Adamo"
+++

#### Your upcoming [event at National Sawdust](https://nationalsawdust.org/event/a-night-of-mark-adamo/) focuses on the issue of transformation in each of your operas. Do you think you're drawn to these aspects of the characters initially, or do you find that your approach to storytelling tends to hone in on that trait as you're writing the piece?

Probably the latter. Drama may not always be built on conflict — read Richard Nelson's wonderful [thoughts](https://www.newyorker.com/culture/culture-desk/richard-nelsons-meditative-play-about-joseph-papp-and-the-founding-of-the-public-theatre) on this issue at *The New Yorker* — but it's certainly built on changing relationships; which comprise, of course, the most interesting challenges for an actor to play. I try to begin an opera with the big, zoomed-out question: why are we here in the theatre tonight? What hurt do we bear that this tale might help to heal?  Still, the second question, for me, is, always: how is this question actable? How will [Jo](http://www.nytimes.com/2003/03/26/books/opera-review-alcott-s-sisters-grow-from-page-to-stage.html), or [Lysia](https://www.dmagazine.com/arts-entertainment/2012/05/opera-review-lysistrata-an-ancient-story-fit-for-the-modern-ear/) or [Prince Claus](https://www.dmagazine.com/arts-entertainment/2015/12/the-dallas-opera-delivers-a-wild-christmas-gift-with-becoming-santa-claus/), end up somewhere different from where s/he began; and how can the paths they light illuminate our own? If your principal vehicle, as a creator, isn’t the audible, the legible process of characters evolving through time, shouldn’t you be an essayist?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510700568193/2017-11-15---MA%2C-koi-pond%2C-well.jpg.jpg)
<figcaption>Mark Adamo, composer, from The New York City Opera tour, to Tokyo and Nagoya, of Mark Adamo's *Little Women*: portraits courtesy Joe McNally.</figcaption>
</figure>

#### Do you feel like your spin on the Christmas story in [*Becoming Santa Claus*](http://www.markadamo.com/becoming-santa-claus-dvd-and-blu-ray/) is a rebuttal or a complement to the narrative we all know? 

Which narrative? In my research for this piece, I was surprised to learn how little "there" is there in the backstory of Santa Claus. You encounter yawning lacunae between the Norse Odin (yes, he's an early source for the Santa figure) through certain medieval Christian bishops renowned for their charity, to, finally, the plump Victorian-English elf of beneficence — who's less a character in his own right than a handy megaphone for the idea of the Joy! of Spending! Money! to Show! Your Love! And, in most of the Anglophone world, it’s the secular iconography — the Santa iconography — that becomes ubiquitous as soon as the leaves begin to rust and drift. The Christian story? Well, if it matters to you, you celebrate it in church and at home; if not, no one's forcing you to kneel at the crêche.

And yet... I wonder — even, or especially, in a culture that grows more secular every second — if there isn’t some longing to start with the sense of intimate community of miracle, of moral dignity that many derive from the Nativity tradition; but then to combine it with the glamour, the fantasy, and the larger, more eclectic sense of community you find in the Santa (or the New York) world. Could one then come up with something as nourishing as the former but as progressive as the latter? Certainly — when I found a way to work the Three Kings into the narrative — I saw an opportunity to do that very thing: and that's when I got very excited about *Becoming Santa Claus*. A secular Nativity scene: not for a religious person, but for the persona of Santa Claus! How can you not try to write that?

#### Is there any existing opera or musical theater piece that you wish you could've written first? How would you approach the subject differently?

Actually, I've tended to arrive at certain topics earlier than most. The New York run of my [*Little Women*](http://www.markadamo.com/little-women/) preceded the [Broadway one](https://en.wikipedia.org/wiki/Little_Women_(musical)) by four years; my [*Lysistrata*](http://www.markadamo.com/lysistrata/), in New York, preceded a [new theatrical take](https://en.wikipedia.org/wiki/Lysistrata_Jones) by five years, and — though theirs took the stage first — my [*Gospel of Mary Magdalene*](http://www.markadamo.com/the-gospel-of-mary-magdalene/) was announced a bit earlier than [Mr. A.'s and Mr. S's](https://en.wikipedia.org/wiki/The_Gospel_According_to_the_Other_Mary). So far, no one's gotten to something I wish I'd gotten to first. If I feel that disclosing such a topic risks giving another artist a head-start, though, I shall err on the side of discretion...

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510700645450/2017-11-14---Mark-Adamo-in-studio.jpg.jpg)
<figcaption>Mark Adamo, composer, from The New York City Opera tour, to Tokyo and Nagoya, of Mark Adamo's *Little Women*: portraits courtesy Joe McNally.</figcaption>
</figure>

#### If you could sum up your style in a few words, how would you describe it? What aspects of your composing most differentiate yourself from other composers and librettists?

"What's your style?" is a famously unanswerable question. I can certainly talk about values, which other opera creators may share, or not. Certainly I'm a composer who would rather give the illusion of working in close-up, rather than longshot; by which I mean that I want my music to sound as if it is inflected — no, as if it is generated — by the character who's singing it, rather than generated by some preconceived orchestral plot or procedure. I love when words, voice, line, and harmony, seem to fuse — seem to become one thing — more than I love hearing  "text" being "set," like "shoes" in "cement." It is certainly true that I refuse to use a thousand notes if I can tell the truth with two. Also: as a composer — I'm not a brute. Also: as a composer — I don't pummel. Shall we leave it at that?

#### Your involvement during rehearsals for a world premiere tends to be hands-on. How do you choose which moments to fight for a specific piece of staging or phrasing, and how do you know when to trust the director, conductor or singer (even when you disagree with them)?

This might surprise your readers, but I tend to have fewer conflicts with conductors or singers over phrasing, dynamics, etc., precisely because I can specify my intent in greater detail than I can (or choose to, as a librettist) when it comes to moments like, "after this word, Principal X moves the back of her hand to her forehead…" No singer who has ever worked with me, I believe, can claim that I have argued more for the written notation than for the emotional gesture that such notation is designed to empower. A composer doesn't want pianissimo, s/he wants heartbreak: but s/he can only specify the former. (More on this [here](http://www.markadamo.com/the-singer-as-orchestrator-after-the-salon-2/).) 

Staging, direction, is trickier, precisely because it's an artistic practice — influenced by, of course - butmuch less beholden to a written score. And I — vis-à-vis the director of a world premiere — am in a trickier position than many, because I've worked as a stage director myself. So you're constantly dancing with the following question; "A) Is this choice an incorrect interpretation of the writing; or is it B) a correct interpretation of the writing that is not, nonetheless, the way you would direct it if you were directing it?" If the answer to A) is yes, then it's incumbent on you to make the case for why the writing is right and the staging is wrong. If the answer is B) you have a sterling opportunity to learn more about the mysteries of both writing and directing, if you're humble enough to keep quiet and pay attention.

#### You've seen hundreds of performances of [*Little Women*](http://www.markadamo.com/little-women/) (one opened on Friday in [Colorado](https://www.facebook.com/events/455782174817687/)). Could you share one moment when a performer did something completely unexpected which made you feel like you were seeing and hearing it for the first time?

Over a hundred-twenty, and counting! The opera has been a [great friend](http://news.musicsalesclassical.com/wAqsjrloTRssJEdaQhRhPK_QJnw7tVTFmOTk3oc4T9z/WebView.aspx) to me. But, to your question: I can; and her choice changed my way of thinking about a character I thought I knew. When Stephen Sondheim first screened the video of [*Little Women*](https://www.amazon.com/Adamo-Little-Women-Joyce-DiDonato/dp/B0040AT65Q), he told me he thought of Cecilia March as "the Bette Davis part;" and certainly the role can be successfully played as merely a brittle and stylish doyenne, proud of her cynicism. But when I was working with the extraordinary vocal artist [Lorraine Manz](https://www.oberlin.edu/lorraine-manz) on the role in the production I directed for Lyric Opera Cleveland, she interpreted the character as someone whose heartbreak had matched and even exceeded Jo's own; yes, the opportunities lay waiting in the script and score, but no singer had taken those opportunities and made such a tragicomic tour de force of the part before Lorraine did.

#### Besides a Grammy award for [*Becoming Santa Claus*](https://store.cdbaby.com/cd/thedallasopera), what are you most hoping to receive or achieve this holiday season?

Well. (Deep breath.) Winning an award is not a goal. Seriously! I must admit that the recording goddesses, both audio and visual, smiled broadly on this DVD of [*Becoming Santa Claus*](https://store.cdbaby.com/cd/thedallasopera); you’ll think of the piece whatever you think of the piece, but, my God — the performance! How it looks, and moves: how it sounds!  *Becoming Santa Claus* was but one of two world premières Dallas Opera had scheduled within two months, and there were any number of intelligible reasons why that season's opener would preëmpt national coverage. But there's such an opportunity now, given the film, for the project to reach the audience for which it was always intended; and I'd love to learn what happens when, and as, it does!

>[A Night of Mark Adamo](https://nationalsawdust.org/event/a-night-of-mark-adamo/) happens December 2, 7pm at National Sawdust. For details and tickets, [click here](https://nationalsawdust.org/event/a-night-of-mark-adamo/).
