+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-03T15:03:00-06:00"
lastmod = "2017-07-08T09:07:00-06:00"
preamble = "Toronto-based composer [Kieren MacMillan](/scene/people/kieren-macmillan/)'s body of work includes chamber operas, musicals, film and TV scores; when he's not writing music,  he's an in-demand pianist, music director, and singer. MacMillan is currently writing a new song cycle for [HAVEN trio](http://www.haventrio.com/) and a large-scale work for the MIT Symphony Orchestra; plus, you can see him as Judge Turpin in [*Sweeney Todd*](http://www.sweeneytoronto.com/) this October.\n\nMacMillan offers an honest interview about perfectionism, \"guilty pleasure\" music, and being a chameleon-like composer."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499229708826/2017-07-05---MacMillan-square.jpg.jpg"
publishDate = "2017-07-07T22:56:00-06:00"
related_articles = ["articles/talking-with-composers-alexina-louie.md","articles/talking-with-composers-cecilia-livingston.md"]
related_people = ["scene/people/kieren-macmillan.md"]
short_description = "&quot;I think people believe I can punch in at 9AM, and by 5PM I&#039;ll have written a few minutes of music I&#039;m proud to send out the door. There are lots of composers who can, of course — I truly wish I were one of them, but it can take me hours or even days to get out of one mindset and into &#039;the zone&#039; of music composition.&quot;"
slug = "talking-with-composers-kieren-macmillan"
title = "Talking with composers: Kieren MacMillan"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

Maybe it's a bit of a cop-out (aren't all labels?), but I guess I'd describe my musical aesthetic as "context-sensitive": if I'm writing a Broadway-style musical, I'll write straight-up show tunes; in *Drunken Moon* (my companion piece to Arnold Schoenberg’s *Pierrot Lunaire*), I channeled 20th Century German atonality; my ragtime piano solos were written to evoke that nostalgic sound; and so on. Each new piece is its own puzzle, and I try to find the musical world that best solves it.

That being said, the main reason I compose music is to communicate with an audience, so I favour sounds that are accessible (read: tonality), forms that are familiar (read: Classical), and gestures that are primarily expressive (read: Romantic and Impressionist). My main influences are pretty obvious: film scores, jazz, opera and musical theatre, European and North American art music of the last thousand years, and popular music of the last hundred years. But I feel like I synthesize everything I hear, in my own personal way.

My first composition teacher called me a "post-Gershwin neo-classical reductivist". Other than that (and reviews of individual works, of course), I don't know that anyone has ever even tried to describe my musical aesthetic in any meaningful way.

## How do you write music when you're not feeling particularly inspired (yet)?

I consider all work-related collection of data and experiences to be part of the composition process. So if you mean "write music" in a general sense, my answer would be that I do a lot of research and study when I'm not yet inspired: I'll find pieces to model, and analyse them; I'll read about the people or places I'm writing about or channeling; I'll do whatever I can to keep the momentum going forward.

If you mean *actually* writing *actual* music when I don't feel inspired… well, I'm pretty bad at that part. I'll find any number of ways to avoid writing down notes when I don't think they're "the perfect ones". I am fortunate in that I almost always have an initial instinct about the piece or passage that I'm working on, and that instinct usually includes musical material I love. The problem is then living up to the promise of that inspiration. (Don't even ask about the number of pieces I've started that are waiting for me to finish!) 

That's when my perfectionism kicks in. In the past, when trying to get over that inevitable hump, I've turned on my brain: I looked for (or created) patterns, tried to squeeze the material into "interesting" counterpoint, and so on. But recently, I've been encouraging my emotional self to drive the bus, by writing "left-to-right": I just fill one measure, then fill the next one, and continue measure-by-measure until I reach the double bar. This has led to very different pieces than I would have composed a few years ago — but I think the music is more authentic, and that's really the ultimate metric for me.

## How do you think the perception of being a working composer compares to the reality of the job?

Although it's gotten better recently, I think the general public still holds onto the "Amadeus" myth that working composers are conduits of some benevolent Muse and we spend our wine-soaked days (and late nights) writing furiously as we try to capture on paper the Pure Art that pours down from that unknowable and unstoppable Fount of Inspiration. The reality is (to borrow a quote from my father) "a more workman-like application to the bench": hours or days or even weeks of methodically exercising whatever craft we've honed over the years, punctuated (hopefully!) by moments of real creative flow.

The other big disconnect is that — at least for me — it's far easier to turn certain jobs (e.g., computer programming) on and off around the rest of my life (e.g., being a father and husband) than it is with composition. I think people believe I can punch in at 9AM, and by 5PM I'll have written a few minutes of music I'm proud to send out the door. There are lots of composers who can, of course — I truly wish I were one of them, but it can take me hours or even days to get out of one mindset and into "the zone" of music composition.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

Oh, I have a huge number of "guilty pleasure" songs/albums/artists! *Beauty and the Beast* (the Disney movie), Nik Kershaw's "Human Racing", The Police (all of it)… the list goes on and on.

## Out of your body of work, what are you most proud of, to date?

That's really an impossible choice to make, because my works live in so many different worlds. [*Drunken Moon*](http://kierenmacmillan.info/drunken-moon/) was a watershed for me as a composer, and over a decade later I'm still really proud of it. [*The Gray Cat & The Flounder*](http://kierenmacmillan.info/gcf/) (a one-hour concert drama commissioned by a man in memory of his late wife) strikes a real emotional connection with the people who have seen it, which makes me happy. My stage musicals are dotted with individual songs — such as "Waiting" (from [*Fairy Tale Ending*](http://kierenmacmillan.info/fairy-tale-ending/)) and "ToboR, You're My Friend" (from *ToboR the RoboT*) — that I'm immensely proud of.

>For more about Kieren MacMillan, please [visit his website.](http://kierenmacmillan.info/)
