+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-21T09:07:00-06:00"
lastmod = "2017-07-03T22:07:00-06:00"
preamble = "American composer [Juliana Hall](https://www.julianahall.com/about-juliana-hall/) has over 50 song cycles and vocal chamber works to her name, her most recent cycle having just premiered in Los Angeles at the 2017 SongFest program. Since turning to composition in her 20s, Hall has written for the likes of Dawn Upshaw and Brian Asawa, and her music has been heard in 29 counties; just this past season, she heard the world premieres of five new works for voice and piano.\n\nIn a delightful chat with the voice-friendly composer, she speaks about writing \"active piano parts\" in her songs, and how the tough parts of the job are easily outweighed by the pleasure of composing."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498057683874/2017-06-21---composer-juliana-hall.jpg.jpg"
publishDate = "2017-07-03T22:07:00-06:00"
related_articles = ["articles/talking-with-composers-omar-daniel.md","articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-alexina-louie.md"]
short_description = "&quot;Despite its difficulties, there is nothing I can imagine I would rather be doing with my life than composing art songs...it is my world, and it is where I belong.&quot;"
slug = "talking-with-composers-juliana-hall"
title = "Talking with composers: Juliana Hall"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

My art songs follow in the path forged by earlier American song composers, including Dominick Argento, Samuel Barber, George Crumb, Lee Hoiby, Charles Ives, and Ruth Crawford-Seeger, as well as other English-language composers of art song including composers like Benjamin Britten, Ivor Gurney, John Ireland, and Ralph Vaughan Williams.

Although tonally-based, my art songs employ what I call an extended tonality; the music is often shifting between fleeting tonal areas oo layering several different tonal areas one upon another as the text is depicted.  As the music moves through and about various tonal areas, it seldom stays in "a key" the way music of the past does; rather, it follows the guidance of the text to find its own harmonic world reflective of that text.

Gramophone Magazine recently remarked in a review of my new solo CD ("Love's Signature", MSR Classics, MS1603) that my songs show me to be "a composer who savours lyrical lines and harmonies peppered with gentle spices."  That's an excellent description, I think, because I love the lyrical in both music and in poetry, and work very hard to compose lines that soar...but all within a harmonic framework that is at once fresh, yet subtle.

In addition, as a pianist myself I enjoy writing very active piano parts...more "equal" to the voice than the piano parts many other composers write.  To me, there is much interest to be had from the interplay between voice and piano that goes far beyond the traditional formula of soloist (primary) and accompaniment (secondary).  In art song, we have the potential for two very equal partners to work together to depict text, and I have been told by quite a few people that my approach to this aspect of songwriting also lends a distinctive sound to the art songs I write.

## How do you write music when you're not feeling particularly inspired (yet)?

Funny you should ask that, because I recently posted something about
this on Facebook:

"Write through it. Tired, other things to do, not in the mood to work, want to read, headache?  Write through it.  Write, and write, and write.  Don't wait for 'inspiration' - sit down to work and demand 'inspiration' from yourself.  Write through it.  And keep writing."

That pretty much says it all.  If you're a professional, you can't wait for a lightning bolt of "inspiration" to hit - you need to establish a pattern of regular work, like other people who go to an office every day according to a regular schedule, whether they feel inspired to be going there, or not.

## How do you think the perception of being a working composer compares to the reality of the job?

When someone meets me and learns that I compose, they're usually very excited about how "wonderful" it is...however, the reality is far less glamorous; in a word...it is work.  While they are correct that, to be able to compose an art song truly is "wonderful," it doesn't usually pay the bills, and it most certainly does not provide ongoing medical insurance, retirement, and other benefits like paid time off that so many people in "regular" jobs take for granted.

Academic work can provide stability for some composers, but those jobs require many hours of preparation and delivery of services which, themselves, erode a composer's ability to actually write music...and to do that sort of job well, one must be inclined academically, which I am not.

Commissions help, but few of us have either a steady enough stream of commissions (or large enough commissions) to provide a "regular" lifestyle...people like me make our money by playing in religious services, teaching lessons, or working in musically-related fields like engraving or editing.  Cobbling together a financial life from these disparate sources provides color and variety, but doesn't usually offer financial security or peace of mind...realities of the job that, frankly, can be difficult to live with.

All that said, however, I should say that - money or no money - the experience of writing a piece of music for a specific singer, and then hearing that singer bring that musical work to life in performance, is one of the most satisfying experiences I can imagine any human being having.  It is in those moments that one feels the blessing in one's life and the full joy of sharing in the making of something beautiful with other wonderful musicians, even if that beauty is ephemeral.

Despite its difficulties, there is nothing I can imagine I would rather be doing with my life than composing art songs...it is my world, and it is where I belong.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

Not really, at least in the sense that many people do.  But - within what we consider to be western "classical" music - are pieces of music as different and disparate as Bach fugues, a Stockhausen quartet that incorporates helicopters (!), medieval chant, the rugged and towering musical structures of composers like Galina Ustvolskaya, gentle oboe concertos by 17th- and 18th-century Italian composers such as Marcello, and electrifying dance works of composers like René Aubry and Philip Glass...there is a LOT within "classical" music from which to find pleasure.

I love listening to very great performers, both instrumentalists and singers.  Whether hearing someone like Alfred Brendel play Beethoven at Carnegie Hall or listening to Jorma Hynninen sing *Winterreise* at Tanglewood, there is a great wonder and joy in hearing mastery that allows the music to soar beyond the limits of the technical.

A few recent pleasures (though not guilty ones) include my discovery of the amazing pianist Grigory Sokolov - a remarkable artist - and the powerful Hungarian soprano Erika Miklósa as Mozart's "Queen of the Night"...the incredible soprano Audrey Luna (who sings the Thomas Adès operas so stunningly) and the amazing soprano Tony Arnold (singing works of Crumb, Webern, and so many others so spectacularly)...the rich, velvety music of the English composer Jonathan Dove and the wonderful songs of Alan Louis Smith...the gorgeous communicative power of Stephanie Blythe, and marvelous instrumentalists like trumpeter Håkan Hardenberger, the splendid harpist Catrin Finch, and outstanding percussionist Evelyn Glennie...lovely preludes and fugues by Mendelssohn...powerful and colorful works of contemporary American composers Laura Elise Schwendinger and Elena Ruehr...the list just goes on and on.

## Out of your body of work, what are you most proud of, to date?

"O Mistress Mine", my song cycle for countertenor and piano on texts from plays by William Shakespeare.  My largest work, comprised of twelve songs lasting 42 minutes, I wrote this piece for the renowned countertenor Brian Asawa.  I was so inspired by Brian's uniquely plush sound, and we were so excited to premiere the piece together...but then, as you probably know, he died suddenly and most prematurely at the tender age of 49 (with just a few months to go before our premiere).

One of his friends, countertenor Darryl Taylor, stepped in and learned this mammoth work in a mere couple of months, and we premiered it together last August at the Norfolk Chamber Music Festival (summer home of the Yale School of Music).  Darryl, who himself has such a lovely voice, brought such deep musicality and creative imagination to the songs, so the premiere was beautiful and the resulting recording is, I think, stellar.

In the composition of "O Mistress Mine" - and in its performance and recording as well - I came about as close as I have ever come to satisfying my desire to convey a set of texts with music that is both reflective of their message, while rendering it in a completely unique way...not an easy thing to do with a text like Shakespeare, which has been set, literally, by hundreds of other composers over the past 400 years.
