+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2019-07-18T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Jonathan Dove's [_Mansfield Park_](http://www.waterperryoperafestival.co.uk/mansfieldpark.html) appears at Waterperry Opera Festival, 25-28 July, and he sees a new commission premiere on 5 October at the [London Piano Festival](https://www.kingsplace.co.uk/whats-on/classical/two-piano-marathon-with-katya-apekisheva-charles-owen-christian-ihle-hadland-ingrid-fliter-susan-tomes-tim-horton/). The Canadian premiere of Dove's [_Flight_](https://www.pov.bc.ca/season.html) is at Pacific Opera Victoria, 20 February, 2020. His latest CD, [_The Orchestral Music of Jonathan Dove_](http://www.orchidclassics.com/releases/orc100097-the-orchestral-music-of-jonathan-dove/), is available now on Orchid Classics."
preamble = "English composer Jonathan Dove, who just celebrated his 60th birthday, is settling in for a busy summer. At this year's BBC Proms is the world premiere of Dove's [_We Are One Fire_](https://www.bbc.co.uk/events/e4j6gw), on a, 19 August program shared with the new Piano Concerto by Dieter Ammann, and Beethoven's Ninth Symphony.\n\nDove also sees a new BBC Orchestra recording, [_The Orchestral Music of Jonathan Dove_](http://www.orchidclassics.com/releases/orc100097-the-orchestral-music-of-jonathan-dove/), on Orchid Classics;  which includes his _Airport Scenes_ and excerpts of his widely-performed opera, _Flight_.\n\nWe spoke with Dove about his impressive output as a composer, and what projects make him the most proud."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1563482141/media/2019/07/sqDoveIMG_6958-1.jpg"
primary_image_credit = "Photo: Marshall Light Studio."
related_articles = []
related_companies = []
related_people = []
short_description = "\"I don't try to write anything down until it's already quite a long way to being finished in my mind. Before that, I just keep playing (piano or keyboard) until I have an idea that seems to have a future, and then follow where it leads.\""
slug = "talking-with-composers-jonathan-dove"
title = "Talking with composers: Jonathan Dove"
youtube_url = ""

+++
## How would you describe your musical aesthetic? How have you heard it described by others?

I like melodies that you can sing, rhythms that you can dance to, and ideas that you could call "catchy". I want it to appear effortless, and I want the audience to be able to enjoy it on first hearing. (However, it isn't effortless for the performers!)

People hear all kinds of echoes, especially of Britten, John Adams and sometimes Bernstein. It's certainly towards the tonal end of the spectrum.

## How do you write music when you're not feeling particularly inspired (yet)?

I don't try to write anything down until it's already quite a long way to being finished in my mind. Before that, I just keep playing (piano or keyboard) until I have an idea that seems to have a future, and then follow where it leads. When I get tired of playing, or nothing's really taking off, I walk or cycle somewhere, maybe visit a gallery or a museum, or read.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1563498979/media/2019/07/DoveIMG_7234BO.jpg){{% /md %}}

<figcaption>Jonathan Dove, composer. Photo: Marshall Light Studio.</figcaption>

</figure>

## How do you think the perception of being a working composer compares to the reality of the job?

Partly, the perception is right: you are on your own a lot of the time (even if you're not actually in an attic), maybe playing phrases over and over again until they feel right, jotting things down...

But it also has its social side: meeting writers and directors and singers with whom you're going to collaborate, attending rehearsals where suddenly you're surrounded by hundreds of people trying to perform your music, meeting your audience before a concert and telling them about your new piece.

And sometimes you get invited to performances of your work in exciting places: I once went to see a production of one of my operas in Hawaii.

## What do you know now about composing that you wish you knew 10, 20, or 30 years ago?

I ought to have an answer, but I'm not sure what it is! Some pieces come easily, some are a struggle, but they're always a leap into the unknown. I never feel any wiser. The more you write, the harder it gets to find something new, something you haven't done, and maybe it gets a bit harder to feel really satisfied with a new piece – I'm glad I didn't know that 30 years ago!

## Do you have a song/album/artist that you’d consider a guilty pleasure?

The songs from _The Little Mermaid_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1563498963/media/2019/07/DoveIMG_7040BO.jpg){{% /md %}}

<figcaption>Jonathan Dove, composer. Photo: Marshall Light Studio.</figcaption>

</figure>

## Out of your body of work, what are you most proud of, to date?

My comic opera _Flight_ really took off (excuse the pun) and has been produced around the world, to an extent that is quite unusual, so I'm certainly proud of that. And another opera, _The Monster in the Maze_, has been performed in more different languages than any other work of mine, so that also gives me the very satisfying feeling that I have made something useful.