+++
author = ["authors/eva-cahen.md"]
categories = "Interview"
date = "2018-10-10T20:55:00-04:00"
lastmod = "2018-10-12T14:31:00-04:00"
preamble = "David T. Little's opera, [*Soldier Songs*](https://www.laopera.org/season/1819-season-la-opera-season/soldier-songs/), is being co-presented by the LA Opera with the Ford Theatres and Beth Morrison Projects at the Ford Theatres in LA on Saturday October 13. *Soldier Songs* brings together opera, theater, rock, and film in an examination of the impact of war to the individuals fighting it. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219151632/sqdavidtlittlecolor.jpg.jpg"
primary_image_credit = "David T. Little, composer of Soldier Songs."
publishDate = "2018-10-10T20:55:00-04:00"
related_articles = ["articles/talking-with-composers-omar-daniel.md","articles/talking-with-composers-alexina-louie.md","articles/talking-with-composers-andrew-staniland.md","articles/san-diego-opera-takes-a-detour-with-all-is-calm.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
short_description = "&quot;As the composer, I try to see both the forest and the trees - to feel the small details and the small moments while making sure the text is right, the high notes are being approached in just the right way, and I&#039;m also monitoring the large-scale form while keeping the pacing moving. It&#039;s multi-tasking at an intense level.&quot;"
slug = "talking-with-composers-david-t-little"
title = "Talking with composers: David T. Little"
+++

### What can you tell us about the process of writing an opera that the average person might find surprising?

**DTL**: I wonder if people know how long it takes to write an opera. It starts before you write the music. It starts with the libretto, but before that, there's the treatment, getting the rights if you're adapting something, or as for *Soldier Songs*, the interviews I conducted. Then there is the composing process, which can take a couple of years depending on the piece. It's like writing a novel. 

As the composer, I try to see both the forest and the trees - to feel the small details and the small moments while making sure the text is right, the high notes are being approached in just the right way, and I'm also monitoring the large-scale form while keeping the pacing moving. It's multi-tasking at an intense level.

### Do you shut yourself away while you're composing? 

**DTL**: When I can go into hiding I like to become really absorbed in the process. When you have other responsibilities, that is harder to do. I teach composition at the Mannes School of Music in New York. You also have to clean your house, take out the garbage, and do all those things. When I can, I try to go to artist colonies. I find that great because I can think about nothing else.

Finding balance with a normal life, supporting your colleagues, and not falling behind on email plus getting the piece done is an ongoing challenge. The big challenge is to transition out of being a student to being a full-time composer. Even though I teach, I consider myself a full-time composer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219301113/soldier-songs_hf14sd16_credit_ada-nieuwendijk.jpg.jpg)
<figcaption>A scene from *Soldier Songs*. Photo by Ada Nieuwendijk.</figcaption>
</figure>

#### I saw *Soldier Songs* in San Diego a couple of years ago, and it left me with the feeling that there was a strong pacifist message in it. Is *Soldier Songs* a pacifist opera or was that just my interpretation?

**DTL**: I don't actually think of the piece as pacifist. The piece accepts as a premise that war exists, and that war is, for better or worse, the fabric of civilization. Beyond that, it tries to examine what is the cost of that for the individuals who are actively fighting and those who are close to them. That was really what I was exploring when I was writing the piece and I hope the piece communicates that. 

That you felt it was a pacifist piece is interesting because it definitely shows some hard things. What is being presented is so challenging. But I wasn't trying to prove a point or deliver a specific message in this piece. I was trying to explore the challenges of the soldier and present that to the audience, for them to take and contemplate after the show as they go back to normal life. I think everyone is going to have their own experience with the piece. That's a challenge with any work of art but especially when it's dealing with such a difficult subject matter or with a subject matter that intersects with politics in some way.

### You wrote a piece where you said that for you, "art comes first" when compared to the political message. But what inspires you to create and compose a piece - is it the art or the message? 

**DTL**: It's an interesting question because if you remove politics from that equation and you replace politics with ideas, you have an idea of a piece or a meaning of a piece, and then the art-making itself. I don't think those feel as separate or as oppositional as art and politics tend to feel. 

Every piece that I write is exploring some idea and it usually is an idea that is larger than the notes on the page themselves. As a composer, I don't write music that is about one interval turning into another interval although I may use that as a technique or device to explore or express something dramatically, or to express an idea. I have colleagues who are fantastic composers who are interested in focusing very closely on the mechanics of music. I focus on that closely as well when I'm composing, but I'm doing so in order to explore something larger, something philosophical, something spiritual, or something existential. Within that, there is also something political and that same relationship applies. The art, or the piece, needs to be good. 

There's an old quote by the composer and musicologist Charles Seeger from the 1930s, and I'm paraphrasing crudely, that it's not about whether the art is good but what art is good for. There was the question at that time about what music was good for. My doctoral dissertation is on music and politics. I came out of it thinking that it does matter to me that the art is good.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539219290972/soldier-songs_hf14sd2_credit_ada-nieuwendijk.jpg.jpg)
<figcaption>A scene from *Soldier Songs*. Photo by Ada Nieuwendijk.</figcaption>
</figure>

#### You have a PhD from Princeton on the intersection of music and politics. Can you explain where this intersection is and what it means? 

**DTL**: My dissertation was looking at various approaches both in theory and in practice to music and politics from 1917 through the present (2011). I looked at a lot of different composers and ideologies, both theoretical and political, and tried to find, in retrospect, my own path. What I landed upon, I believe, is the most effective way of art to be political, if you want the art to remain art and not tilt over into propaganda. You always have to be careful of the art/propaganda balance. It's a danger. I landed on what I call the politics of bearing witness. 

*Soldier Songs* does that. This is a story that is important to tell, I'm going to tell it and it has political ramifications, but the way it is told is not the way it would be told in the context of propaganda. I studied with William Bolcom when I was at the University of Michigan. We had a fascinating discussion where he said he didn't need a piece of music to tell him that war is bad. If you wrote a piece of music that just said that war is bad, that would not be very interesting, and it would be an example of a propaganda model of art-making. Whereas a piece like *Soldier Songs* tries to get into the experience and to examine it. It mines it in such a way that it becomes about something bigger than a simple message about war being bad.

I have another piece called *Haunt of Last Nightfall*, a 30-minute piece for percussion quartet and electronics. It is another example of the politics of bearing witness. It explores and examines the massacre at El Mozote in El Salvador in the 1980's. It has large scale geopolitical ramifications once you know about it, but it's something I didn't know about. I encountered it unexpectedly and I found that more people needed to know about it. I wrote the piece to bear witness to that tragedy. That's the way I have found makes the most sense for me. Historically, I think it is consistent with what's been most effective from other composers in the last one hundred years 

### I believe you started out as a metal/punk drummer. How did you get to opera and classical music from there? 

It's all true. I was a drummer and I played in a lot of rock bands and was very into heavy metal and industrial music. The flipside was that I also really loved musicals. While heavy metal and punk was the music I gravitated toward, I was also in every musical I could be in while I was in high school and was very involved in theater and jazz band. My school, North Warren Regional High School in Blairstown, New Jersey, had a really great music and theater program. I was very fortunate. I spent a lot of time on stage performing, singing, and dancing, in classical musicals like *Oklahoma*, *Guys and Dolls*, and *The Sound of Music*. 

Theater was also very important to me. The punk/metal aspect was one side, and theater the other side. When I was 15, I went to see *The Nightmare Before Christmas*, the Tim Burton movie with the score by Danny Elfman. That film had musical theater qualities, but it was also dark and strange. I realized that it had been Danny Elfman's job to write that music and that's what I wanted to do, I wanted to be a composer. 

Fast forward about ten years, I won a competition from the Pittsburgh New Music Ensemble, a group that embraced theatrical staging to their concerts. They had a lighting designer and costumes - they were in a music theater world.  I went to the conductor, Kevin Noe, and said I would love to write a whole concert rather than the 20-minute piece the prize usually was. He said yes. Suddenly I had a commission to write a one-hour long song cycle. That was *Soldier Songs*. It was an opportunity. *Soldier Songs* exists because somebody gave me an opportunity, at age 24, to do something big and take a risk. He didn't have to do that. I owe Kevin a lot for trusting this kid who had never written anything as long to go for it.

I wrote that piece and it was premiered in 2006. Around that same time, I met the producer Beth Morrison. I sent her the recording of *Soldier Songs* after we met about another project. She listened to it and immediately called me back and said we have to put this piece on. That was the beginning of my relationship with Beth, which is now going on 12 or 13 years. That's the production that is coming to Los Angeles. 

It was through Beth that I realized that *Soldier Songs* was an opera. I hadn't thought of it that way. I had thought it as a staged song cycle, music theater piece. I didn't really know opera. She put together a great team. Yuval Sharon directed the original production, he went on to direct at Bayreuth. It got me hooked on opera. Now I'm about to start number six. I have all sorts of different kinds of pieces on all sorts of scales, all living in the operatic world.

### I've only read really glowing reviews of your work. Does it happen though that you get a bad reception to your work by opera or classical music purists? 

**DTL**:  I'm sure there are some. I try not to read reviews. You just have to follow your path. Some people are going to respond to it and some are not. At a recent production of *Soldier Songs*, we had a talkback and there was a gentleman who really didn't like it and raised interesting questions, putting the piece in the context of *La Traviata* and the memorability of those tunes. We know the tunes from *La Traviata* because they're so great. But do we know them because they're great - and they are great, I'm not disputing that - or because we know *Traviata*? Or do we know them because of the way Verdi chose to structure the piece and uses the tunes a lot and we learn them. Is that the only way to do it? 

I encouraged this person to check out the recording of *Soldier Songs* and spend some time with it and listen to it. I think familiarity is something that we often overlook in our responses to new work. We say we like new work less than we like work that we know but the reason is because we know the work we know, and we don't know the new work yet. I try to encourage people to spend some time with these pieces. There is so much great work being produced by the composers who are writing opera now. We're not just putting whatever on the page. We're all really serious about creating the best work we can make. I think there are so many details you can get if you spend the time. 

When there's a new piece, I try to see it twice. The first time I may not understand things but the second time it comes to life. It's hard to do because tickets are expensive but there's so much that we can get from new work if we give it just a little bit of time. It would be immensely satisfying and meaningful, maybe not to everyone, but it could make a big difference to most people. If there's a recording, try to listen to it before you go, or listen to the recording afterwards. We're lucky right now because you can find so much out there on the Internet if you know how to look. Sometimes there's the assumption that if a work is new, it's not recorded. *Soldier Songs* and *Dog Days* are both recorded and available out there. Things are often more available than we tend to imagine.
 
### This is slightly different than the production I saw in San Diego I believe.

**DTL**: It is a different production but there is some overlap. The singer, David Adam Moore, who is singing it this weekend in Los Angeles, was one of the designers in San Diego. His production company GLMMR with Vita Tzykun established their production and now David is singing in this LA production. He was the second singer to ever sing it. He didn't premier it in Pittsburgh but he was the one who did it next in 2008. He's been with the piece now for a decade and he sounds better and better every year. He sounds very good and really embodies the role beautifully.

>*Soldier Songs* plays for one night only on October 13. For details and tickets, [click here.](https://www.laopera.org/season/1819-season-la-opera-season/soldier-songs/)
