+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-09T17:06:00-06:00"
lastmod = "2017-06-10T12:51:00-06:00"
preamble = "Toronto-based composer [Chris Thornborrow](/scene/people/chris-thornborrow/) is an inspired collaborator, and his work is balanced across the city's diverse musical scene. His operatic work has been heard at [Tapestry Opera](/scene/companies/tapestry-opera/), [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/), and [FAWN Chamber Creative](/scene/companies/fawn-chamber-creative/), and he is a founding member of the emerging composers' collective, [Toy Piano Composers](/scene/companies/toy-piano-composers/).\n\nHe spoke with us about his work with young people, working independently of inspiration, and his long-standing earworm."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497049542807/2017-06-09---Chris-Thornborrow.jpg.jpg"
publishDate = "2017-06-10T10:11:00-06:00"
related_articles = ["articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-ivan-barbotin.md","articles/talking-with-composers-cecilia-livingston.md"]
related_companies = ["scene/companies/the-bicycle-opera-project.md","scene/companies/tapestry-opera.md","scene/companies/canadian-opera-company.md","scene/companies/fawn-chamber-creative.md"]
related_people = ["scene/people/chris-thornborrow.md"]
short_description = "&quot;My instrumental music has been described as complex, clear, powerfully virtuosic, and playful. The operas I&#039;ve written have ranged from side-splittingly funny to chilling, although one critic felt &#039;it did not work.&#039; Some of the work I&#039;ve done in film has been called elegiac, rumbly, and brashly percussive.&quot;"
slug = "talking-with-composers-chris-thornborrow"
title = "Talking with composers: Chris Thornborrow"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

I am interested in a broad range of styles. I tend to infuse my work with a wry sense of humour, and interlocking rhythmic motives. There's almost always a subtle playfulness to my work. I also love "stretching" things — how big can this section go?; how soft?; how much can this motive be pulled apart or squished together before it sounds like something else?; etc.  In my operatic work, I'm interested in fusing operatic structures and tradition with the pacing and sensibilities of musical theatre. When I work in film, I become much more of a chameleon, striving to create a score that best inhabits the world and serves the story.

My instrumental music has been described as complex, clear, powerfully virtuosic, and playful. The operas I've written have ranged from side-splittingly funny to chilling, although one critic felt "it did not work." Some of the work I've done in film has been called elegiac, rumbly, and brashly percussive.

## How do you write music when you’re not feeling particularly inspired (yet)?

A consistent lesson I learned from every one of my composition teachers was that inspiration doesn't just come to you; you have to work at your craft, and sometimes — thankfully not always — it can feel like squeezing water from a stone. I change my strategy on this perennial problem. Right now, most of my composing has been opera. If I'm stuck on something, I try to keep it in the back of my mind, and will step away from my piano. I'll sing melodies while doing something else — cooking, cleaning, biking — and sooner or later something clicks. I think the toughest part is when you first encounter a new idea that isn't fully formed, is resisting scrapping it outright, but instead convincing yourself that this thing is worthy of being further developed.

## How do you think the perception of being a working composer compares to the reality of the job?

A question I often encounter is, "so you're a composer, but what do you do?" What's being insinuated in this question, I think, is that I can't possibly be making a living composing. 

But what I've discovered over the last couple years, which I think is far more interesting, is just how deeply collaborative composing can be. This is in contrast to what I would have thought ten years ago. Writing music is a solitary activity, and being somewhat of an extrovert, I find this a particularly challenging aspect of the job. The most fulfilling projects of my career have been works that involve community. For example, being involved with the new music community of Toronto as the co-founder and AD of the Toy Piano Composers has cultivated an amazing network of supportive composers and musicians. 

I also love composing in collaboration with artists of other disciplines — writers, directors, dramaturges. And over the last two years I've been co-composing operas with kids from across Toronto through the Canadian Opera Company's After School Opera Program and summer camps. We've created ten new operas to date, and their creative energy has been totally inspirational. I'm really looking forward to returning to the COC summer camps this July.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

No, but I've had George Michael's "Careless Whisper" stuck in my head for 8 years, more or less. It all started in 2009, when I was working at an international summer camp in Switzerland. There was a group of us who thought it might be funny to make this song the unofficial camp song because it's just so inappropriate it is to the whole camp vibe. So we would sing it and play it on the speakers in the wreck room. We thought it was hilarious, and so did the campers. However, it all backfired on me; a summertime of hearing that song on repeat has embedded the mercilessly catchy saxophone solo into my long term memory for all eternity most likely. Not a week goes by where I don't catch myself humming that damn tune. If anyone out there knows how to scrub a permanent ear worm without any major damaging side effects, get at me. 

## Out of your body of work, what are you most proud of, to date?

I'm really happy with my piece *Walking*. It's a chamber work inspired by [Ryan Larkin's short film of the same name](https://www.nfb.ca/film/walking/). It's not my largest work by any means, but I feel really connected to it for some reason. Selfish plug: It's actually just recently been released on the debut album of the Toy Piano Composers, which features new works by seven composers of the collective written for the TPC Ensemble. The CD is available through [Redshift Music](https://redshiftmusicsociety.bandcamp.com/album/toy-piano-composers) or our [website](http://www.toypianocomposers.com/Toy_Piano_Composers/Home.html).
