+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-02T22:22:00-06:00"
lastmod = "2017-07-04T22:40:00-06:00"
preamble = "London-based Canadian composer [Cecilia Livingston](/scene/people/cecilia-livingston/)'s music is evocative on first hearing, layered with musical influences to explore. Her operatic work has been heard through [Tapestry Opera](/scene/companies/tapestry-opera/), [Opera 5](/scene/companies/opera-5/), [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/), and American Opera Projects; next season she'll present a new full-length opera with [Opera 5](/scene/companies/opera-5/) and TorQ Percussion Quartet.\n\nLivingston has a way with words as she does with music; it was fascinating to chat with her about writer's block, musical snobbery, and her admiration for singers."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499056324051/2017-07-02---Cecilia-Livingston.jpg.jpg"
publishDate = "2017-07-04T22:16:00-06:00"
related_articles = ["articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-chris-thornborrow.md","articles/talking-with-composers-alexina-louie.md","articles/talking-with-composers-kieren-macmillan.md","articles/talking-with-composers-brian-harman.md"]
related_companies = ["scene/companies/opera-5.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/cecilia-livingston.md"]
short_description = "&quot;When people reach for a musical comparison they usually say I remind them of Britten, which is a huge compliment – and what a comparison to live up to! And it makes sense of the darkness that&#039;s in a lot of what I write. (I really enjoy writing music that is witty and satirical; I just keep getting asked for those darker emotional journeys.)&quot;"
slug = "talking-with-composers-cecilia-livingston"
title = "Talking with composers: Cecilia Livingston"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

Someone told me that my music is both lush and spare; I love that paradox and I think it's pretty apt. I like things that estrange the familiar or expected, that are unsettling, and I like "blurring" tonality, and Doppler effects, and pitch bending... I believe in a well-stocked toolbox: a range of style and technique that can respond to the challenges of a particular piece, and I love tapping into the jazz standards I love, the pop harmonies I relish.

When people reach for a musical comparison they usually say I remind them of Britten, which is a huge compliment – and what a comparison to live up to! And it makes sense of the darkness that's in a lot of what I write. (I really enjoy writing music that is witty and satirical; I just keep getting asked for those darker emotional journeys.) I love working with text, discovering the room for music in its rhythms and its wealth of meaning. The intimacy of the human voice is incredibly powerful, which is why I write so much vocal music and opera. Plus, singers are generally extremely cool people.

## How do you write music when you're not feeling particularly inspired (yet)?

By force! I remember Steven Stucky saying to some of us at a composers residency: "Composing is work and problem solving... Inspiration is for amateurs. Professionals have technique." So in short, I'm not sure I believe in "inspiration" as it's often understood, as the thing that starts a work. But I sure as heck believe in craft: inspiration strikes when you recognize the potential of what you just wrote.

I usually start with improvising, but after that it's a question of logging the hours at the desk. My teacher, Christos Hatzis, always told me that if you’re not sure where the music goes next, listen to what you've already written until it shows itself to you. I'm really big on structure in music, on structure that listeners can hear and follow: this certainly helps me in opera, where musical structure and dramatic structure interact in complex and subtle ways.

Thankfully, I've only had one truly spectacular case of writer's block; discovering that I can deliver under pressure was my professional turning point. I've had four years of continual projects with back-to-back deadlines, so I've had to get used to writing with confidence and purpose, and that’s done best with "you have x hours today to accomplish y, so do it." Then I lock myself up somewhere until it's done.

## How do you think the perception of being a working composer compares to the reality of the job?

The "Romantic Genius" myth is really insidious, and destructive to understandings of what artists really do and to the cultural value of art. Sadly, I think only other composers and their families/partners/roommates really see the insane dedication this particular vocation demands: it can be incredibly lonely, and emotionally difficult. But working with musicians and audiences, being part of this amazing "conversation" through music with other humans: that makes the eye-gouging focus a joy.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

I'm a musical omnivore, and living in the heart of London has certainly fed into that!

Honestly, I'm genuinely puzzled when composers are music snobs. If it's well-crafted music I relish it and learn from it, no matter what style/genre/period it might be.

I have huge respect for musicians in the opera/classical worlds and in the pop world, who get up and put on a show – like Katy Perry, and Bruce Springsteen, and The Rolling Stones. Any entertainer who tours a lot and does it seriously? That is an arduous, punishing life, and it takes real commitment. To get up there, night after night, no matter what? Kudos to them. Doesn't matter what genre or style they work in: I'm impressed.

## Out of your body of work, what are you most proud of, to date?

I just finished a set of folk songs/art songs for The Canadian Art Song Project, which I can't wait to share, and I'm seriously excited for the project I'm developing with TorQ Percussion and Opera 5. It'll be my first full-evening opera and it's a dream project on every front: awesome partnerships; stunning soundworld possibilities; utterly harrowing story from Canadian history. Thank you to the Ontario Arts Council and the Toronto Arts Council for funding this project: I can't wait to start!

But of work I’ve already done, two pieces stand out: [*Two Dreams*](https://soundcloud.com/cecilia_livingston/two-dreams-2013-for-soprano), and [*Kalypso*](https://soundcloud.com/cecilia_livingston/kalypso).

*Kalypso*'s a torch song/art song for coloratura soprano, which I wrote during my fellowship at American Opera Projects in Brooklyn. It's about the *Odyssey*, but it's also my own love letter to Harold Arlen's *Stormy Weather*. I adore his music; and why shouldn't coloratura and scat singing intersect?

*Two Dreams*, for soprano and string quartet, brings back pivotal moments: I wrote it for soprano [Ally Smither](/scene/people/alexandra-smither/), when we were both students. I'd written about two minutes of it and I could hear where it wanted to go, but I was worried it would be lame to "indulge" that. But I did it anyhow – I trusted my intuition. And then I remember leaving the first rehearsal with Ally, and we just started jumping up and down and cheering in the hallway because the piece sounded so great.

It's performed pretty regularly and the audience response is incredible: so many people have taken time to tell me what it means to them. That was the piece when I really saw that I write for other people, not myself: when I realized I was in this composing thing for life.
