+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-07T16:54:00-04:00"
lastmod = "2017-07-11T12:10:00-04:00"
preamble = "[Brian Harman](/scene/people/brian-harman/)'s music first caught our ear when the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/) presented his cycle, *Sewing the Earthworm* as part of their 2015 concert entitled [*The Living Spectacle*](/aptly-named-the-living-spectacle/). Harman collaborates often with artists of other media, and his work lends itself easily to other disciplines like dance, architecture and visual art.\n\nHarman talks about his current approach to composing music, the inevitable administrative work that comes with the job, and his varied musical aesthetics for driving, running, and singing karaoke.\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499549478735/2017-07-08---Brian-Harman.jpg.jpg"
primary_image_credit = "Photo by Tor Sandberg."
publishDate = "2017-07-11T12:10:00-04:00"
related_articles = ["articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-alexina-louie.md","articles/talking-with-composers-cecilia-livingston.md"]
related_people = ["scene/people/brian-harman.md"]
short_description = "&quot;To get some ideas flowing, I need time and space to think and explore. I have a notebook of ideas that I return to, which can help, but the idea needs to feel fresh and relevant to my current work and life. Even if it&#039;s challenging, this creative exploration is a really enjoyable part of composing for me.&quot;"
slug = "talking-with-composers-brian-harman"
title = "Talking with composers: Brian Harman"
+++

## What are your priorities when you begin writing something new? 

The most important thing for me lately is that the process of composing a piece is an enjoyable one. I've been trying some new approaches to process lately (open scores, improvising, manipulating existing music, theatrical approaches, using field recordings, etc.), and it's helping to ensure things stay fresh and that I'm fully engaged. The day-to-day of working on a project has to be interesting.

Along the same lines, it's important to me that I push myself. I don't try to reinvent the wheel with each piece, but it's important that I'm looking at things slightly differently in each project. I don't like creation to be too comfortable.

Finally, I think a lot about the sense of time that I want the music to have. Musically, this has a lot to do with space, the use of silence and the progression of materials. Once established, this temporal element creates a kind of planet that the piece inhabits, and has ramifications on so many other decisions.

## How do you write music when you're not feeling particularly inspired (yet)?

This can be difficult. If I listen to a bunch of much music in order to inspire myself my head becomes a swamp of messy possibilities -- not very helpful. If I just start writing without an idea I'm interested in, the music that comes out is directionless. If I just *wait* for inspiration to strike while I live my life, I can wait a really long time.

To get some ideas flowing, I need time and space to think and explore. I have a notebook of ideas that I return to, which can help, but the idea needs to feel fresh and relevant to my current work and life. Even if it's challenging, this creative exploration is a really enjoyable part of composing for me.

## How do you think the perception of being a working composer compares to the reality of the job?

I'm not sure what the perception of being a composer is, but a composer who wants to be paid for their work certainly has a great deal of grant writing, marketing and administration to do. It requires a ton of perseverance in the face of rejection letters and red tape, and many skills beyond musical ones.

As for composing itself, the field has diversified so much that it's hard to generalize about what a typical artistic process involves. People talk about composing like it's some sort of super power or magical talent. I don't blame them -- it's kind of hard to explain how I compose music. Plus my approach can totally change from piece to piece. There's a lot of un-magical, un-inspired, blood, sweat and anxiety sitting down, getting to work and figuring things out, and a composer has got to enjoy that part of it. But there are also beautiful moments of discovery and collaboration, of course.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

I think it's actually dangerous for a composer to feel guilty about what they like to listen to. It's like denying a part of your personality. My favourites for driving include Phil Collins, Japandroids and RuPaul. For running I listen to everything from Whitney Houston dance remixes to Regina Spektor to M.I.A. For karaoke I usually go with Salt-N-Pepa or Shania Twain.

## Out of your body of work, what are you most proud of, to date? 

The works I'm most proud of are projects where I grew as a composer... where I really had to dig deep and push myself. 

*Sewing the Earthworm* is a song cycle/mini opera for soprano and piano that portrays a woman slowly losing control of her fine motor skills. When composing the work, I had to stretch my musical language to be able to do justice to David Brock's vivid poetry. Finding the right tone and emotional depth took time and patience. The Canadian Art Song Project [presented the piece again in 2015](/aptly-named-the-living-spectacle/) with a choreographed dance by Jennifer Nichols that added a whole new inspiring dimension.

In *Skolia*, I found ways of incorporating theatrical elements and humour into my work. The piece is for soprano and violin, and involves acting, musical games and some improvisation. I'm proud of the intimacy and emotional range I was able to achieve, and the deeply collaborative nature of the piece. I wrote *Skolia* for a composer community project in Norway, England and Canada called nu:nord.

The last piece I'll mention is *Sanctuary*. (I promise not all my works begin with S…) I wrote this instrumental septet for the 5-Penny New Music Ensemble in Sudbury. I developed a personal system of microtonality in this piece, and I'm really proud of the ethereal sound world I created.
