+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-08T13:43:00-04:00"
lastmod = "2017-07-13T13:39:00-04:00"
preamble = "Canadian composer [Andrew Staniland](/scene/people/andrew-staniland/) is currently a faculty member at Memorial University in St. John's, NL; there, he founded MEARL (Memorial ElectroAcoustic Research Lab), where his research team developed the - very cool - [Mune](http://munemusic.com/) digital instrument. Staniland's oratorio, *Dark Star Requiem*, earned him two Juno Award nominations in 2017; it was the \"Beautymark Aria\" from *Dark Star Requiem* that first caught our attention, at [Tapestry Opera's *Songbook VI*](/he-saidshe-said-songbook-vi/) in early 2016.\n\nIn our latest composer profile, Staniland chats about his past life as a heavy metal guitarist, and the ill-fitting stereotype of a \"tortured artist\".\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499536350029/2017-07-08---Andrew-Staniland.jpg.jpg"
primary_image_credit = "Photo by Bo Huang."
publishDate = "2017-07-13T12:40:00-04:00"
related_articles = ["articles/talking-with-composers-david-t-little.md"]
related_companies = ["scene/companies/tapestry-opera.md"]
related_people = ["scene/people/andrew-staniland.md"]
short_description = "&quot;There is nothing like the feeling of music that appears to write itself. It is a total rush – like the whole earth is vibrating just right to make the sounds, totally in the moment. However, in my experience, these moments are made possible only by nurturing a deep discipline.&quot;"
slug = "talking-with-composers-andrew-staniland"
title = "Talking with composers: Andrew Staniland"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

I am interested in writing music that is beautiful, moving, powerful and of our time. For me, music is seamlessly connected to a place of great creativity, inspiration and emotional power that is shared by all kinds of different disciplines in art, science, and beyond. I am often inspired by the natural world and science, and I love exploring musical analogies to natural phenomenon. For example, if Phi had a sound what would it be? This was the specific inspiration for my recent ballet *PHI* for the National Arts Centre Orchestra with the Alberta Ballet.

As far as musical technique is concerned, I am very interested in creating long lines with absolute focus on clear musical ideas. For me, composition is the weaving of basic musical elements together: tension and release, loud and soft, surprise and expectation, colour and texture. Writing music is one of the most satisfying things I have experienced. I believe that the more I feel the musical fire within myself as I write, the more others will feel it when performing and listening to it. And that is the whole point – to chase the musical fire!

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/qYTwdsKN1AE" frameborder="0" allowfullscreen></iframe>
</figure>

I think my favorite description of my music by another was by Joseph So, who wrote this in reviewing my oratorio *Dark Star Requiem* for *La Scena Musicale*: "Striking, beautiful, and wonderfully weird...The score is percussive, dissonant yet lyrical and evocative...very powerful and haunting.

My music has been reviewed quite a bit. Here is a word mosaic I made just for Schmopera featuring are some of my favorite descriptions in the press:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499536113953/Screen%20Shot%202017-07-08%20at%2011.46.08%20AM.png)
</figure>

## How do you write music when you're not feeling particularly inspired (yet)?

I have a curious nature and am open to a wide variety of experiences and people, and in this way I am exposed to a broad range of ideas and am often captivated by new ideas and passions. My own experience is that inspiration can found everywhere - it is like the air we breathe.

That said, of course there times when there is writing to be done and I am not particularly inspired . This is where daily ritual comes in. There is nothing more important than maintaining regular writing habits and I sit down to write regularly – whether I make progress or not. This discipline takes the angst and uncertainty out of the process, and it just becomes the next day, the next piece, the next note. And, for me, it is within this discipline that true inspired work is able to grow.

There is nothing like the feeling of music that appears to write itself. It is a total rush – like the whole earth is vibrating just right to make the sounds, totally in the moment. However, in my experience, these moments are made possible only by nurturing a deep discipline.

## How do you think the perception of being a working composer compares to the reality of the job?

Perhaps people would be surprised to know how solitary the work is. There is a social side to composing: rehearsals, concerts, preconcert chats, interviews and so on. However one composes alone, which can be isolating.

A stereotype that is overblown is that of the tortured artist, perpetuating the myth that great creativity demands great pain in reciprocity. Perhaps some people come by this honestly, but for me a life in composition is basically a joyful one, and a privilege at that. There is no doubt that maintaining a career in the arts comes with significant challenges, but those challenges are not necessarily greater than those faced by people who are on other paths. Everyone has baggage, anxiety, and other darkness within them and being an artist does not make that more real or more valuable. While life experiences and world realities do inform and influence my composition, they do not change the fact that being a composer is a joy and a gift.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

Some people are surprised to learn that I have a background in heavy metal as a guitarist. I still listen to plenty of it, and I still love it just as much as I ever did.

## Out of your body of work, what are you most proud of, to date?

If I had to pick one piece – it would be *Dark Star Requiem*, which is among my most ambitious and successful accomplishments. It is an eighty-minute operatic oratorio for four singers, piano trio, percussion and chorus. The poems, written by poet Jill Battson, deal extensively with HIV AIDS in a variety of contexts, from personal to cultural to scientific. The original production in 2010 was on opening night of the Luminato International Art Festival in Toronto. The set was designed by Beth Kates and Ben Chaisson, directed by Tom Diamond and conducted by Wayne Strongman.

*Dark Star Requiem* was nominated for two JUNO Awards in 2017, and available on [Spotify](https://www.google.ca/url?sa=t&amp;rct=j&amp;q=&amp;esrc=s&amp;source=web&amp;cd=1&amp;ved=0ahUKEwjih4PsoffUAhVCWz4KHfS5DqMQFggoMAA&amp;url=https%3A%2F%2Fopen.spotify.com%2Falbum%2F3S9TJNUTG6lWQ5Bldqgt7p&amp;usg=AFQjCNE-KseairG-QHkau5PICfQSqm63WQ), [iTunes](https://www.google.ca/url?sa=t&amp;rct=j&amp;q=&amp;esrc=s&amp;source=web&amp;cd=1&amp;cad=rja&amp;uact=8&amp;ved=0ahUKEwjZxq77offUAhUDHT4KHUmGA14QFggkMAA&amp;url=https%3A%2F%2Fitunes.apple.com%2Fca%2Falbum%2Fstaniland-dark-star-requiem%2Fid1106108168&amp;usg=AFQjCNHecl9rG87r_Pc6q5ysMFOMLOFBrA), and [Centrediscs](https://www.musiccentre.ca/node/138842)

That said - I am always most invigourated by the piece that I am currently working on - being fully present with it as I create it. I don't feel that the "double bar line" moments, in music or in life, are the point at all. The whole point is to enjoy it while it is happening, and this is the very best thing to celebrate!
