+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-21T22:04:00-06:00"
lastmod = "2017-06-25T22:40:00-06:00"
preamble = "[Alexina Louie](/scene/people/alexina-louie/)'s music is a staple among Canadian soloists and ensembles. She writes for piano, voice, chamber groups, large orchestras, choirs, and ballet; her opera *The Scarlet Princess* (1996-2002) was commissioned by the Canadian Opera Company, and she has composed made-for-TV mini operas (*Burnt Toast*, *Toothpaste*) along with librettist Dan Redican and director Larry Weinstein.\n\nWe were thrilled to have the chance to ask Louie about that elusive concept of \"inspiration\", about the works in which she takes great pride, and her unexpected love for Motown."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498104004579/2017-06-22---Alexina-Louie.jpg.jpg"
publishDate = "2017-06-25T22:05:00-06:00"
related_articles = ["articles/talking-with-composers-aaron-gervais.md","articles/talking-with-composers-omar-daniel.md","articles/talking-with-composers-juliana-hall.md","articles/talking-with-composers-cecilia-livingston.md","articles/talking-with-composers-kieren-macmillan.md","articles/talking-with-composers-brian-harman.md","articles/talking-with-composers-mark-adamo.md","articles/talking-with-composers-david-t-little.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/alexina-louie.md"]
short_description = "&quot;Inspiration doesn&#039;t just suddenly strike. Most often, I sit at the piano and improvise until I find a musical idea that is worth keeping. I will sketch it out and work with it. Sometimes when I am stuck on a passage unable to come up with a musical solution, I think about it when I am not at the piano. Sometimes I work out possibilities in my head and get back to the piano to realize them. I have pages and pages of drafts, most of which I don&#039;t use, but working out the ideas gets me to a new place.&quot;"
slug = "talking-with-composers-alexina-louie"
title = "Talking with composers: Alexina Louie"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

In each piece that I write, I try to get to the heart of the work. That search is often a mysterious journey for me. My music is the result of a desire to communicate something that is deeply felt. It doesn’t matter if the work is a pedagogical piano piece, one of my humourous five minute made-for TV operas (*Toothpaste*, the *Burnt Toast* operas) or a symphonic work, I consider each piece special. I think a lot about the musician for whom the work is written and tailor the work to his/her talents.

When I completed my graduate composition studies in California, I really didn't know if I wanted to be a composer. I stopped writing music for about six years. During this time I worked at finding my musical voice. Gradually this search led me to expressing myself through a language that was the amalgamation of Asian and Western musical sensibilities.

People are often surprised at the emotions that my music evokes in them. They frequently tell me that my music touches them deeply. John Rea, one of my composer friends, once told me that he hears sighing in my music.

## How do you write music when you’re not feeling particularly inspired (yet)?

Inspiration doesn't just suddenly strike. Most often, I sit at the piano and improvise until I find a musical idea that is worth keeping. I will sketch it out and work with it. Sometimes when I am stuck on a passage unable to come up with a musical solution, I think about it when I am not at the piano. Sometimes I work out possibilities in my head and get back to the piano to realize them. I have pages and pages of drafts, most of which I don't use, but working out the ideas gets me to a new place. Many of these pages are close to illegible.

## How do you think the perception of being a working composer compares to the reality of the job?

I find that people who don't compose think that writing music is easy and fun. What could be more unlike hard work than composing music? 

## Do you have a song/album/artist that you'd consider a guilty pleasure?

"Be My Baby" by The Ronettes. "Will You Still Love Me Tomorrow" by The Shirelles. Pretty much most Motown!

## Out of your body of work, what are you most proud of, to date?

I put everything I know and feel into my opera, *The Scarlet Princess*, which is based on a traditional Japanese Kabuki play. At the outset I told my librettist, David Henry Hwang, that I wanted to go to the wall with this work. I wanted people to feel something for the characters - to feel what they were feeling. I wanted to write an opera that revealed the full scope of human emotion. It's dramatic, lyrical, passionate, erotic. It's about reincarnation, obsession, love, death and forgiveness.

*O Magnum Mysterium: In Memoriam Glenn Gould* for the unusual instrumentation of forty-four divisi (separate) strings. This is as close to being a piece ripped from my guts that I have ever written. It is the direct response to the news of Glenn Gould's death. The morning that it happened, after a rehearsal, I went to a practice room at the Royal Conservatory of Music and ruminated on what it takes to be an artist as I improvised and composed. It's a most unusual piece that shifts between outbursts of pain and the sublime, altered quotations of great music of the past. What remains after you've given so much of yourself in your life as an artist? Gould had died so young. By the time I finished this work, I came to realize that your music will exist long after you are gone. It was a cathartic piece for me.

*Take The Dog Sled* for two Inuit throat singers and ensemble. This was a tough one as I wanted to do honour to both Inuit and Western musical traditions. One is completely aural and the other is completely notated. How do you combine these two musical traditions and not have one subsume the other? I worried about this one because if it wasn't done right, it could be a horrible disaster. I really had no idea how to approach this. I spent the first two months not writing anything. I just listened to throat singing day and night. After those two months, the light went on. When the piece was performed in remote northern Quebec, the Inuit community loved it. I heard from several audience members that I had expressed their true experience of the north. That was so satisfying for me.
