+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-08-30T13:20:00-04:00"
lastmod = "2017-09-01T13:16:00-04:00"
preamble = "Award-winning composer and double-bassist [Adam Scime](/scene/people/adam-scime/) is based in Toronto, and his music has been commissioned and performed by the [Esprit Orchestra](/scene/companies/esprit-orchestra/), [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/), [Soundstreams](/scene/companies/soundstreams/), and the National Arts Centre Orchestra. Opera fans in Toronto may have heard his *l'homme et le ciel*, with [FAWN Chamber Creative](/scene/companies/fawn-chamber-creative/) (2014), or even his collaborative work on *Rob Ford, An Operatic Life* (2012).\n\nScime spoke with us about guiltless pleasures, the reality of inspiration, and how he evades writer's block.\n\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1504113675907/2017-08-30---ScimeHeadshot.jpg.jpg"
publishDate = "2017-08-31T11:27:00-04:00"
related_companies = ["scene/companies/fawn-chamber-creative.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/adam-scime.md"]
short_description = "&quot;I like to try something different with each piece I write. It&#039;s how I keep the process exciting and at the same time it becomes a learning experience. It also keeps me on edge - which I like - and for me this is actually a positive thing.&quot;"
slug = "talking-with-composers-adam-scime"
title = "Talking with composers: Adam Scime"
+++

## How would you describe your musical aesthetic? How have you heard it described by others?

I like to try something different with each piece I write. It's how I keep the process exciting and at the same time it becomes a learning experience. It also keeps me on edge - which I like - and for me this is actually a positive thing. What I mean by that is, if I'm trying something new or going to very unfamiliar aesthetic neighbourhoods, there's a good chance it might not work. Therefore, I have to really work at it and have a great deal of faith in my abilities. 

So as a result, my personal aesthetic is slightly hard to pin down with a few carefully chosen words as from piece to piece things can vary quite wildly. As a general consideration, my music tends to be dominated by dramatic gestures with a predilection for timbre and colour. These are usually the attributes that are often commented upon.

## How do you write music when you're not feeling particularly inspired?

I'm not sure I really suffer from so-called "writer's block" as I have several activities in place that serve to avoid such a state. The most important activity is listening to as much music in as many different genres as possible. This is something I do a lot in my spare time even when not writing, but when I am deep into the writing process the amount of listening I do increases quite a bit. It can be a meditative thing, but also a great brainstorming catalyst through which ideas (and/or solutions) can come quite freely and serendipitously. 

There is also the notion - this is something I very strongly believe - that when natural inspiration, the intangible gift from no-one-knows-where type of intuition, has gone for a temporary walkabout, I can rely on and turn to my technique. It is a crutch that will never go away and keep my writing process upright until the intuitive spark decides to come back. This is a two-way street: when the ideas flow with ease, technique doesn't seem to matter too much. And so, this interdependency allows me to keep working diligently when necessary and is a sort-of inner symbiosis that allows for a harmonious working environment.

## How do you think the perception of being a working composer compares to the reality of the job?

I think the largest misconception here is the amount of work that goes into a project. It is easy to picture a composer in montages of passion, wildly creating a work of art in a fury of starburst and fireworks. Maybe there are brief moments like this, but the reality is that there exists an enormous amount of work, frustration, and long periods of self-imposed solitary confinement that can easily take its toll on your mind, and your health. 

All that said, composing music is also the most enjoyable thing in my life. It allows me to work out personal problems, and acts as a conduit through which I can express myself in profound ways. I never take this for granted. It is the rewards of such efforts, the gift of collaboration, and contributing to your community that makes it all worth it.

## Do you have a song/album/artist that you'd consider a guilty pleasure?

I've thought a lot about this sort of thing. I've seen some music/taste-shaming on social media that really disgusts me, even if it comes hidden under the weak veil of critical discussion. As soon as one starts to believe that their personal tastes are superior because of x, y, or z, that person needs to reevaluate their own relationship with music. It is so important to me that we create inclusive environments for all types of music and music lovers. I embrace the fact that no matter what music you enjoy, that this is a beautiful thing, and one should never be ashamed or made to feel guilty of what inspires them through the listening experience.

...anyway, this is sort of an evasive answer... Maybe an unexpected (not guilty) pleasure is that I really love very loud electronic and/or rock music - in any genre - as a live experience. It's the visceral quality of the music that has an impact. It's amazing to feel this sound through your body, and is perhaps why I enjoy creating dramatic gestures in my own music.

## Out of your body of work, what are you most proud of, to date?

My opera *l'homme et le ciel* is something I'm very proud of not only because I'm very happy with the music, but also because of the incredible impact the collaborative aspects had on all involved. Opera consists of so many voices artistically, from makeup to set design, costume to movement, and dramaturgy to musical elements. The collaborative aspects, and the amazing artists offering their unique voices, are totally inspiring to me. When I was given the incredible gift to engage in such a collaboration with my own music through [FAWN Chamber Creative](/scene/companies/fawn-chamber-creative/), it became one of the most rewarding artistic experiences to date for me.
