+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-14T22:36:00-04:00"
lastmod = "2018-03-15T21:47:00-04:00"
preamble = "Kathy Domoney recently celebrated her 10th anniversary as director of Domoney Artists Management, moving from a busy career as a soprano to her role as an agent and artist manager. Domoney's clients take the stages across Canada and internationally, and she represents an important step in the professional lives of young, emerging opera singers.\n\nWe spoke with Domoney about the reponsibility of an artist manager, the changes she has seen over 30 years in the opera industry, and what she looks for in a client."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521164858014/sq---kathy-domoney-pic1.jpg.jpg"
publishDate = "2018-03-15T21:35:00-04:00"
short_description = "&quot;Singers think I can wave a magic wand and fill their calendar with engagements - if only that were the case! I make it very clear to potential clients that my job is to open doors through auditions, and the singer&#039;s job is to present themselves at auditions with confidence, wonderful singing and a strong emotional connection to their arias.&quot;"
slug = "talking-with-agents-kathy-domoney"
title = "Talking with agents: Kathy Domoney"
+++

### What do you think are some misconceptions about what an agent does, and what they have the power to do?

Singers think I can wave a magic wand and fill their calendar with engagements - if only that were the case! I make it very clear to potential clients that my job is to open doors through auditions, and the singer's job is to present themselves at auditions with confidence, wonderful singing and a strong emotional connection to their arias. 
I have the power to suggest and recommend singers for specific opera roles or concert repertoire, but the final decision remains with the artistic director or conductor. 

As for what an agent does: my job description covers a wide range of responsibilities. Chiefly, I am the administrative base for singers. While they learn music, and prepare for auditions and performances, I look after securing engagements, negotiating fees, handling contracts, writing bios and sending headshots to engagers, keeping track of each artist's schedule, responding to enquiries and helping artists find a solution to problems that may arise during an engagement. I work closely with singers, advising about repertoire and roles to learn and present in order to optimize their unique gifts and to maximize their marketability. 

I wear many hats, including career counsellor, travel agent, fashion advisor, vocal coach, social media assistant, editor, proofreader, publicist and concert promoter. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521081312814/DomoneySoulis.jpg.jpg)
<figcaption>Kathy Domoney (left) with mezzo-soprano Maria Soulis.</figcaption>
</figure>

##	What do you look for in a new client? 

There are several factors I look for when considering a new client:

<ul class="nospace">

<li>Voice: Beautiful timbre, excellent technique, strong languages and musicality in a wide range of repertoire.
<li>Stage presence/confidence: I want to see a love of performing, ease on stage, strong characterization and acting ability.
<li>Potential: Perhaps the voice needs to develop more, but there is a glimmer of how good the instrument could be, with the right balance of nurturing and guidance.
<li>Ambition and motivation: They need to have that inner voice urging them on to work hard, and really *want* this career.
<li>Emotional stability: A healthy mental attitude to deal with criticism, rejection, and ability to withstand the pressures of failure as well as success.
<li>Organizational skills! Staying on top of audition details, responding promptly to me (email/text) knowing where to be, what to sing, and being on time.
<li>Integrity and responsibility: Singers who will add glory - not grief - to the Domoney Artists reputation that I have earned over more than 25 years.
<li>Social ease: Online, in person, on breakfast interviews, at receptions...Good singing is only the beginning of building a successful career.  Today's classical singers are often thrust into a wide range of social environments, so being at ease at the post-show reception as well as auditions is a real asset.
<li>Good colleague: Anyone can be hired once by a company or orchestra, but to maintain a long, healthy career, singers need to be easy to work with, supportive of their colleagues, and low maintenance if they want to be asked back. Divas with demands are so yesteryear. 
<li>Collaborative and cooperative: I view my relationship with artists as partnerships, we are both striving for the same result - securing engagements to showcase their talent. This may lead to a shift in repertoire, wardrobe, and audition package. We need to work collaboratively, not dictate, "I will only sing Puccini!"  or, "I told you get that beard trimmed before the audition!" 
<li>Versatility: As companies shift and evolve to a changing audience dynamic, there is a far greater range of productions than ever. The busiest singers are those that can bring a skill set that includes classic opera, oratorio, music theatre, operetta and contemporary opera. English diction is *very* important as many new works are performed in smaller, intimate spaces. 
<li>Musicianship: Due to rising costs, there is less time than ever to rehearse. Singers who can learn their music quickly and accurately are prized, as are singers who can step into a role at the last minute with confidence. 
</ul>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521081331737/DomoneyMontreal.jpg.jpg)
<figcaption>Domoney with colleagues in Montréal.</figcaption>
</figure>

### What do you think are some common priorities when a company chooses to hire a singer?

I often hear artistic directors say they are looking for "personality" at auditions. This can translate into strong interpretive skills, and effective acting - more than just a generic vocal colour or fake gestures.  I would also say, more than anything, they do not want just "good technique"; they  want to feel the singer can command the stage.  For a lead role, they want star power, that extra "special quality", feeling the singer inhabits the role and exudes confidence. 

I'm sure they are also considering how this singer will look in costume, and how a voice would sound in their performance space. Canada has just a few facilities that suit opera specifically, and many are very large - so, the voice needs to soar over an orchestra to the back row of their hall, which might hold 3000 seats. 

Artistic directors are also thinking about the cast in general. In addition to their singing role, marketing departments and publicity people at opera companies rely on artists to be comfortable doing media events, interviews, perhaps singing on the local breakfast TV show to help promote the opera. So, they are also looking for singers to be flexible and open to these added duties, and be dazzling at their fundraising events, too. 
 
I remember one of the first auditions I attended as an agent. As one of my singers left the stage, one person from the company turned to me to say, Nnow, there's someone I could have a beer with!" I interpreted  that to mean they were friendly, easy to talk to, pleasant company - a team player who would fit into the intense rehearsal world and be easy to work with for 4 weeks. (And yes, my singer was hired!)

### How have you seen the operatic industry change in Canada and internationally?      

Several significant changes have taken place since I first stepped onto a professional operatic stage over thirty years ago. One big change my colleagues and I often discuss is the fact that there are so many singers currently pursuing a career! I am astounded at the sheer volume of students enrolled in universities and conservatories in Canada and the US. There have never been any guarantees that studying voice will lead to a busy, financially stable career, but it seems even more of a challenge in 2018 than ever. 

Nowadays, companies are incorporating video and livestream into their marketing campaigns, resulting in singers feeling compelled to spend as much time at the gym or yoga class as in the practice room. Increasingly, directors are interpreting operas in a new light, often placing greater physical demands on singers as they present a "concept" on stage. Publicity materials are more important than ever, and singers need to have an appealing website that includes bio, resume, reviews with photos and audio/video samples. A strong social media presence is also vital today.

With so many singers all vying for places in young artist programs and hoping to gain attention through competitions, there is there is a lot of pressure on singers to make a mark, and *fast*. Combined with concerns over audience attendance and shrinking budgets, rehearsal times are shorter than ever - often just three weeks from day one to opening night. It is a tough world for today's classical singers. 

Another significant change is the rise of young artist programs (YAPs). I attended just two programs outside of my university studies at the University of Toronto: Banff Centre for Arts and Creativity (singing Nannetta in *Falstaff*) and the Britten-Pears Young Artist Programme in Aldeburgh.  I also was fortunate to be a finalist in several competitions, and then invited to join the COC Ensemble Studio. 

After that, I did not seek further programs as I was busy singing professionally in both concert and opera. Today, I see resumes featuring several summer programs, and lots of ["pay-to-sing"](/paid-summer-programs-is-it-time-for-a-revolution/) programs, but often very little evidence of being hired to sing.

With major opera companies having a terrific group of promising young singers on salary, it makes it more difficult than ever for small roles to be filled by outsiders, another big change from previous years. I know it can be  difficult for singers without representation to set up auditions in North America, and it is almost impossible to break into the professional opera scene without a YAP on one's resume. Artistic directors are reluctant to take a chance with an unknown singer.

Another big change is the rise of independent "indie opera" companies, producing innovative and updated versions of classics, as well as new works. These are great opportunities for emerging singers to learn the craft and gain performance experience. These productions bring together audiences eager to explore  opera and singers to share their talents "up close". 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521081351133/DomoneyNAC.jpg.jpg)
<figcaption>Domoney at the National Arts Centre in Ottawa.</figcaption>
</figure>

### How do you unwind and find some respite from all the opera and music in your life?

I am very lucky to combine travel to see my artists perform, visit family, give seminars and attend conferences all over the world, from BC to Boston, and London to Rome. I love quiet pursuits, a leisurely bike ride, attending the ballet, (where nobody sings or speaks!) wandering through museums with a specific focus (London's Victoria & Albert, Toronto's Gardiner Museum, the Bata Shoe Museum, The Frick Collection in NYC), exploring historic homes with grand gardens, then planning and puttering in my own little garden in Toronto.  

I also love losing myself in intense British dramas and historical series on Netflix and Masterpiece, and listening to jazz and Broadway shows is a welcome break from my world of opera and singing. 
