+++
author = ["authors/greg.md"]
categories = "Op-ed"
date = "2016-06-03T10:22:00+01:00"
lastmod = "2016-06-03T14:15:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1464947482057/2016-06-03---King-Arthur.jpg.jpg"
publishDate = "2016-06-03T13:12:00+01:00"
related_articles = ["articles/tfco-opera-trek-the-next-generation.md","articles/the-tfco-a-young-peoples-opera-blitz.md"]
related_companies = ["scene/companies/canadian-childrens-opera-company.md"]
related_people = ["scene/people/dean-burry.md"]
short_description = "Day led us through a survey of the similarities between the two subjects. He explained the idea of the sword as mystical icon, how the sword embedded in stone had its roots in Norse mythology, as Odin stuck his sword in the family tree and said only he who could remove it would rule. The dragon slaying, the underdog being worthy, etc., they are all related to the same source material."
slug = "talking-opera-mythology-with-the-tfco"
title = "Talking opera &amp; mythology with the TFCO"
+++

After having an awesome chat with ["the next generation of opera"](/tfco-opera-trek-the-next-generation/) this past Sunday, I eagerly attended a chat presented by the [Toronto Festival of Children's Opera](http://www.canadianchildrensopera.com/content/TFCO.html) called *Swords and Songs*.

For its inaugural season,  The TFCO is producing two works by composer/librettist [Dean Burry](/scene/people/dean-burry/). The first is *The Sword in the Schoolyard*, a retelling of the legend of King Arthur from the perspective of a group of students as they grow to adolescence, and the second is *The Hobbit*, based on the J. R. R. Tolkien classic. We spoke to [four of the younger cast members](/tfco-opera-trek-the-next-generation/) and we were totally impressed with their eloquence.

"For some of our singers, this may be their first time on stage," says Susan Suchard of [VIVA! Youth Singers](http://www.vivayouthsingers.com/). "They have to give themselves over to the idea of role play, of stepping outside themselves and becoming someone else for a time. It's scary for them at first, but empowering by the end."

As part of the curriculum for the TFCO they treated us to a panel discussion with the creative team after an intriguing and informative presentation by international leading authority on both these subject matters, [David Day](http://www.daviddaybooks.com/), author of a host of books including *A Tolkien Bestiary*.

Day led us through a survey of the similarities between the two subjects.  He explained the idea of the sword as mystical icon, how the sword embedded in stone had its roots in Norse mythology, as Odin stuck his sword in the family tree and said only he who could remove it would rule. The dragon slaying, the underdog being worthy, etc., they are all related to the same source material.

Burry then invited Carol Woodward Ratzlaff, Artistic Director of VIVA! Youth Singers, Teri Dunn of the [Canadian Children's Opera Company](/scene/companies/canadian-childrens-opera-company/), David Ambrose, Director of *The Sword in the Schoolyard* and Mr. Day to the stage to form a panel discussing these operas in particular as well as opera for young performers as a whole. 

The first question was about how one approaches learning pieces like *The Hobbit* and *The Sword in the Schoolyard*, knowing that there's such a mythology behind both of them. The answer was a heartening one, that you do it the same as any other opera, with the same amount of dedication and practice and rehearsal.  Woodward Ratzlaff also offered up that she felt their work on Early Music helped a lot with their preparation, and that it was a "rich topic" for youth - (and I agree).

"The challenge is that we are seeking to develop and integrate several arts, a trend which is timely and relevant," says Woodward Ratzlaff. "The children are beginning to enter another world, to use their creative gifts in new ways. Children's opera is a deeper version of what we do in concert work. In my mind, you can't be a singer and ignore theatre."

The next question dealt with how they brought a sense of the epicness of these two works. The panel agreed that it was embedded in the writing of the music. The design also helps bring the audience to appreciate the scope of it all. Lighting, sets, and costumes are all integral to accomplishing that. Dunn added that because the pieces are so timeless, they can apply in many different scenarios.

After hearing some of Burry's music from the impressive CCOC, the panel returned for more discussion. They opened the floor to questions, and you better believe I was there ready to go.

I asked Burry, why he chose such epic source material for these pieces. His answer was that upon his first reading of *The Hobbit* and *The Lord of the Rings*, he noticed the number of songs that play integral parts to the story. With so much information provided by these songs, he felt it only right to set it as an opera. With *The Sword in the Schoolyard*, he was struck by the rich history of the telling of the Arthurian legend and decided it would be an excellent source for an allegory, as it had already withstood an extreme test of time. I spoke to with the panel about the challenges of working on a show with such a massive scope. Ambrose answered that it's all in making sure the kids understand all that they possibly can about the situations before they're presented.

One of the young singers from VIVA! asked what was probably my favorite question (and I was jealous that I didn't ask it), wondering what Burry thought was more important while writing these operas: the music, or the libretto. His answer: neither. Opera is theatre, and as such it tells stories. It's the story that is the most important and all the art forms that go in to creating this kind of work must serve the telling of the story. #tripleswoontimesinfinity - I'm so glad to know I'm not the only one who thinks this way.

But the real question everyone was asking was, which show did Burry enjoy writing more? And in true diplomatic fashion he responded "I love them both equally".

... do we believe him?

>Get your tickets for [The Sword in the Schoolyard](http://www.canadianchildrensopera.com/content/sword-schoolyard.html), June 3-5, and [The Hobbit](http://www.canadianchildrensopera.com/content/hobbit.html-0), June 9-12!


