+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2015-04-11T00:01:00-04:00"
lastmod = "2015-04-11T00:01:00-04:00"
preamble = "<p>\n\tIf there's one thing that makes me love a composer, it's word painting. What's word painting? It's when you write a musical line for the singer that sounds like the word they're saying. Example: \"Oh no, I am fall-ing down\" on six descending syllables. Zerbinetta's aria from Strauss' <em>Ariadne auf Naxos</em> is one of the densest moments of word painting that I can think of. Here are some fun bits:\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724532966/IMG_20150220_163419-720x533.jpg.jpg"
publishDate = "2015-02-22T09:01:00-05:00"
related_articles = ["articles/tales-from-the-score-violetta.md","articles/nerding-out-mozarts-blurry-barlines.md","articles/tales-from-the-score-deh-vieni-non-tardar.md"]
short_description = "If there’s one thing that makes me love a composer, it’s word painting. What’s word painting? It’s when you write a musical line for the singer that sounds like the word they’re saying. Example: “Oh no, I am fall-ing down” on six descending syllables. Zerbinetta’s aria from Strauss’ Ariadne auf Naxos is one of the densest moments of word painting that I can think of. Here are some fun bits:"
slug = "tales-from-the-score-zerbinetta"
title = "Tales from the Score: Zerbinetta"
+++

<h2>1. "Verwandlungen," or, "Transformations"</h2>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724560157/IMG_20150220_162716-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/JQ5iypATtCVBRbJ9ckf7kQnhMmV1wLeK_cSMbqfMTUDDPVUP8ehk8OuCiMTvNo05DPC4OSqNegJr-Ue5gR1VE3UrSKLk" src="http://lh3.googleusercontent.com/JQ5iypATtCVBRbJ9ckf7kQnhMmV1wLeK_cSMbqfMTUDDPVUP8ehk8OuCiMTvNo05DPC4OSqNegJr-Ue5gR1VE3UrSKLk=s1200"></a></figure>
<p>
	More specifically, "unbegreiflichen Verwandlungen," or "incomprehensible transformations." Look at those mysterious (
	<em>incomprehensible</em>, if you will) chords on the first bar of the page. Where are they going? We all thought those juicy chords would lead to that high B-flat in the second bar, but Strauss take us for a detour. The harmonies literally transform underneath Zerbinetta's strange, meandering cadenza. By the time that happy little F major chord settles in at the end of "Verwandlungen," we're all baffled by where we've ended up. The first of Zerbinetta's many tricks…<br>
</p>
<h2>2. Pagliazzo, Mezzetin, Cavicchio, et al.</h2>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724715828/IMG_20150220_162813-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/ZczJxoTG00M3UJV2RjWByS0e1d5jObV0n4ABUtoPyjGyQWTdFOtrY2ERjS7oxFA06rUN8KFK-pILmAOB1tye5inLov12yg" src="http://lh3.googleusercontent.com/ZczJxoTG00M3UJV2RjWByS0e1d5jObV0n4ABUtoPyjGyQWTdFOtrY2ERjS7oxFA06rUN8KFK-pILmAOB1tye5inLov12yg=s1200"></a></figure>
<p>
	Don Giovanni isn't the only one with a long list of conquests; the nymphomaniacal Zerbinetta starts rattling off her line of lovers, and they all seem to have specific memories attached to their names. Pagliazzo sounds like a comedian, a bundle of energy: look at that cluster of notes over his name, ending upwards, like a raised eyebrow. Mezzetin is next, and he's a much more calculated, clean-cut kind of dude: Zerbinetta says his name with matter-of-factness, almost like Mezzetin had to coach her into the correct pronunciation. Then comes Cavicchio, who somewhat unfairly gets compared to Pagliazzo; but Zerbinetta sings Cavicchio's name higher, and in a more leading harmony. It's as if Zerbinetta had a few "firsts" with Cavicchio, and she can't help but remember them well.
</p>
<h2>3. "Launen" (whim) &amp; "Müssen" (need)</h2>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724754308/IMG_20150220_162841-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/F5YWdoo2o5zrNLRN-k7Pl2fbK0I0H2K6v0Qt2typZtjUPUiqPrhqaLPCeFoyFdhJ6mZr7nlEynp0aPbTPnS94-fuIh8" src="http://lh3.googleusercontent.com/F5YWdoo2o5zrNLRN-k7Pl2fbK0I0H2K6v0Qt2typZtjUPUiqPrhqaLPCeFoyFdhJ6mZr7nlEynp0aPbTPnS94-fuIh8=s1200"></a></figure>
<p>
	The word "Launen" is the one set to all those accented notes on the left hand side. Zerbinetta actually says "never a whim", in reference to the seriousness with which he took up each lover. Those accents are as if she's arguing naysayers on the fly. She moves on to say "never a whim, always a <em>need</em>" (ein Müssen!), in a sexy, sexy setting. Look at that octave leap she has, followed by a smeary, falling chromatic scale; it's as if Zerbinetta had no say in what her voice (body) wants. I love how "Launen" is set in a defensive way, and "Müssen" is much more out-of-body.
</p>
<h2>4. "Nicht versteht" (not understood)</h2>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724814585/IMG_20150220_163046-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/xHNHkRYABt2ss938f1RsT4KosZI5ea4IFcoMH_BSFUlzrgctLk82TzgecG2y4VFIqI-BO8X_8ff8AFO8bxF7mY9jhMZm" src="http://lh3.googleusercontent.com/xHNHkRYABt2ss938f1RsT4KosZI5ea4IFcoMH_BSFUlzrgctLk82TzgecG2y4VFIqI-BO8X_8ff8AFO8bxF7mY9jhMZm=s1200"></a></figure>
<p>
	Zerbinetta is in the middle of talking about how she gets swept up by all these lovers and doesn't totally understand why ("nicht versteht"). Now, the above cadenza is usually sung on "ah", but it still belongs to the words "nicht versteht". How better to sing incomprehension than a halting, misguided cadenza like this; sure, it's got direction, but a smart Zerbinetta will figure out how to organize this mess of notes, and in most cases you're left with shorter, broken phrases. I think by the end of this cadenza, Zerbinetta either has a lightbulb moment of self-diagnosis, or she's decided to stop overthinking all the fun she's been having and get on with the song.
</p>
<h2>4. "Hingegeben" (surrendered)</h2>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428724860521/IMG_20150220_162625-1024x758.jpg"><img data-resize-src="http://lh3.googleusercontent.com/nFWp58cZ7I39C8eiLQsYin3ZMafd7idnl_v_wwcNLdsq6Qoz7FPxrbRIG1fuHKf9prQ4-gdCI1vt2bEKZKHwoQjEHpJN" src="http://lh3.googleusercontent.com/nFWp58cZ7I39C8eiLQsYin3ZMafd7idnl_v_wwcNLdsq6Qoz7FPxrbRIG1fuHKf9prQ4-gdCI1vt2bEKZKHwoQjEHpJN=s1200"></a></figure>
<p>
	This is one of the hardest passages in Zerbinetta's aria, and we're definitely building towards the grand finish. I love this setting of the word, "hingegeben", meaning "surrendered", or "given over to". The music has stayed relatively tonal, in a recognizable D major for the last couple of pages, and so when the orchestra starts sweeping by with those unexpected, Zerbinetta finds herself at the mercy of one mystery chord after another. She starts the word "hingegeben" in unison with the orchestra, and then continues on as if improvising, jamming out to the weird chord progression she can't control. And like textual icing on the cake, she finished this wild phrase with "war ich stumm" ("I was speechless"). Cute and ironic.
</p>
