+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2014-12-15T08:00:00-05:00"
lastmod = "2015-04-13T22:27:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428978347085/TraviataPrelude.jpg.jpg"
publishDate = "2014-12-15T08:00:00-05:00"
related_articles = ["articles/tales-from-the-score-zerbinetta.md","articles/tales-from-the-score-peter-grimes.md","articles/tales-from-the-score-annas-innocence.md","articles/nerding-out-mozarts-blurry-barlines.md","articles/the-score-how-to-see-what-a-composer-sees.md"]
short_description = "Verdi&#039;s La traviata is one of those operas, like Il barbiere di Siviglia or Die Walküre, that&#039;s so full of famous stories and tunes that the real significance of these moments is almost forgotten. But because it&#039;s Verdi, let&#039;s not dock him points for being obvious."
slug = "tales-from-the-score-violetta"
title = "Tales from the score: Violetta"
+++

Verdi's _La traviata_ is one of those operas, like _Il barbiere di Siviglia_ or _Die Walküre_, that's so full of famous stories and tunes that the real significance of these moments is almost forgotten. But because it's Verdi, let's not dock him points for being obvious. I'm sure every opera fan has own favourite bits from _La traviata_, including the tragic first few bars, pictured above, that scream "foreshadowing! Foreshadowing!" very loudly in Italian. I chose a few musical moments that I feel act as dramatic checkpoints within the story of Violetta and her Alfredo.

## Exhibit A:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428977902681/Traviata2.jpg.jpg)
</figure>

If you don't know what this bit of music is, I won't say _shame on you_, but[ just click here](https://www.youtube.com/watch?v=z1ohegoq_IA) and get yourself up to speed. This drinking song is at the top of the show, the scene where we meet and get to know Violetta and Alfredo. Alfredo starts the song with a solo verse, and then the chorus join in. The song could essentially stop there, but the action halts, and Violetta picks up the second verse. There's nothing new or unique about the form Verdi uses in this number, and the tune is catchy because there aren't any surprising harmonies to throw you off. But there's something about the masculine _oom-pah-pah_ happening in the strings, about the build up of sound from solo tenor, to _tutti_ chorus, and then a deafening silence as Violetta keep the party going. Even her text, starting with "Tra voi, tra voi saprò dividere il tempo mio giocondo" (Or, "I know how to share the fun between all of you") sounds like it has gonads. The rolled R and syntactically doubled V in "voi" (thanks, Italian diction class!) make me think Violetta starts stomping in the big boots she was secretly wearing under her work attire. The way she sings to the room is full of confidence (perhaps too much?), and teasing, like when women wear men's suits and still look feminine. It's something about Violetta taking Alfredo's tune for her own; it's overt flirting, of course, on two levels. One is visible to the public, and the other is just for the two of them.

## Exhibit B:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428977968429/TraviataGermont.jpg.jpg)
</figure>

This is from Act II, which happens three months after the end of Act I. It's the fantastically incredible scene with Violetta and Germont, Alfredo's father. Germont comes to convince Violetta to leave his son, pulling all the best self-esteem jabs along the way. He plays the God card, and the make-it-her-problem card ("Be an angel for our family"). Above, he's playing the vanity card: "One day, when the fire is gone, he'll get bored. Then what?" Now, I'm sure a good dramaturg _could_ make the case that Germont has some good intentions in this scene. But I always winced at how he constantly assumes that Alfredo couldn't _really_ love Violetta, probably because she's an escort. He does it here, in those snakey little voice quavers that Verdi writes, on the scariest words like "lust" and "fled" and "feelings". The classic _oom-pah_ sounds like a good ghost story is about to unfold, and Germont tells the whole thing . What a dirty move, to tell a woman whose looks are her means that she has nothing to offer when she ages. You can hear him talking down to her. And it's the worst, because he probably thinks he's doing a good deed. Villains, right?

## Exhibit C:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428978017744/TraviataEnd3.jpg.jpg)
</figure>

This is from Violetta's third act aria, "Addio del passato", when she's sick, alone, and almost broke. She starts the aria remembering her life, and grieving its near end. It's a simple aria (yet not simple to sing), and simplicity is always the best way to make small changes feel massive. Like when it moves heartbreakingly from minor to major, in the top line of the above score. She asks God to smile upon her as she dies, a big ask for sex worker in 19th-century Italy. It's that whole thing where watching someone cry doesn't pack the same punch as watching someone try not to cry. I wouldn't say La traviata is about Violetta's relationship with God, but her sense of self-worth are major factors in her life decisions (sound familiar, anyone?). So when she escapes the natural minor key of her aria, and moves briefly into that sunny, upwards-looking major key, it makes me think of desperation and real hope. She also refers to herself as "la traviata", the fallen woman; she must believe it to be true, because she mentions it almost as a caveat to her asking God's forgiveness. Ugh. That Violetta believes herself to be a fallen woman is the saddest part, I think.

## Exhibit Obligatory

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428978149641/TraviataEnd.jpg.jpg)
</figure>

This is from Violetta's third act aria, "Addio del passato", when she's sick, alone, and almost broke. She starts the aria remembering her life, and grieving its near end. It's a simple aria (yet not simple to sing), and simplicity is always the best way to make small changes feel massive. Like when it moves heartbreakingly from minor to major, in the top line of the above score. She asks God to smile upon her as she dies, a big ask for sex worker in 19th-century Italy. It's that whole thing where watching someone cry doesn't pack the same punch as watching someone try not to cry. I wouldn't say La traviata is about Violetta's relationship with God, but her sense of self-worth are major factors in her life decisions (sound familiar, anyone?). So when she escapes the natural minor key of her aria, and moves briefly into that sunny, upwards-looking major key, it makes me think of desperation and real hope. She also refers to herself as "la traviata", the fallen woman; she must believe it to be true, because she mentions it almost as a caveat to her asking God's forgiveness. Ugh. That Violetta believes herself to be a fallen woman is the saddest part, I think.

For the full picture, I offer up this 2007 LA Opera production of La traviata, with James Conlon conducting Renée Fleming, Rolando Villazòn, and Renato Bruson.

<figure data-type="video">
<iframe width="680" height="382" src="https://www.youtube.com/embed/1-jHIfm3_oI" frameborder="0" allowfullscreen></iframe>
</figure>

