+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-01-05T14:40:00-05:00"
lastmod = "2015-04-12T11:30:00-04:00"
preamble = "<p>\n\tBenjamin Britten rarely fails to make me marvel at the art of composing opera. I tend to be a sucker for misunderstood protagonists, and Britten writes operas like <em>The Turn of the Screw</em> and <i>Albert Herring</i> with such understanding that it pulls at my heart. <a href=\"http://www.theguardian.com/music/2013/nov/19/benjamin-britten-1945-introduction-to-peter-grimes\" target=\"_blank\"><em>Peter Grimes</em></a> is the story of a fisherman who hires young boys to help him on his boat, and one of those boys has turned up dead; in a small town like <a href=\"http://www.theguardian.com/books/2013/jun/14/britten-george-crabbe-drowned-voice\" target=\"_blank\">The Borough</a>, Peter is left victim to both a trial and a mob of suspicious townsfolk. Now, Peter isn't good with most people, let alone children; I think he <em>is</em> responsible for the boy's death, by overestimating how much a child could handle on a stormy fishing trip. Even if you disagree with my take on the character of Peter, Britten's sympathy with the scorned fisherman is a deep one. I have a personal adoration for this score, and was lucky enough to work on the <a href=\"http://www.theglobeandmail.com/arts/theatre-and-performance/theatre-reviews/canadian-opera-company-has-a-magnificent-tragedy-in-peter-grimes/article14720625/\" target=\"_blank\">Neil Armfield production of <em>Peter Grimes </em>at the COC in 2013</a>. Here are a few magical spots I found along the way.\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428852413473/PeterGrimesFeature.jpg.jpg"
publishDate = "2015-01-05T14:40:00-05:00"
related_articles = ["articles/tales-from-the-score-violetta.md","articles/3-ways-to-fight-boredom-at-the-opera.md"]
short_description = "Benjamin Britten rarely fails to make me marvel at the art of composing opera. I tend to be a sucker for misunderstood protagonists, and Britten writes operas like The Turn of the Screw and Albert Herring with such understanding that it pulls at my heart. Peter Grimes is the story of a fisherman who hires young boys to help him on his boat, and one of those boys has turned up dead; in a small town like The Borough, Peter is left victim to both a trial and a mob of suspicious townsfolk."
slug = "tales-from-the-score-peter-grimes"
title = "Tales from the score: Peter Grimes"
+++

<h4>Exhibit A:<br>
</h4>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428852430097/PeterGrimes6.jpg"><img data-resize-src="http://lh3.googleusercontent.com/5ux95JIQUlYa-L1TSHyjmdbh_UKJM43x1RT6cnxLO7eqLDkPi0bIpWWFXPKGhWXucPEadx1QKXW2u7_GgUg7IeQ1R3Ax2g" src="http://lh3.googleusercontent.com/5ux95JIQUlYa-L1TSHyjmdbh_UKJM43x1RT6cnxLO7eqLDkPi0bIpWWFXPKGhWXucPEadx1QKXW2u7_GgUg7IeQ1R3Ax2g=s1200"></a></figure>
<p>
	This is from Act I, where Peter tells one of his only friends, Balstrode, about what happened on the night of the boy's death. He describes the stormy weather, the shortage of drinking water for him and the boy. He tells Blstrode about how "the boy's silent reproach turned to illness", and how Peter came home in the boat alone. Look on the score above at the setting of the word "alone". The interval is a painful minor ninth, leaning on that F-natural and finally wailing up to a high A. The word "alone" of course applies to Peter's lack of company upon returning the boat; but when set the way Britten does, it's got to mean more. "Alone" starts to sound like "I am alone" in the more depressing, broad sense. It's Peter's mourning of what happened that day; it might just be his aloneness that will keep him a villain in the eyes of The Borough. More on that topic:
</p>
<h4>Exhibit B:</h4>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428852465602/PeterGrimes5.jpg"><img data-resize-src="http://lh3.googleusercontent.com/-UNnZwhSNfV39XovaY2_DYZYkzq3YqCJtw71V4ALSA6-J3jNplrnEgswpE6AOj71G2T1OJT8Ur1s4ePwmFE2dJpgAd8" src="http://lh3.googleusercontent.com/-UNnZwhSNfV39XovaY2_DYZYkzq3YqCJtw71V4ALSA6-J3jNplrnEgswpE6AOj71G2T1OJT8Ur1s4ePwmFE2dJpgAd8=s1200"></a></figure>
<p>
	This is from the end of that entrancing scene near the end of Act I, where Peter walks into the town pub and starts babbling about the stars and the nighttime. I paraphrase very much, but he asks a question, "Can one ever undo a moment in one's life?" This aria is written largely on the Peter Pears note (E natural, with which most other tenors take issue), with gently falling figures in the strings underneath. These figures evolve, starting with a few notes trailing down from that E-natural, then growing longer and falling father. Lok at the word "back". It's the longest falling pattern written for Peter, almost a note too many, as though the phrase "turn back" was caught in his throat and replaced with a sob. What a desperate way to ask a serious question, and what a buzzkill for a pub.
</p>
<h4>Exhibit C:<a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428852500698/PeterGrimes4_Fotor.jpg"><img data-resize-src="http://lh3.googleusercontent.com/DWwSG92gskkKx9bHfRq5t4TuxUGzGSgEqFYXwT9vl1DktASBi9-_aQXSvwDD5-n0O4O9MT7lQ4yvjD5NdxbFbmO7ans" src="http://lh3.googleusercontent.com/DWwSG92gskkKx9bHfRq5t4TuxUGzGSgEqFYXwT9vl1DktASBi9-_aQXSvwDD5-n0O4O9MT7lQ4yvjD5NdxbFbmO7ans=s1200"></a></h4>
<figure data-type="image"></figure>
<p>
	Let's break away from Peter for a second to look at the significant female characters in <em>Peter Grimes</em>. This is a bit from the stunning quartet sung by Ellen Orford, who loves Peter, Auntie, who owns the town pub, and the two "nieces", working for Auntie under questionable job descriptions. This quartet happens just as most of The Borough leaves as an angry mob, headed towards Peter's hut to take judicial matters into their own hands ("Popular feeling's rising!"). The women talk about their roles as caregivers in the community; in their lowly status, they ask if they deserve to feel lonely. ("From the gutter, why should we trouble at their <a href="http://www.merriam-webster.com/dictionary/ribaldry" target="_blank">ribaldries</a>?"). These women contribute to their community in ways that are kept secret, and in public they are forgotten and discarded. The bit of music above shows the refrain to which the ladies keep returning: "Do we smile or do we weep or wait quietly till they sleep?" Look at how Britten sets the text for these women. Ellen and Auntie have the top and bottom lines, and although they share a similar rhythm, their melodies diverge. Ellen rises higher and higher, gently and confidently, like a strong woman who has yet to lose her optimism. Auntie starts in her familiar chest voice, her tune slightly angular, and her lower climactic moment sounds like resignation, as if to say, "this happens every time". The Nieces share the middle line, slightly out of sync with the two other women. Britten uses this "wrong rhythm" to make the girls sound less sure, less steady, and more hurt. These young girls are the most affected by their town's neglect; they share rolling melismas at the end of each refrain, on he word "till". The younger you are, the slower time seems to pass.
</p>
<h4>Exhibit D:<a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428852538094/PeterGrimes2.jpg"><img data-resize-src="http://lh3.googleusercontent.com/-Xgtca_mOPPLMWn4YdwTbTnY8th6P3LurK_q229PWQqtdeVAPngsEVCJYzligtYfWOX0qShu0ISOrkcOI3niuLk9HmwZuw" src="http://lh3.googleusercontent.com/-Xgtca_mOPPLMWn4YdwTbTnY8th6P3LurK_q229PWQqtdeVAPngsEVCJYzligtYfWOX0qShu0ISOrkcOI3niuLk9HmwZuw=s1200"></a></h4>
<figure data-type="image"></figure>
<p>
	What's so scary about this mob, anyway? They're just people, right? Peter may be a sensitive guy, but I'll posit that there's nothing scarier than an ill-informed, xenophobic, bored group of small-towners with weapons. For me, the reason for Peter's aloneness is in the above section of music. The whole town is frothing at the mouth over the prospect of arresting Peter for his crimes (which were officially deemed "accidental circumstances", but whatever), and they get themselves into such a bloodthirsty tizzy that culminates into hysterical laughter. The music here is absolutely unreal. The din, the <em>noise</em> of it all, finally comes to a point of unison, with everyone onstage singing triumphantly and dangerously and almost freely, under grossly placed laughing syllables, "Ha! Ha! Ha!" I just gave myself a shudder. It's one of the moments, both musically and dramatically, that make <em>Peter Grimes</em> a must-see.
</p>
<p>
	In case I've piqued your interest: I know that I should be telling you to listen to <a href="http://www.youtube.com/watch?v=rCVNAYikjbE" target="_blank">Peter Pears' performance of <em>Grimes</em></a>, but I'm not going to. I'm partial to Jon Vickers, because he's a volatile mess of pitiful and dangerous, and his voice...that voice. I entice you with this clip of Vickers' Peter Grimes; it's Peter's mad scene, from the end of the opera. It's written to be part monologue, part anti-overture. Britten brings back plenty of musical mini-themes that we've heard over the whole opera; the effect is the traditional wrapping-up of the story, combined with that operatic staple, the Mad Scene. It's so, <em>so</em> good.
</p>
<figure data-type="video">
<iframe src="//www.youtube.com/embed/OWT0jsCbl28" width="420" height="315" frameborder="0" allowfullscreen="allowfullscreen">
</iframe>
</figure>
<p>
	<br>
</p>
