+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2016-07-19T11:40:00-04:00"
lastmod = "2016-07-19T13:48:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468948368937/2016-07-19---Figaro-MC-1107.jpg.jpg"
primary_image_credit = "Josef Wagner (Figaro), Jane Archibald (Susanna) in the COC’s production of The Marriage of Figaro, 2016, photo: Michael Cooper"
publishDate = "2016-07-19T13:48:00-04:00"
related_articles = ["articles/tales-from-the-score-zerbinetta.md","articles/tales-from-the-score-annas-innocence.md"]
short_description = "This aria is so often sung that we can become immune to its effect in the context of the entire opera. It&#039;s incredibly difficult to play all the musical and dramatic layers when singing the aria alone in an audition or concert. But it can be tons of fun to pretend (to pretend to pretend, really) that Susanna is imagining herself a Real Lady, and finally gets the chance to try it out. It&#039;s very Eliza Doolittle, when you think about it."
slug = "tales-from-the-score-deh-vieni-non-tardar"
title = "Tales from the score: Deh vieni, non tardar"
+++

[Susanna's aria](/aria-guides-deh-vieni-non-tardar/) from the final act of *Le nozze di Figaro* is constantly fascinating. At its simplest, it's a seductive call into the dark for her lover. Yet, Susanna has planned this tryst with the Countess; they are disguised as each other, hoping to trap the Count in his dirty ways. To complicate things further, Figaro has heard about Susanna's plans, and Susanna has heard that Figaro has heard. This aria is a layers-thick trick, which Susanna sings to Figaro, making him think she's singing to the Count (and enjoying it). 

So, this aria is all at once a) a lie, b) a true seduction of Figaro, and c) Susanna in disguise. That latter part informs the music, which looks and sounds much more Countess-like than like Susanna. For instance, she gets an extended accompagnato recit, a device largely reserved for noble characters instead of maids:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468942746665/2016-07-19---Deh-Vieni-Tales-1.jpg.jpg)
</figure>

There's Classical grace in this opening, very round, very symmetrical. The key belies Susanna's station a little bit; keys like C, G, and F major are popular picks for Mozart's soubrettes (think Despina and Zerlina, compared to Fiordiligi and Donna Anna). Yet the accompagnato form makes Susanna speak a little slower than the rapid patter she's had for much of the opera; she delivers organized, calm thoughts in a collected way. She even uses some lower, Countess-inspired notes to get the infusion of lust into this recit; words like "foco" and "notte" couldn't be sexier:

<figure data-type="image">![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468942832714/2016-07-19---Deh-Vieni-Tales-2.jpg.jpg)
</figure>

Again, Susanna sings a rich woman's aria in a poor woman's key. There's a simple dance rhythm inherent in the 6/8 meter, but it's controlled, not improvisatory or perky. The passing F-sharp in "Vieni ove amore" is just the kind of subtle sexuality that the Countess would infuse in her words; it's almost as though Susanna is playing dress-up, recalling the few moments of flirtation she heard from the Countess and trying them on herself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468942767398/2016-07-19---Deh-Vieni-Tales-3.jpg.jpg)
</figure>

These long "vieni's" (below) are similar to the Countess' "Porgi, amor", and the dramatic difference between the two arias is rich with meaning. For the Countess, those long notes meant yearning and wishing; for Susanna, they're lures for her lover. Similar, yet very different. The two phrases on "ti vo' la fronte incoronar" are totally regal and womanly; even the brief moment of coloratura is controlled and thought out.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468942776313/2016-07-19---Deh-Vieni-Tales-4.jpg.jpg)
</figure>

Finally, the end of this aria is like a very expensive gift, wrapped in an expensive bow. It's the opposite of showing off, despite the small cadenza Susanna sings on the last "incoronar". Instead, it's making her audience (Figaro, the Count, whoever) yearn for more; it's as if Susanna has just sung the first verse of what could be a hot, hot duet.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468942784494/2016-07-19---Deh-Vieni-Tales-end.jpg.jpg)
</figure>

This aria is so often sung that we can become immune to its effect in the context of the entire opera. It's incredibly difficult to play all the musical and dramatic layers when singing the aria alone in an audition or concert. But it can be tons of fun to pretend (to pretend to pretend, really) that Susanna is imagining herself a Real Lady, and finally gets the chance to try it out. It's very Eliza Doolittle, when you think about it.

For more, check out our "Deh vieni, non tardar" [Aria Guide](/aria-guides-deh-vieni-non-tardar/).
