+++
author = ["authors/jenna.md","authors/jessica-lane.md"]
categories = "Interview"
date = "2016-08-01T11:54:00+01:00"
lastmod = "2016-08-02T11:41:00+01:00"
preamble = "Each summer at the [Kammeroper Schloss Rheinsberg](https://www.kammeroper-schloss-rheinsberg.de/) (Chamber Opera at Rheinsberg Castle), young singers from around the world foster their craft and gain valuable performance and networking experience in Germany. This year, they present three productions (Handel's *Alcina*, Puccini's *Tosca*, and the new *Mozart in 90 Minutes*), cast by the winners of the Kammeroper Schloss' vocal competition.\n\nCanada is well-represented this summer in Rheinsberg's production of *Tosca*, including stage director Brian Deedrick, conductor [Gordon Gerrard](/scene/people/gordon-gerrard/), baritone Tyler Fitzgerald (Scarpia), and soprano (and Schmopera contributor) [Jessica Lane](/scene/people/jessica-lane/), who sings the title role. We had the chance to chat with these four artists about the value of spending time at Kammeroper Schloss Rheinsberg, and the special experience of working with a truly international team.\n\n*Tosca* opens August 6th, and runs for 8 performances until August 13th at Rheinsberg's Heckentheater. [Click here](http://shop.reservix.de/off/login_check.php?id=c6ec16e8cf3cd5077514ebef590a1f763d4616b372ef8900411779bf6bedf213&vID=13813) to book your tickets."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470076790939/2016-08-01---Rheinsberg-Castle.jpg.jpg"
publishDate = "2016-08-02T10:57:00+01:00"
related_people = ["scene/people/jessica-lane.md","scene/people/gordon-gerrard.md"]
short_description = "&quot;I think the most important thing I&#039;ve learned working in Germany over the summer is patience and flexibility during the rehearsal process. With so many people coming from various backgrounds and with so much interpreting and so many languages, you have to be patient with both yourself and everyone else as we all slowly but surely figure out the story we want to tell.&quot;"
slug = "tales-from-the-kammeroper-at-rheinsberg-castle"
title = "Tales from the Kammeroper at Rheinsberg Castle"
+++

## Can you describe a day in the life at this summer's Rheinsberg Festival?

**Gordon Gerrard**: First of all, the performances are all outdoors (as long as it doesn't rain), so a typical day now involves a 4-hour morning rehearsal on the stage of the Heckentheater (literally the Theatre in the Hedge) and then a break during the hottest hours of the day, and then usually a rehearsal again from 7-10, accompanied by mosquitoes as large as birds.

**Jessica Lane**: Let me start by stating our team motto thus far: Rheinsberg is a very special place.

We meet every morning in the canteen for a traditional east German breakfast of...cold cuts. I mean, there is always cereal, yogurt and boiled eggs but the cold cuts win for the ever looming presence at meals. Then, if the weather is good, we head over to the Hecken Theatre where we we'll ideally, weather permitting, be performing a run of eight shows.

We work 10-2 or until it gets so hot on the stage we all lose it. Then, it's back to the Schloss for lunch and, on the hot days, a swim in the lake. We go back to rehearsal 7-10 (with our stomachs full of cold cuts) after spending the afternoon waiting to connect to the precious internet or heading to the Edeka for our nightly supply of wine and chips.

**Tyler Fitzgerald**: As Jessica said, Rheinsberg is quite a special place! Living and working in a castle for two months is quite a unique experience, to say the least. I would liken a day in the life here as an opera boot camp. 

**Gerrard**: It's a truly international cast of young singers. English is mostly the language of rehearsal, but there is definitely a fair bit of German being thrown around, and some translating into Russian. I've managed to pick up a Russian word or two.

**Brian Deedrick**: I know this sounds very Canadian, but the hardest thing to get used to is the great big pause in the middle of the day. After the morning staff meeting and those desperately needed great big cups of coffee, the rehearsal day starts out in a relatively familiar way...IF you can get over the fact that there's no such thing as a Stage Management team, and that the rehearsal will take place in an interesting combination of English, German, lots of incomprehensible Russian, Italian and even more Pidgin and pantomime in between.  

All that, and remembering to put on enough sunscreen and mosquito repellent to get you through the outdoor session in the outdoor theatre, dating from 1758.  But then, there's a five-hour break for the crew to work on the set, and for the stage floor to cool off enough to keep a dead Scarpia from developing third-degree burns on his back. Thank goodness for red wine and fellowship at the end of the day.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470075831616/h4Pn-x4S2t3LCVFrMGMkVAx-eDcs0fysIpeQNVjDdLx4AihOupfoZb-c-8CrIGSIHJzK7pPMFf8hrKiGAXSkOXxJDl6n%3Dw1360-h1360)
<figcaption>Jessica Lane, soprano & participant, Kammeroper Schloss Rheinsberg, 2016.</figcaption>
</figure>

## What is important for young artists to know about working in Germany? How does the Festival prepare these artists for a European career?

**Deedrick**: Summer festivals, particularly for young artists, are ubiquitous in Canada and the States....in Europe, not so much.  I think that has a lot to do with why hundreds of young singers from all over Europe and Russia auditioned to be a part of this year's festival in Rheinsberg.  (Needless to say, I'm doubly delighted that TWO Canadian singers were selected to come for *Tosca*!)  

One of the first things to realize or recognize, if a young North American wants to build a career in Europe, is the sheer number of artists from all over the world want to do exactly the same thing.  In Russia alone, close to a hundred young singers auditioned in Moscow to come to Rheinsberg, and the quality has been amazing.  The festival is a place for singers to be seen and heard, to be reviewed in the German press, to make connections in the European music scene, and to determine if the European system is for them. 

**Fitzgerald**: This festival auditions a large number of singers from across Europe, so the singers that you end up working with here give you a good taste of the level of talent in your own pool in the very competitive European market. 

I think it’s important that when you make the commitment to spend time in Germany in either a working or audition situation, getting in touch with what makes you unique as an artist becomes primary to ones 'success' - whatever your version of the definition of that term means to you. Trying to be someone or something other than what you are is a waste of time. It's taken me awhile to realize that people much prefer to hear honest singing - flaws and all, to me attempting to channel someone else. 

**Gerrard**: The challenges of building a career here seem very similar in many ways to building a career at home in Canada. You have to be prepared to audition all the time. There are certainly more opportunities here, but it's still very competitive. If anyone is interested in exploring career possibilities here, I think you need to start with the basics of German. This festival is really quite well-known in Germany, so the potential for exposure here is quite important.

**Lane**: I think the most important thing I've learned working in Germany over the summer is patience and flexibility during the rehearsal process. With so many people coming from various backgrounds and with so much interpreting and so many languages, you have to be patient with both yourself and everyone else as we all slowly but surely figure out the story we want to tell.

In this way, I feel like I'll know what to expect coming into production in a European country should I get the opportunity to again. It's a whole lot of gesturing, explaining in fragmented languages, laughing and crying but it's a little like altitude training in that now that we've done this, everything else will be easier.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470076348839/2016-08-01---Gordon-Gerrard-HS2.jpg.jpg)
<figcaption>Gordon Gerrard, conductor, *Tosca* at Kammeroper Schloss Rheinsberg, 2016.</figcaption>
</figure>

## What does this summer's line-up of shows offer to young artists?

**Lane**: Along with the fully staged *Tosca* with orchestra, this year's festival included a Mozart mash-up of sorts very early on the festival which was performed by two men and two women. In addition, there was a fully staged, single cast *Alcina* with Baroque orchestra and the interesting and often effective jazz ensemble. We've also performed galas with orchestra and concerts with piano all over eastern Germany.

This line-up explored so much repertoire and every possible style of singing (including musical theatre, Elvis, Frank Sinatra) and the chance to perform it with orchestra. Sehr wunderbar.

**Fitzgerald**: For me, this festival offers me the incredible opportunity to attempt a dream role that frankly, some people may say I'm crazy to attempt at this stage of the game. But in reality, singing Scarpia in *Tosca* has been the most rewarding musical and dramatic challenge that I’ve faced in my journey yet. I have Brian, Gordon, and my amazing mentor Kimberly Barber to thank for inspiring me to trust my own judgement about what I know that I’m capable of doing. 

**Deedrick**: As with any show in a smaller venue, **Alcina**, **Tosca** and the many concerts give the singers an opportunity to learn a new role, to try it out in a relatively safe location, to learn about the highs - and lows - of European "Regietheater", and to work in an incredibly international environment.  I know this sounds kinda corny, but the United Nations atmosphere of this Rheinsberg summer is one of the most important things that will stay with me forever: we've all come together with this mutual love for music and art. VISSI D'ARTE!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1470134463695/2016-08-02---Tyler-Fitzgerald.jpg.jpg)
<figcaption>Baritone Tyler Fitzgerald, singing Scarpia in *Tosca* at the Kammeroper Schloss Rheinsberg.</figcaption>
</figure>

## What have been some highlights of your time in Rheinsberg thus far?

**Gerrard**: It's a wonderful group of people, and we really are meeting all the challenges as a team. It's nice to have a great Canadian contingent here - Brian Deedrick, Bretta Gerecke, Tyler Fitzgerald and Jessica Lane. It's also a truly beautiful place. And we're just an easy train-ride from Berlin - a day off in Berlin is never a bad thing.

**Lane**: Although it may be the typical, lame response, the highlights have been meeting and making beautiful art with the most amazing young singers and artists I've ever met. Each day is filled with challenges but met with incredible bravery, strength and commitment. This production and experience is one I will never forget.

**Fitzgerald**: The single greatest highlight for me has been playing what I think, is the most bad-ass character in opera with an awesome collection of people. 

**Deedrick**: Finding out that Russians have to be just about the funniest people alive! Cold white wine at the town's only Greek restaurant. Being brought to tears again and again throughout the rehearsal process...these people are passionate!
Sharing a rehearsal room with the likes of designer Bretta Gerecke and conductor Gordon Gerrard...two more Canadians! Realizing just how well Canadian standards for the training of young singers stands up in the world of music. Having more than forty friends and family members from all over the world showing up for the two openings this coming weekend! Simply being a part of this extraordinary coming together to create and discover!

Oh yeah....and Jessica Lane's red dress!!!
